/*
 * Decompiled with CFR 0.152.
 */
package org.openhealthtools.ihe.atna.context;

import java.lang.reflect.Method;
import org.openhealthtools.ihe.atna.context.AbstractModuleContext;
import org.openhealthtools.ihe.atna.context.SecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SecurityContextInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityContextInitializer.class);
    private static final String[] DEFAULT_MODULES = new String[]{"org.openhealthtools.ihe.atna.nodeauth", "org.openhealthtools.ihe.atna.auditor"};
    private static final String MODULE_INITIALIZER_CLASS = ".context.ContextInitializer";
    private static final String MODULE_INITIALIZER_METHOD = "defaultInitialize";

    private SecurityContextInitializer() {
    }

    public static void initialize(SecurityContext context) {
        if (context.isInitialized()) {
            return;
        }
        SecurityContextInitializer.initializeDefaultModules(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeDefaultModules(SecurityContext context) {
        if (context.isInitialized()) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("SecurityContext default module initializer starting");
        }
        for (int i = 0; i < DEFAULT_MODULES.length; ++i) {
            String moduleName = DEFAULT_MODULES[i];
            try {
                LOGGER.debug(moduleName + MODULE_INITIALIZER_CLASS);
                Class<?> clazz = Class.forName(moduleName + MODULE_INITIALIZER_CLASS);
                Method method = clazz.getMethod(MODULE_INITIALIZER_METHOD, null);
                Object invokeResult = method.invoke(clazz.newInstance(), (Object[])null);
                if (!(invokeResult instanceof AbstractModuleContext)) {
                    throw new IllegalArgumentException("Initializer method did not return correct type");
                }
                context.registerModuleContext(moduleName, (AbstractModuleContext)invokeResult);
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.info("SecurityContext module " + moduleName + " initialized");
            }
            catch (ClassNotFoundException cnfe) {
                LOGGER.warn("SecurityContext module " + moduleName + " not found, skipping.");
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Stack trace: ", (Throwable)cnfe);
            }
            catch (NoSuchMethodException nsme) {
                LOGGER.warn("SecurityContext module " + moduleName + " does not support default initialization, skipping.", (Throwable)nsme);
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Stack trace: ", (Throwable)nsme);
            }
            catch (Throwable t) {
                LOGGER.error("Error initializing SecurityContext module " + moduleName, t);
            }
            continue;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("SecurityContext default module initializer ending");
        }
    }
}

