/*
 * Decompiled with CFR 0.152.
 */
package org.openhealthtools.ihe.atna.context;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.openhealthtools.ihe.atna.context.AbstractModuleContext;
import org.openhealthtools.ihe.atna.context.SecurityContextInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SecurityContext
implements Serializable {
    private static final long serialVersionUID = -9442092576326191L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityContext.class);
    private final Map<String, AbstractModuleContext> contexts = Collections.synchronizedMap(new HashMap());
    private boolean isInitialized = false;

    protected SecurityContext() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Creating SecurityContext");
        }
    }

    public AbstractModuleContext getModuleContext(String name) {
        return this.contexts.get(name);
    }

    public Map<String, AbstractModuleContext> getAllRegisteredContexts() {
        return Collections.unmodifiableMap(this.contexts);
    }

    public void registerModuleContext(String moduleName, AbstractModuleContext context) {
        this.contexts.put(moduleName, context);
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public synchronized void initialize() {
        if (this.isInitialized()) {
            return;
        }
        SecurityContextInitializer.initialize(this);
        this.isInitialized = true;
    }

    public String toString() {
        return this.hashCode() + "; cCount=" + this.contexts.size();
    }
}

