/*
 * Decompiled with CFR 0.152.
 */
package org.openhealthtools.ihe.utils;

import java.net.InetAddress;
import java.net.UnknownHostException;

public class OID {
    static int sequence = 0;
    static final String rootPrefix = "1.2.820";
    public static final int OID_MAX_LENGTH_DEFAULT = 256;

    public static String createOID(String organization) {
        ++sequence;
        byte[] hostip = new byte[4];
        try {
            InetAddress localhost = InetAddress.getLocalHost();
            hostip = localhost.getAddress();
        }
        catch (UnknownHostException e) {
            hostip[0] = 127;
            hostip[1] = 0;
            hostip[2] = 0;
            hostip[3] = 1;
        }
        int[] mac = new int[]{0, 2, 138, 74, 253, 172};
        for (int i = 0; i < mac.length; ++i) {
            mac[i] = (int)((double)(hostip[i % hostip.length] - mac[i]) * Math.random());
        }
        String macString = "";
        for (int i = 0; i < mac.length; ++i) {
            macString = macString + OID.format(mac[i]);
        }
        if (organization == null) {
            organization = "99999";
        }
        String root = "1.2.820." + Integer.parseInt(organization);
        String suffix = macString + "." + System.currentTimeMillis() + "." + sequence;
        int maxSuffix = 55;
        if (suffix.length() > maxSuffix) {
            suffix = suffix.substring(0, maxSuffix);
        }
        String result = root + "." + suffix;
        return result.replaceAll("[.]0", ".1");
    }

    public static String createOIDGivenRoot(String rootOid) {
        return OID.createOIDGivenRoot(rootOid, 256);
    }

    public static String create64CharOIDGivenRoot(String rootOid) {
        return OID.createOIDGivenRoot(rootOid, 64);
    }

    public static String create256CharOIDGivenRoot(String rootOid) {
        return OID.createOIDGivenRoot(rootOid, 256);
    }

    public static String createOIDGivenRoot(String rootOid, int maxLength) {
        String result;
        if (rootOid == null) {
            return OID.createOID(rootOid);
        }
        ++sequence;
        byte[] hostip = new byte[4];
        try {
            InetAddress localhost = InetAddress.getLocalHost();
            hostip = localhost.getAddress();
        }
        catch (UnknownHostException e) {
            hostip[0] = 127;
            hostip[1] = 0;
            hostip[2] = 0;
            hostip[3] = 1;
        }
        int[] mac = new int[]{0, 2, 138, 74, 253, 172};
        for (int i = 0; i < mac.length; ++i) {
            mac[i] = (int)((double)(hostip[i % hostip.length] - mac[i]) * Math.random());
        }
        String macString = "";
        for (int i = 0; i < mac.length; ++i) {
            macString = macString + OID.format(mac[i]);
        }
        String root = rootOid;
        String suffix = macString + "." + System.currentTimeMillis() + "." + sequence;
        int maxSuffix = maxLength - 9;
        if ((maxSuffix = maxSuffix - root.length() - 1) < 0) {
            maxSuffix = 0;
        }
        if (suffix.length() > maxSuffix) {
            suffix = suffix.substring(0, maxSuffix);
        }
        if ((result = root + "." + suffix).charAt(result.length() - 1) == '.') {
            result = result.substring(0, result.length() - 1);
        }
        return result.replaceAll("[.]0", ".1");
    }

    private static String format(int i) {
        i = Math.abs(i);
        StringBuffer sb = new StringBuffer(3);
        if (i < 10) {
            sb.append("0");
        }
        if (i < 100) {
            sb.append("0");
        }
        sb.append(i);
        return sb.toString();
    }

    public static void main(String[] argv) {
        int i;
        System.out.println("         1         2         3         4         5         6   x");
        System.out.println("123456789_123456789_123456789_123456789_123456789_123456789_123456789_123456789_");
        for (i = 0; i < 15; ++i) {
            System.out.println(OID.createOID(null));
        }
        System.out.println();
        System.out.println("123456789_123456789_123456789_123456789_123456789_123456789_123456789_123456789_");
        for (i = 0; i < 15; ++i) {
            System.out.println(OID.createOIDGivenRoot("2.16.840.1.113883.3.18", 36));
        }
    }
}

