/*
 * Decompiled with CFR 0.152.
 */
package org.openhealthtools.mdht.uml.cda.operations;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.OCL;
import org.eclipse.ocl.expressions.OCLExpression;
import org.openhealthtools.mdht.uml.cda.CDAFactory;
import org.openhealthtools.mdht.uml.cda.CDAPackage;
import org.openhealthtools.mdht.uml.cda.ClinicalDocument;
import org.openhealthtools.mdht.uml.cda.Component2;
import org.openhealthtools.mdht.uml.cda.Component3;
import org.openhealthtools.mdht.uml.cda.Patient;
import org.openhealthtools.mdht.uml.cda.PatientRole;
import org.openhealthtools.mdht.uml.cda.RecordTarget;
import org.openhealthtools.mdht.uml.cda.Section;
import org.openhealthtools.mdht.uml.cda.StructuredBody;
import org.openhealthtools.mdht.uml.cda.util.CDAUtil;
import org.openhealthtools.mdht.uml.hl7.rim.operations.ActOperations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClinicalDocumentOperations
extends ActOperations {
    protected static final String VALIDATE_CLASS_CODE__DIAGNOSTIC_CHAIN_MAP__EOCL_EXP = "self.classCode=vocab::ActClinicalDocument::DOCCLIN";
    protected static Constraint VALIDATE_CLASS_CODE__DIAGNOSTIC_CHAIN_MAP__EOCL_INV;
    protected static final String VALIDATE_MOOD_CODE__DIAGNOSTIC_CHAIN_MAP__EOCL_EXP = "self.moodCode=vocab::ActMood::EVN";
    protected static Constraint VALIDATE_MOOD_CODE__DIAGNOSTIC_CHAIN_MAP__EOCL_INV;
    protected static final String GET_PATIENTS__EOCL_EXP = "self.recordTarget.patientRole.patient";
    protected static OCLExpression<EClassifier> GET_PATIENTS__EOCL_QRY;
    protected static final String GET_PATIENT_ROLES__EOCL_EXP = "self.recordTarget.patientRole";
    protected static OCLExpression<EClassifier> GET_PATIENT_ROLES__EOCL_QRY;
    protected static final String GET_SECTIONS__EOCL_EXP = "if self.component.structuredBody.oclIsUndefined() then Bag{} else self.component.structuredBody.component.section endif";
    protected static OCLExpression<EClassifier> GET_SECTIONS__EOCL_QRY;
    protected static final String HAS_CODE__STRING_STRING_STRING__EOCL_EXP = "self.code.code = code and self.code.codeSystem = codeSystem and self.code.codeSystemName = codeSystemName";
    protected static OCLExpression<EClassifier> HAS_CODE__STRING_STRING_STRING__EOCL_QRY;
    protected static final String HAS_SECTION_TEMPLATE__STRING__EOCL_EXP = "self.getSections()->exists(sect : cda::Section | sect.hasTemplateId(templateId))";
    protected static OCLExpression<EClassifier> HAS_SECTION_TEMPLATE__STRING__EOCL_QRY;
    protected static final String HAS_TEMPLATE_ID__STRING__EOCL_EXP = "self.templateId->exists(id : datatypes::II | id.root = templateId)";
    protected static OCLExpression<EClassifier> HAS_TEMPLATE_ID__STRING__EOCL_QRY;

    protected ClinicalDocumentOperations() {
    }

    public static boolean validateClassCode(ClinicalDocument clinicalDocument, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (VALIDATE_CLASS_CODE__DIAGNOSTIC_CHAIN_MAP__EOCL_INV == null) {
            OCL.Helper helper = EOCL_ENV.createOCLHelper();
            helper.setContext((Object)CDAPackage.Literals.CLINICAL_DOCUMENT);
            try {
                VALIDATE_CLASS_CODE__DIAGNOSTIC_CHAIN_MAP__EOCL_INV = (Constraint)helper.createInvariant(VALIDATE_CLASS_CODE__DIAGNOSTIC_CHAIN_MAP__EOCL_EXP);
            }
            catch (ParserException pe) {
                throw new UnsupportedOperationException(pe.getLocalizedMessage());
            }
        }
        if (!EOCL_ENV.createQuery(VALIDATE_CLASS_CODE__DIAGNOSTIC_CHAIN_MAP__EOCL_INV).check((Object)clinicalDocument)) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.openhealthtools.mdht.uml.cda", 1, EcorePlugin.INSTANCE.getString("_UI_GenericInvariant_diagnostic", new Object[]{"validateClassCode", EObjectValidator.getObjectLabel((EObject)clinicalDocument, context)}), new Object[]{clinicalDocument}));
            }
            return false;
        }
        return true;
    }

    public static boolean validateMoodCode(ClinicalDocument clinicalDocument, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (VALIDATE_MOOD_CODE__DIAGNOSTIC_CHAIN_MAP__EOCL_INV == null) {
            OCL.Helper helper = EOCL_ENV.createOCLHelper();
            helper.setContext((Object)CDAPackage.Literals.CLINICAL_DOCUMENT);
            try {
                VALIDATE_MOOD_CODE__DIAGNOSTIC_CHAIN_MAP__EOCL_INV = (Constraint)helper.createInvariant(VALIDATE_MOOD_CODE__DIAGNOSTIC_CHAIN_MAP__EOCL_EXP);
            }
            catch (ParserException pe) {
                throw new UnsupportedOperationException(pe.getLocalizedMessage());
            }
        }
        if (!EOCL_ENV.createQuery(VALIDATE_MOOD_CODE__DIAGNOSTIC_CHAIN_MAP__EOCL_INV).check((Object)clinicalDocument)) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.openhealthtools.mdht.uml.cda", 2, EcorePlugin.INSTANCE.getString("_UI_GenericInvariant_diagnostic", new Object[]{"validateMoodCode", EObjectValidator.getObjectLabel((EObject)clinicalDocument, context)}), new Object[]{clinicalDocument}));
            }
            return false;
        }
        return true;
    }

    public static void setStructuredBody(ClinicalDocument clinicalDocument, StructuredBody structuredBody) {
        Component2 component = clinicalDocument.getComponent();
        if (component == null) {
            component = CDAFactory.eINSTANCE.createComponent2();
            clinicalDocument.setComponent(component);
        }
        component.setStructuredBody(structuredBody);
    }

    public static void addSection(ClinicalDocument clinicalDocument, Section section) {
        StructuredBody structuredBody;
        Component2 component2 = clinicalDocument.getComponent();
        if (component2 == null) {
            component2 = CDAFactory.eINSTANCE.createComponent2();
            clinicalDocument.setComponent(component2);
        }
        if ((structuredBody = component2.getStructuredBody()) == null) {
            structuredBody = CDAFactory.eINSTANCE.createStructuredBody();
            component2.setStructuredBody(structuredBody);
        }
        Component3 component3 = CDAFactory.eINSTANCE.createComponent3();
        component3.setSection(section);
        structuredBody.getComponents().add((Object)component3);
    }

    public static EList<Patient> getPatients(ClinicalDocument clinicalDocument) {
        if (GET_PATIENTS__EOCL_QRY == null) {
            OCL.Helper helper = EOCL_ENV.createOCLHelper();
            helper.setOperationContext((Object)CDAPackage.Literals.CLINICAL_DOCUMENT, (Object)((EOperation)CDAPackage.Literals.CLINICAL_DOCUMENT.getEAllOperations().get(21)));
            try {
                GET_PATIENTS__EOCL_QRY = helper.createQuery(GET_PATIENTS__EOCL_EXP);
            }
            catch (ParserException pe) {
                throw new UnsupportedOperationException(pe.getLocalizedMessage());
            }
        }
        OCL.Query query = EOCL_ENV.createQuery(GET_PATIENTS__EOCL_QRY);
        Collection result = (Collection)query.evaluate((Object)clinicalDocument);
        return new BasicEList.UnmodifiableEList(result.size(), result.toArray());
    }

    public static EList<PatientRole> getPatientRoles(ClinicalDocument clinicalDocument) {
        if (GET_PATIENT_ROLES__EOCL_QRY == null) {
            OCL.Helper helper = EOCL_ENV.createOCLHelper();
            helper.setOperationContext((Object)CDAPackage.Literals.CLINICAL_DOCUMENT, (Object)((EOperation)CDAPackage.Literals.CLINICAL_DOCUMENT.getEAllOperations().get(22)));
            try {
                GET_PATIENT_ROLES__EOCL_QRY = helper.createQuery(GET_PATIENT_ROLES__EOCL_EXP);
            }
            catch (ParserException pe) {
                throw new UnsupportedOperationException(pe.getLocalizedMessage());
            }
        }
        OCL.Query query = EOCL_ENV.createQuery(GET_PATIENT_ROLES__EOCL_QRY);
        Collection result = (Collection)query.evaluate((Object)clinicalDocument);
        return new BasicEList.UnmodifiableEList(result.size(), result.toArray());
    }

    public static EList<Section> getSections(ClinicalDocument clinicalDocument) {
        if (GET_SECTIONS__EOCL_QRY == null) {
            OCL.Helper helper = EOCL_ENV.createOCLHelper();
            helper.setOperationContext((Object)CDAPackage.Literals.CLINICAL_DOCUMENT, (Object)((EOperation)CDAPackage.Literals.CLINICAL_DOCUMENT.getEAllOperations().get(23)));
            try {
                GET_SECTIONS__EOCL_QRY = helper.createQuery(GET_SECTIONS__EOCL_EXP);
            }
            catch (ParserException pe) {
                throw new UnsupportedOperationException(pe.getLocalizedMessage());
            }
        }
        OCL.Query query = EOCL_ENV.createQuery(GET_SECTIONS__EOCL_QRY);
        Collection result = (Collection)query.evaluate((Object)clinicalDocument);
        return new BasicEList.UnmodifiableEList(result.size(), result.toArray());
    }

    public static EList<Section> getAllSections(ClinicalDocument clinicalDocument) {
        List<Section> sections = CDAUtil.getAllSections(clinicalDocument);
        return new BasicEList.UnmodifiableEList(sections.size(), sections.toArray());
    }

    public static boolean hasCode(ClinicalDocument clinicalDocument, String code, String codeSystem, String codeSystemName) {
        if (HAS_CODE__STRING_STRING_STRING__EOCL_QRY == null) {
            OCL.Helper helper = EOCL_ENV.createOCLHelper();
            helper.setOperationContext((Object)CDAPackage.Literals.CLINICAL_DOCUMENT, (Object)((EOperation)CDAPackage.Literals.CLINICAL_DOCUMENT.getEAllOperations().get(25)));
            try {
                HAS_CODE__STRING_STRING_STRING__EOCL_QRY = helper.createQuery(HAS_CODE__STRING_STRING_STRING__EOCL_EXP);
            }
            catch (ParserException pe) {
                throw new UnsupportedOperationException(pe.getLocalizedMessage());
            }
        }
        OCL.Query query = EOCL_ENV.createQuery(HAS_CODE__STRING_STRING_STRING__EOCL_QRY);
        EvaluationEnvironment environment = query.getEvaluationEnvironment();
        environment.add("code", (Object)code);
        environment.add("codeSystem", (Object)codeSystem);
        environment.add("codeSystemName", (Object)codeSystemName);
        return (Boolean)query.evaluate((Object)clinicalDocument);
    }

    public static boolean hasSectionTemplate(ClinicalDocument clinicalDocument, String templateId) {
        if (HAS_SECTION_TEMPLATE__STRING__EOCL_QRY == null) {
            OCL.Helper helper = EOCL_ENV.createOCLHelper();
            helper.setOperationContext((Object)CDAPackage.Literals.CLINICAL_DOCUMENT, (Object)((EOperation)CDAPackage.Literals.CLINICAL_DOCUMENT.getEAllOperations().get(26)));
            try {
                HAS_SECTION_TEMPLATE__STRING__EOCL_QRY = helper.createQuery(HAS_SECTION_TEMPLATE__STRING__EOCL_EXP);
            }
            catch (ParserException pe) {
                throw new UnsupportedOperationException(pe.getLocalizedMessage());
            }
        }
        OCL.Query query = EOCL_ENV.createQuery(HAS_SECTION_TEMPLATE__STRING__EOCL_QRY);
        EvaluationEnvironment environment = query.getEvaluationEnvironment();
        environment.add("templateId", (Object)templateId);
        return (Boolean)query.evaluate((Object)clinicalDocument);
    }

    public static boolean hasTemplateId(ClinicalDocument clinicalDocument, String templateId) {
        if (HAS_TEMPLATE_ID__STRING__EOCL_QRY == null) {
            OCL.Helper helper = EOCL_ENV.createOCLHelper();
            helper.setOperationContext((Object)CDAPackage.Literals.CLINICAL_DOCUMENT, (Object)((EOperation)CDAPackage.Literals.CLINICAL_DOCUMENT.getEAllOperations().get(27)));
            try {
                HAS_TEMPLATE_ID__STRING__EOCL_QRY = helper.createQuery(HAS_TEMPLATE_ID__STRING__EOCL_EXP);
            }
            catch (ParserException pe) {
                throw new UnsupportedOperationException(pe.getLocalizedMessage());
            }
        }
        OCL.Query query = EOCL_ENV.createQuery(HAS_TEMPLATE_ID__STRING__EOCL_QRY);
        EvaluationEnvironment environment = query.getEvaluationEnvironment();
        environment.add("templateId", (Object)templateId);
        return (Boolean)query.evaluate((Object)clinicalDocument);
    }

    public static void addPatientRole(ClinicalDocument clinicalDocument, PatientRole patientRole) {
        RecordTarget recordTarget = CDAFactory.eINSTANCE.createRecordTarget();
        recordTarget.setPatientRole(patientRole);
        clinicalDocument.getRecordTargets().add((Object)recordTarget);
    }

    public static void addPatient(ClinicalDocument clinicalDocument, Patient patient) {
        RecordTarget recordTarget = CDAFactory.eINSTANCE.createRecordTarget();
        PatientRole patientRole = CDAFactory.eINSTANCE.createPatientRole();
        recordTarget.setPatientRole(patientRole);
        patientRole.setPatient(patient);
        clinicalDocument.getRecordTargets().add((Object)recordTarget);
    }
}

