/*
 * Decompiled with CFR 0.152.
 */
package org.openhealthtools.mdht.uml.cda.util;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.xmi.DOMHandler;
import org.eclipse.emf.ecore.xmi.DOMHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.OCL;
import org.eclipse.ocl.expressions.OCLExpression;
import org.openhealthtools.mdht.emf.runtime.resource.DOMDocumentHandlerImpl;
import org.openhealthtools.mdht.emf.runtime.resource.FleXMLResource;
import org.openhealthtools.mdht.emf.runtime.resource.FleXMLResourceSet;
import org.openhealthtools.mdht.emf.runtime.resource.XSITypeProvider;
import org.openhealthtools.mdht.emf.runtime.util.Initializer;
import org.openhealthtools.mdht.uml.cda.Act;
import org.openhealthtools.mdht.uml.cda.CDAFactory;
import org.openhealthtools.mdht.uml.cda.CDAPackage;
import org.openhealthtools.mdht.uml.cda.ClinicalDocument;
import org.openhealthtools.mdht.uml.cda.ClinicalStatement;
import org.openhealthtools.mdht.uml.cda.Component2;
import org.openhealthtools.mdht.uml.cda.Component3;
import org.openhealthtools.mdht.uml.cda.Component4;
import org.openhealthtools.mdht.uml.cda.Component5;
import org.openhealthtools.mdht.uml.cda.DocumentRoot;
import org.openhealthtools.mdht.uml.cda.Encounter;
import org.openhealthtools.mdht.uml.cda.Entry;
import org.openhealthtools.mdht.uml.cda.EntryRelationship;
import org.openhealthtools.mdht.uml.cda.Observation;
import org.openhealthtools.mdht.uml.cda.ObservationMedia;
import org.openhealthtools.mdht.uml.cda.Organizer;
import org.openhealthtools.mdht.uml.cda.Procedure;
import org.openhealthtools.mdht.uml.cda.RegionOfInterest;
import org.openhealthtools.mdht.uml.cda.Section;
import org.openhealthtools.mdht.uml.cda.StructuredBody;
import org.openhealthtools.mdht.uml.cda.SubstanceAdministration;
import org.openhealthtools.mdht.uml.cda.Supply;
import org.openhealthtools.mdht.uml.cda.internal.resource.CDAResource;
import org.openhealthtools.mdht.uml.cda.internal.resource.CDAResourceFactoryImpl;
import org.openhealthtools.mdht.uml.cda.internal.resource.CDAXSITypeProvider;
import org.openhealthtools.mdht.uml.cda.util.AnnotationBasedInitializer;
import org.openhealthtools.mdht.uml.cda.util.CDAPackageLoader;
import org.openhealthtools.mdht.uml.hl7.datatypes.II;
import org.openhealthtools.mdht.uml.hl7.rim.InfrastructureRoot;
import org.openhealthtools.mdht.uml.hl7.vocab.x_ActRelationshipEntry;
import org.openhealthtools.mdht.uml.hl7.vocab.x_ActRelationshipEntryRelationship;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDAUtil {
    public static final String CDA_ANNOTATION_SOURCE = "http://www.openhealthtools.org/mdht/uml/cda/annotation";
    private static final Pattern COMPONENT_PATTERN = Pattern.compile("(^[A-Za-z0-9]+)(\\[([1-9]+[0-9]*)\\])?");
    private static int uriCounter;
    private static final OCL ocl;
    public static Map<ClinicalDocument, CDAXPath> CACHE;

    static {
        CDAResourceFactoryImpl.init();
        uriCounter = 0;
        ocl = OCL.newInstance();
        CACHE = new HashMap<ClinicalDocument, CDAXPath>();
    }

    public static Map<String, EClass> getAllDocumentClasses() {
        XSITypeProvider provider = XSITypeProvider.Registry.INSTANCE.getXSITypeProvider((EPackage)CDAPackage.eINSTANCE);
        Map<String, EClass> result = provider instanceof CDAXSITypeProvider ? Collections.unmodifiableMap(((CDAXSITypeProvider)provider).getAllDocumentClasses()) : Collections.emptyMap();
        return result;
    }

    @Deprecated
    public static EClass getDocumentClass() {
        EClass result = null;
        XSITypeProvider provider = XSITypeProvider.Registry.INSTANCE.getXSITypeProvider((EPackage)CDAPackage.eINSTANCE);
        if (provider instanceof CDAXSITypeProvider) {
            result = ((CDAXSITypeProvider)provider).getDocumentClass();
        }
        return result;
    }

    @Deprecated
    public static void setDocumentClass(EClass eClass) {
        XSITypeProvider.Registry.INSTANCE.registerXSITypeProvider((EPackage)CDAPackage.eINSTANCE, (XSITypeProvider)new CDAXSITypeProvider(eClass));
    }

    @Deprecated
    public static void setDocumentClassQName(String documentClassQName) {
        XSITypeProvider.Registry.INSTANCE.registerXSITypeProvider((EPackage)CDAPackage.eINSTANCE, (XSITypeProvider)new CDAXSITypeProvider(documentClassQName));
    }

    public static FleXMLResourceSet createResourceSet() {
        return FleXMLResourceSet.Factory.INSTANCE.createResourceSet().setDefaultResourceFactory((FleXMLResource.Factory)CDAResource.Factory.INSTANCE);
    }

    public static FleXMLResourceSet createResourceSet(EClass eClass) {
        FleXMLResourceSet result = FleXMLResourceSet.Factory.INSTANCE.createResourceSet().setDefaultResourceFactory((FleXMLResource.Factory)CDAResource.Factory.INSTANCE);
        result.getXSITypeProviderRegistry().registerXSITypeProvider((EPackage)CDAPackage.eINSTANCE, (XSITypeProvider)new CDAXSITypeProvider(eClass));
        return result;
    }

    public static FleXMLResourceSet createResourceSet(String documentClassQName) {
        FleXMLResourceSet result = FleXMLResourceSet.Factory.INSTANCE.createResourceSet().setDefaultResourceFactory((FleXMLResource.Factory)CDAResource.Factory.INSTANCE);
        result.getXSITypeProviderRegistry().registerXSITypeProvider((EPackage)CDAPackage.eINSTANCE, (XSITypeProvider)new CDAXSITypeProvider(documentClassQName));
        return result;
    }

    public static ClinicalDocument load(InputStream in) throws Exception {
        return CDAUtil.load(in, null);
    }

    public static ClinicalDocument load(InputSource is) throws Exception {
        return CDAUtil.load(is, null);
    }

    public static ClinicalDocument load(Document document) throws Exception {
        return CDAUtil.load(document, null);
    }

    public static ClinicalDocument load(InputStream in, ValidationHandler handler) throws Exception {
        return CDAUtil.load((ResourceSet)CDAUtil.createResourceSet(null), CDAUtil.generateURI(), in, handler);
    }

    public static ClinicalDocument load(ResourceSet resourceSet, URI uri, InputStream in, final ValidationHandler handler) throws Exception {
        XMLResource resource = (XMLResource)resourceSet.createResource(uri);
        HashMap<Object, 1> options = new HashMap<Object, 1>();
        if (handler != null) {
            options.put(FleXMLResource.OPTION_DOM_DOCUMENT_HANDLER, new DOMDocumentHandlerImpl(){

                public void aboutToLoadDOM(Document document) {
                    CDAUtil.performSchemaValidation(document, handler);
                }
            });
        }
        resource.load(in, options);
        DocumentRoot root = (DocumentRoot)resource.getContents().get(0);
        ClinicalDocument clinicalDocument = root.getClinicalDocument();
        if (handler != null) {
            CDAUtil.performEMFValidation(clinicalDocument, handler);
        }
        return clinicalDocument;
    }

    public static ClinicalDocument load(InputSource is, ValidationHandler handler) throws Exception {
        return CDAUtil.load((ResourceSet)CDAUtil.createResourceSet(null), CDAUtil.generateURI(), is, handler);
    }

    public static ClinicalDocument load(ResourceSet resourceSet, URI uri, InputSource is, final ValidationHandler handler) throws Exception {
        XMLResource resource = (XMLResource)resourceSet.createResource(uri);
        HashMap<Object, 2> options = new HashMap<Object, 2>();
        if (handler != null) {
            options.put(FleXMLResource.OPTION_DOM_DOCUMENT_HANDLER, new DOMDocumentHandlerImpl(){

                public void aboutToLoadDOM(Document document) {
                    CDAUtil.performSchemaValidation(document, handler);
                }
            });
        }
        resource.load(is, options);
        DocumentRoot root = (DocumentRoot)resource.getContents().get(0);
        ClinicalDocument clinicalDocument = root.getClinicalDocument();
        if (handler != null) {
            CDAUtil.performEMFValidation(clinicalDocument, handler);
        }
        return clinicalDocument;
    }

    public static ClinicalDocument load(Document document, ValidationHandler handler) throws Exception {
        return CDAUtil.load((ResourceSet)CDAUtil.createResourceSet(null), CDAUtil.generateURI(), document, handler);
    }

    public static ClinicalDocument load(ResourceSet resourceSet, URI uri, Document document, final ValidationHandler handler) throws Exception {
        XMLResource resource = (XMLResource)resourceSet.createResource(uri);
        HashMap<Object, 3> options = new HashMap<Object, 3>();
        if (handler != null) {
            options.put(FleXMLResource.OPTION_DOM_DOCUMENT_HANDLER, new DOMDocumentHandlerImpl(){

                public void aboutToLoadDOM(Document document) {
                    CDAUtil.performSchemaValidation(document, handler);
                }
            });
        }
        resource.load((Node)document, options);
        DocumentRoot root = (DocumentRoot)resource.getContents().get(0);
        ClinicalDocument clinicalDocument = root.getClinicalDocument();
        if (handler != null) {
            CDAUtil.performEMFValidation(clinicalDocument, handler);
        }
        return clinicalDocument;
    }

    public static ClinicalDocument load(URI uri, ValidationHandler handler) throws Exception {
        return CDAUtil.load((ResourceSet)CDAUtil.createResourceSet(null), uri, handler);
    }

    public static ClinicalDocument loadAs(InputStream in, EClass docTypeEClass) throws Exception {
        return CDAUtil.load((ResourceSet)CDAUtil.createResourceSet(docTypeEClass), CDAUtil.generateURI(), in, null);
    }

    public static ClinicalDocument loadAs(InputStream in, EClass docTypeEClass, ValidationHandler handler) throws Exception {
        return CDAUtil.load((ResourceSet)CDAUtil.createResourceSet(docTypeEClass), CDAUtil.generateURI(), in, handler);
    }

    private static URI generateURI() {
        URI uri = URI.createURI((String)("http:///resource" + uriCounter + ".xml"));
        ++uriCounter;
        return uri;
    }

    public static ClinicalDocument load(ResourceSet resourceSet, URI uri, final ValidationHandler handler) throws Exception {
        XMLResource resource = (XMLResource)resourceSet.createResource(uri);
        HashMap<Object, 4> options = new HashMap<Object, 4>();
        if (handler != null) {
            options.put(FleXMLResource.OPTION_DOM_DOCUMENT_HANDLER, new DOMDocumentHandlerImpl(){

                public void aboutToLoadDOM(Document document) {
                    CDAUtil.performSchemaValidation(document, handler);
                }
            });
        }
        resource.load(options);
        DocumentRoot root = (DocumentRoot)resource.getContents().get(0);
        ClinicalDocument clinicalDocument = root.getClinicalDocument();
        if (handler != null) {
            CDAUtil.performEMFValidation(clinicalDocument, handler);
        }
        return clinicalDocument;
    }

    @Deprecated
    public static ClinicalDocument load(InputStream in, LoadHandler handler) throws Exception {
        DocumentBuilder builder = CDAUtil.newDocumentBuilder();
        Document doc = builder.parse(in);
        return CDAUtil.load(doc, handler);
    }

    @Deprecated
    public static ClinicalDocument load(InputSource is, LoadHandler handler) throws Exception {
        DocumentBuilder builder = CDAUtil.newDocumentBuilder();
        Document doc = builder.parse(is);
        return CDAUtil.load(doc, handler);
    }

    @Deprecated
    public static ClinicalDocument load(Document doc, LoadHandler handler) throws Exception {
        XMLResource resource = (XMLResource)CDAUtil.createResourceSet().createResource(URI.createURI((String)"urn:hl7-org:v3"));
        resource.load((Node)doc, null);
        if (handler != null) {
            CDAUtil.processResource(resource, handler);
        }
        DocumentRoot root = (DocumentRoot)resource.getContents().get(0);
        return root.getClinicalDocument();
    }

    public static ClinicalDocument load(ResourceSet resourceSet, URI uri, LoadHandler handler) throws Exception {
        XMLResource resource = (XMLResource)resourceSet.createResource(uri);
        resource.load(null);
        if (handler != null) {
            CDAUtil.processResource(resource, handler);
        }
        DocumentRoot root = (DocumentRoot)resource.getContents().get(0);
        return root.getClinicalDocument();
    }

    private static DocumentBuilder newDocumentBuilder() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        return factory.newDocumentBuilder();
    }

    private static void processResource(XMLResource resource, LoadHandler handler) {
        Map extMap = resource.getEObjectToExtensionMap();
        for (EObject key : extMap.keySet()) {
            AnyType value = (AnyType)extMap.get(key);
            CDAUtil.handleUnknownData(key, value, handler);
        }
    }

    private static void handleUnknownData(EObject object, AnyType unknownData, LoadHandler handler) {
        CDAUtil.handleUnknownFeatures(object, unknownData.getMixed(), handler);
        CDAUtil.handleUnknownFeatures(object, unknownData.getAnyAttribute(), handler);
    }

    private static void handleUnknownFeatures(EObject owner, FeatureMap featureMap, LoadHandler handler) {
        Iterator iterator = featureMap.iterator();
        while (iterator.hasNext()) {
            FeatureMap.Entry entry = (FeatureMap.Entry)iterator.next();
            EStructuralFeature feature = entry.getEStructuralFeature();
            if (!handler.handleUnknownFeature(owner, feature, entry.getValue())) continue;
            iterator.remove();
        }
    }

    public static void save(ClinicalDocument clinicalDocument, OutputStream out) throws Exception {
        CDAUtil.save(clinicalDocument, out, true);
    }

    public static void save(ClinicalDocument clinicalDocument, OutputStream out, boolean defaults) throws Exception {
        XMLResource resource = CDAUtil.prepare(clinicalDocument, defaults);
        resource.save(out, null);
    }

    public static void save(ClinicalDocument clinicalDocument, Writer writer) throws Exception {
        CDAUtil.save(clinicalDocument, writer, true);
    }

    public static void save(ClinicalDocument clinicalDocument, Writer writer, boolean defaults) throws Exception {
        XMLResource resource = CDAUtil.prepare(clinicalDocument, defaults);
        resource.save(writer, null);
    }

    public static Document save(ClinicalDocument clinicalDocument, DOMHandler handler) throws Exception {
        XMLResource resource = CDAUtil.prepare(clinicalDocument, true);
        return resource.save(CDAUtil.newDocumentBuilder().newDocument(), null, handler);
    }

    private static XMLResource prepare(ClinicalDocument clinicalDocument, boolean defaults) {
        XMLResource resource;
        if (defaults) {
            CDAUtil.handleDefaults((EObject)clinicalDocument);
        }
        if ((resource = (XMLResource)clinicalDocument.eResource()) == null) {
            resource = (XMLResource)CDAUtil.createResourceSet().createResource(URI.createURI((String)"urn:hl7-org:v3"));
            DocumentRoot root = CDAFactory.eINSTANCE.createDocumentRoot();
            root.setClinicalDocument(clinicalDocument);
            root.getXMLNSPrefixMap().put((Object)"", (Object)"urn:hl7-org:v3");
            root.getXSISchemaLocation().put((Object)"urn:hl7-org:v3", (Object)"CDA.xsd");
            resource.getContents().add((Object)root);
        } else {
            DocumentRoot root = (DocumentRoot)clinicalDocument.eContainer();
            ArrayList<String> keys = new ArrayList<String>();
            for (Map.Entry entry : root.getXMLNSPrefixMap().entrySet()) {
                if (!EPackage.Registry.INSTANCE.keySet().contains(entry.getValue())) continue;
                keys.add((String)entry.getKey());
            }
            for (String key : keys) {
                root.getXMLNSPrefixMap().removeKey((Object)key);
            }
            root.getXMLNSPrefixMap().put((Object)"", (Object)"urn:hl7-org:v3");
        }
        return resource;
    }

    public static void saveSnippet(InfrastructureRoot snippet, OutputStream out) throws Exception {
        CDAUtil.saveSnippet(snippet, out, true);
    }

    public static void saveSnippet(InfrastructureRoot snippet, OutputStream out, boolean defaults) throws Exception {
        XMLResource resource = CDAUtil.prepare(snippet, defaults);
        resource.save(out, CDAUtil.snippetOptions());
    }

    public static void saveSnippet(InfrastructureRoot snippet, Writer writer) throws Exception {
        XMLResource resource = CDAUtil.prepare(snippet, true);
        resource.save(writer, CDAUtil.snippetOptions());
    }

    private static Map<String, Object> snippetOptions() {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("ENCODING", "UTF8");
        options.put("SCHEMA_LOCATION", Boolean.FALSE);
        options.put("DECLARE_XML", Boolean.FALSE);
        return options;
    }

    private static XMLResource prepare(InfrastructureRoot cdaSnippet, boolean defaults) {
        XMLResource resource = (XMLResource)CDAUtil.createResourceSet().createResource(URI.createURI((String)"urn:hl7-org:v3"));
        EClass documentRootEClass = EcoreFactory.eINSTANCE.createEClass();
        documentRootEClass.setName("DocumentRoot");
        ExtendedMetaData.INSTANCE.setName((EClassifier)documentRootEClass, "");
        ExtendedMetaData.INSTANCE.setContentKind(documentRootEClass, 3);
        EAttribute mixed = EcoreFactory.eINSTANCE.createEAttribute();
        mixed.setName("mixed");
        mixed.setEType((EClassifier)EcorePackage.eINSTANCE.getEFeatureMapEntry());
        mixed.setUpperBound(-1);
        ExtendedMetaData.INSTANCE.setName((EStructuralFeature)mixed, ":mixed");
        ExtendedMetaData.INSTANCE.setFeatureKind((EStructuralFeature)mixed, 5);
        documentRootEClass.getEStructuralFeatures().add((Object)mixed);
        EReference xmlnsPrefixMap = EcoreFactory.eINSTANCE.createEReference();
        xmlnsPrefixMap.setName("xMLNSPrefixMap");
        xmlnsPrefixMap.setEType((EClassifier)EcorePackage.eINSTANCE.getEStringToStringMapEntry());
        xmlnsPrefixMap.setUpperBound(-1);
        xmlnsPrefixMap.setContainment(true);
        xmlnsPrefixMap.setTransient(true);
        ExtendedMetaData.INSTANCE.setName((EStructuralFeature)xmlnsPrefixMap, "xmlns:prefix");
        ExtendedMetaData.INSTANCE.setFeatureKind((EStructuralFeature)xmlnsPrefixMap, 2);
        documentRootEClass.getEStructuralFeatures().add((Object)xmlnsPrefixMap);
        EReference xsiSchemaLocation = EcoreFactory.eINSTANCE.createEReference();
        xsiSchemaLocation.setName("xSISchemaLocation");
        xsiSchemaLocation.setEType((EClassifier)EcorePackage.eINSTANCE.getEStringToStringMapEntry());
        xsiSchemaLocation.setUpperBound(-1);
        xsiSchemaLocation.setContainment(true);
        xsiSchemaLocation.setTransient(true);
        ExtendedMetaData.INSTANCE.setName((EStructuralFeature)xsiSchemaLocation, "xsi:schemaLocation");
        ExtendedMetaData.INSTANCE.setFeatureKind((EStructuralFeature)xsiSchemaLocation, 2);
        documentRootEClass.getEStructuralFeatures().add((Object)xsiSchemaLocation);
        EReference snippetReference = EcoreFactory.eINSTANCE.createEReference();
        String snippetName = cdaSnippet.eClass().getName();
        for (EClass eClass : cdaSnippet.eClass().getEAllSuperTypes()) {
            if (!CDAPackage.eINSTANCE.getNsURI().equals(eClass.getEPackage().getNsURI()) || "ClinicalStatement".equals(eClass.getName())) continue;
            snippetName = eClass.getName();
            break;
        }
        snippetReference.setName(snippetName.toLowerCase());
        snippetReference.setUpperBound(-1);
        snippetReference.setContainment(true);
        snippetReference.setEType((EClassifier)cdaSnippet.eClass());
        documentRootEClass.getEStructuralFeatures().add((Object)snippetReference);
        EPackage documentRootPackage = EcoreFactory.eINSTANCE.createEPackage();
        documentRootPackage.setName("cda");
        documentRootPackage.setNsPrefix("cda");
        documentRootPackage.setNsURI("urn:hl7-org:v3");
        documentRootPackage.getEClassifiers().add((Object)documentRootEClass);
        EFactory documentRootFactoryInstance = documentRootPackage.getEFactoryInstance();
        EObject documentRootInstance = documentRootFactoryInstance.create(documentRootEClass);
        ((EMap)documentRootInstance.eGet((EStructuralFeature)xmlnsPrefixMap)).put((Object)"", (Object)"urn:hl7-org:v3");
        ((EMap)documentRootInstance.eGet((EStructuralFeature)xsiSchemaLocation)).put((Object)"urn:hl7-org:v3", (Object)"CDA.xsd");
        ((List)documentRootInstance.eGet((EStructuralFeature)snippetReference)).add(cdaSnippet);
        resource.getContents().add((Object)documentRootInstance);
        return resource;
    }

    private static void handleDefaults(EObject root) {
        LinkedList<EObject> queue = new LinkedList<EObject>();
        queue.add(root);
        while (!queue.isEmpty()) {
            EObject eObject = (EObject)queue.remove();
            EClass eClass = eObject.eClass();
            for (EAttribute attribute : eClass.getEAllAttributes()) {
                if (eObject.eIsSet((EStructuralFeature)attribute) || attribute.getLowerBound() <= 0 || attribute.getDefaultValueLiteral() == null) continue;
                if (attribute.isMany()) {
                    List list = (List)eObject.eGet((EStructuralFeature)attribute);
                    list.add(attribute.getDefaultValue());
                    continue;
                }
                eObject.eSet((EStructuralFeature)attribute, attribute.getDefaultValue());
            }
            for (EReference reference : eClass.getEAllReferences()) {
                Object value = eObject.eGet((EStructuralFeature)reference);
                if (value == null) continue;
                if (reference.isMany()) {
                    queue.addAll((List)value);
                    continue;
                }
                queue.add((EObject)value);
            }
        }
    }

    public static boolean validate(ClinicalDocument clinicalDocument) {
        return CDAUtil.validate(clinicalDocument, null);
    }

    public static boolean validate(ClinicalDocument clinicalDocument, ValidationHandler handler) {
        return CDAUtil.validate(clinicalDocument, handler, true);
    }

    public static boolean validate(ClinicalDocument clinicalDocument, ValidationHandler handler, boolean defaults) {
        if (defaults) {
            CDAUtil.handleDefaults((EObject)clinicalDocument);
        }
        if (clinicalDocument.eResource() != null) {
            CDAUtil.processDiagnostic(EcoreUtil.computeDiagnostic((Resource)clinicalDocument.eResource(), (boolean)true), handler);
        }
        Diagnostic diagnostic = Diagnostician.INSTANCE.validate((EObject)clinicalDocument);
        if (handler != null) {
            CDAUtil.processDiagnostic(diagnostic, handler);
        }
        return diagnostic.getSeverity() != 4;
    }

    public static void performSchemaValidation(ClinicalDocument clinicalDocument, ValidationHandler handler) {
        try {
            Document document = CDAUtil.save(clinicalDocument, null);
            CDAUtil.performSchemaValidation(document, handler);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void performSchemaValidation(Document document, ValidationHandler handler) {
        try {
            URL url = CDAUtil.class.getResource("/samples/C32_CDA.xsd");
            if (url == null) {
                url = new File("../org.openhealthtools.mdht.uml.cda/samples/C32_CDA.xsd").toURI().toURL();
            }
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = factory.newSchema(new StreamSource(url.toExternalForm()));
            Validator validator = schema.newValidator();
            validator.setErrorHandler(new SchemaValidationHandler(handler));
            validator.validate(new DOMSource(document));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void performEMFValidation(Document document, ValidationHandler handler) {
        try {
            ClinicalDocument clinicalDocument = CDAUtil.load(document);
            CDAUtil.performEMFValidation(clinicalDocument, handler);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void performEMFValidation(ClinicalDocument clinicalDocument, ValidationHandler handler) {
        CDAUtil.validate(clinicalDocument, handler);
    }

    private static void processDiagnostic(Diagnostic diagnostic, ValidationHandler handler) {
        LinkedList<Diagnostic> queue = new LinkedList<Diagnostic>();
        queue.add(diagnostic);
        while (!queue.isEmpty()) {
            Diagnostic d = (Diagnostic)queue.remove();
            if (CDAUtil.shouldHandle(d)) {
                CDAUtil.handleDiagnostic(d, handler);
            }
            for (Diagnostic childDiagnostic : d.getChildren()) {
                queue.add(childDiagnostic);
            }
        }
    }

    private static boolean shouldHandle(Diagnostic diagnostic) {
        return diagnostic.getMessage() != null && !diagnostic.getMessage().startsWith("Diagnosis of");
    }

    private static void handleDiagnostic(Diagnostic diagnostic, ValidationHandler handler) {
        switch (diagnostic.getSeverity()) {
            case 4: {
                handler.handleError(diagnostic);
                break;
            }
            case 2: {
                handler.handleWarning(diagnostic);
                break;
            }
            case 1: {
                handler.handleInfo(diagnostic);
            }
        }
    }

    public static ClinicalDocument getClinicalDocument(EObject object) {
        while (object != null && !(object instanceof ClinicalDocument)) {
            object = object.eContainer();
        }
        return (ClinicalDocument)object;
    }

    public static Section getSection(EObject object) {
        while (object != null && !(object instanceof Section)) {
            object = object.eContainer();
        }
        return (Section)object;
    }

    public static EList<ClinicalStatement> getEntryRelationshipTargets(ClinicalStatement source, x_ActRelationshipEntryRelationship typeCode, EClass targetClass) {
        ArrayList<ClinicalStatement> targets = new ArrayList<ClinicalStatement>();
        for (EntryRelationship rel : CDAUtil.getEntryRelationships(source)) {
            ClinicalStatement element;
            boolean typeCodeMatch = typeCode == null ? true : typeCode.equals((Object)rel.getTypeCode());
            ClinicalStatement target = CDAUtil.getClinicalStatement(rel);
            if (target != null && CDAUtil.isReference((EObject)target) && (element = CDAUtil.resolveReference(target)) != null) {
                target = element;
            }
            if (Boolean.FALSE != rel.getInversionInd() && rel.getInversionInd() != null || !typeCodeMatch || target == null || targetClass != null && !targetClass.isSuperTypeOf(target.eClass())) continue;
            targets.add(target);
        }
        if (source.eContainer() instanceof EntryRelationship) {
            boolean typeCodeMatch;
            EntryRelationship rel;
            rel = (EntryRelationship)source.eContainer();
            boolean bl = typeCodeMatch = typeCode == null ? true : typeCode.equals((Object)rel.getTypeCode());
            if (Boolean.TRUE == rel.getInversionInd() && typeCodeMatch && rel.eContainer() instanceof ClinicalStatement && (targetClass == null || targetClass.isSuperTypeOf(rel.eContainer().eClass()))) {
                targets.add((ClinicalStatement)rel.eContainer());
            }
        }
        return new BasicEList.UnmodifiableEList(targets.size(), targets.toArray());
    }

    public static EList<ClinicalStatement> getEntryTargets(Section source, x_ActRelationshipEntry typeCode, EClass targetClass) {
        ArrayList<ClinicalStatement> targets = new ArrayList<ClinicalStatement>();
        for (Entry rel : source.getEntries()) {
            ClinicalStatement element;
            boolean typeCodeMatch = typeCode == null ? true : typeCode.equals((Object)rel.getTypeCode());
            ClinicalStatement target = CDAUtil.getClinicalStatement(rel);
            if (target != null && CDAUtil.isReference((EObject)target) && (element = CDAUtil.resolveReference(target)) != null) {
                target = element;
            }
            if (!typeCodeMatch || target == null || targetClass != null && !targetClass.isSuperTypeOf(target.eClass())) continue;
            targets.add(target);
        }
        return new BasicEList.UnmodifiableEList(targets.size(), targets.toArray());
    }

    public static boolean isReference(EObject element) {
        EObject id = CDAUtil.getChildElement(element, "id");
        EObject templateId = CDAUtil.getChildElement(element, "templateId");
        return templateId == null && id instanceof II && ((II)id).getRoot() != null;
    }

    private static EObject getChildElement(EObject eObject, String name) {
        Object result = null;
        EStructuralFeature feature = eObject.eClass().getEStructuralFeature(name);
        if (feature != null) {
            if (feature.isMany()) {
                List list = (List)eObject.eGet(feature);
                if (list.size() > 0) {
                    result = list.get(0);
                }
            } else {
                result = eObject.eGet(feature);
            }
        }
        return result instanceof EObject ? (EObject)result : null;
    }

    public static EObject resolveReference(EObject element) {
        if (!CDAUtil.isReference(element)) {
            return null;
        }
        II id = (II)CDAUtil.getChildElement(element, "id");
        EObject target = null;
        ClinicalDocument clinicalDocument = CDAUtil.getClinicalDocument(element);
        if (clinicalDocument != null) {
            Query query = new Query(clinicalDocument);
            target = query.getEObject(EObject.class, new ReferenceFilter(id));
        }
        return target;
    }

    public static ClinicalStatement resolveReference(ClinicalStatement element) {
        if (!CDAUtil.isReference((EObject)element)) {
            return null;
        }
        II id = (II)CDAUtil.getChildElement((EObject)element, "id");
        ClinicalStatement target = null;
        ClinicalDocument clinicalDocument = CDAUtil.getClinicalDocument((EObject)element);
        if (clinicalDocument != null) {
            Query query = new Query(clinicalDocument);
            target = query.getClinicalStatement(ClinicalStatement.class, new ReferenceFilter(id));
        }
        return target;
    }

    public static void init(EObject eObject) {
        Initializer.Registry reg = Initializer.Util.getRegistry((EObject)eObject);
        AnnotationBasedInitializer.ensureCompatibility(eObject.eClass(), reg);
        CDAUtil.init(eObject, reg);
    }

    public static EObject init(EObject eObject, Initializer.Registry initializerRegistry) {
        EObject result = eObject;
        for (Initializer next : initializerRegistry.getInitializers(eObject.eClass())) {
            result = next.initialize(eObject);
        }
        return result;
    }

    public static void init(EObject eObject, Map<String, String> details) {
        ArrayList<String> created = new ArrayList<String>();
        for (String key : details.keySet()) {
            try {
                String s;
                String path = key.replace(".", "/");
                if (path.contains("/") && !created.contains(s = path.substring(0, path.lastIndexOf("/")))) {
                    CDAUtil.create(eObject, s);
                    created.add(s);
                }
                CDAUtil.set(eObject, path, details.get(key));
            }
            catch (Exception exception) {}
        }
    }

    public static <T> T create(EObject root, String path) {
        return CDAUtil.create(root, path, null);
    }

    public static <T> T create(EObject root, String path, EClass eClass) {
        EObject current = root;
        String[] components = path.split("/");
        int currentIndex = 0;
        String[] stringArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            String component = stringArray[n2];
            EStructuralFeature feature = current.eClass().getEStructuralFeature(component);
            if (feature instanceof EReference) {
                EObject eObject = null;
                Object value = current.eGet(feature);
                if (value == null || feature.isMany()) {
                    EClass type = (EClass)feature.getEType();
                    eObject = currentIndex == components.length - 1 && eClass != null && type.isSuperTypeOf(eClass) ? EcoreUtil.create((EClass)eClass) : EcoreUtil.create((EClass)type);
                    if (feature.isMany()) {
                        List list = (List)value;
                        list.add(eObject);
                    } else {
                        current.eSet(feature, (Object)eObject);
                    }
                } else {
                    eObject = (EObject)value;
                }
                current = eObject;
            }
            ++currentIndex;
            ++n2;
        }
        return (T)current;
    }

    public static void set(EObject root, String path, Object value) {
        EObject target;
        String last = path.substring(path.lastIndexOf("/") + 1);
        EObject eObject = target = path.equals(last) ? root : (EObject)CDAUtil.get(root, path.substring(0, path.lastIndexOf("/")));
        if (target != null) {
            String name = null;
            Integer index = null;
            Matcher matcher = COMPONENT_PATTERN.matcher(last);
            if (matcher.matches()) {
                EStructuralFeature feature;
                name = matcher.group(1);
                if (matcher.group(3) != null) {
                    index = Integer.valueOf(matcher.group(3)) - 1;
                }
                if ((feature = target.eClass().getEStructuralFeature(name)) != null && value != null) {
                    if (FeatureMapUtil.isFeatureMap((EStructuralFeature)feature) && value instanceof String) {
                        FeatureMap featureMap = (FeatureMap)target.eGet(feature);
                        FeatureMapUtil.addText((FeatureMap)featureMap, (String)((String)value));
                    } else {
                        if (feature instanceof EAttribute) {
                            EDataType type = (EDataType)feature.getEType();
                            if (value instanceof String && !type.isInstance(value)) {
                                value = EcoreUtil.createFromString((EDataType)type, (String)((String)value));
                            }
                        }
                        if (feature.isMany()) {
                            List list = (List)target.eGet(feature);
                            if (index != null) {
                                if (index >= 0 && index < list.size()) {
                                    list.set(index, value);
                                }
                            } else {
                                list.add(value);
                            }
                        } else {
                            target.eSet(feature, value);
                        }
                    }
                }
            }
        }
    }

    public static <T> T get(EObject root, String path) {
        String[] components;
        Object result = null;
        EObject current = root;
        String[] stringArray = components = path.split("/");
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            String component = stringArray[n2];
            if (current != null) {
                String name = null;
                Integer index = null;
                Matcher matcher = COMPONENT_PATTERN.matcher(component);
                if (matcher.matches()) {
                    EStructuralFeature feature;
                    name = matcher.group(1);
                    if (matcher.group(3) != null) {
                        index = Integer.valueOf(matcher.group(3)) - 1;
                    }
                    if ((feature = current.eClass().getEStructuralFeature(name)) != null) {
                        if (feature.isMany()) {
                            List list = (List)current.eGet(feature);
                            if (index == null) {
                                index = list.size() - 1;
                            }
                            result = index >= 0 && index < list.size() ? list.get(index) : null;
                        } else {
                            result = current.eGet(feature);
                        }
                        if (feature instanceof EReference) {
                            current = (EObject)result;
                        }
                    } else {
                        current = null;
                        result = null;
                    }
                }
            }
            ++n2;
        }
        return (T)result;
    }

    public static boolean isSet(EObject root, String path) {
        return CDAUtil.get(root, path) != null;
    }

    public static void unset(EObject root, String path) {
        EObject target;
        String last = path.substring(path.lastIndexOf("/") + 1);
        EObject eObject = target = path.equals(last) ? root : (EObject)CDAUtil.get(root, path.substring(0, path.lastIndexOf("/")));
        if (target != null) {
            String name = null;
            Integer index = null;
            Matcher matcher = COMPONENT_PATTERN.matcher(last);
            if (matcher.matches()) {
                EStructuralFeature feature;
                name = matcher.group(1);
                if (matcher.group(3) != null) {
                    index = Integer.valueOf(matcher.group(3)) - 1;
                }
                if ((feature = target.eClass().getEStructuralFeature(name)) != null) {
                    if (feature.isMany() && index != null) {
                        List list = (List)target.eGet(feature);
                        if (index >= 0 && index < list.size()) {
                            list.remove(index);
                        }
                    } else {
                        target.eUnset(feature);
                    }
                }
            }
        }
    }

    public static Object query(EObject eObject, String body) throws Exception {
        OCL.Helper helper = ocl.createOCLHelper();
        helper.setContext((Object)eObject.eClass());
        org.eclipse.ocl.ecore.OCLExpression expression = helper.createQuery(body);
        OCL.Query query = ocl.createQuery((OCLExpression)expression);
        return query.evaluate((Object)eObject);
    }

    public static boolean check(EObject eObject, String body) throws Exception {
        OCL.Helper helper = ocl.createOCLHelper();
        helper.setContext((Object)eObject.eClass());
        Constraint constraint = (Constraint)helper.createInvariant(body);
        OCL.Query query = ocl.createQuery(constraint);
        return query.check((Object)eObject);
    }

    public static <T extends Section> T getSection(ClinicalDocument clinicalDocument, Class<T> clazz, Filter<T> filter) {
        List<T> sections = CDAUtil.getSections(clinicalDocument, clazz, filter);
        return (T)(!sections.isEmpty() ? (Section)sections.get(0) : null);
    }

    public static <T extends Section> T getSection(ClinicalDocument clinicalDocument, Class<T> clazz) {
        List<T> sections = CDAUtil.getSections(clinicalDocument, clazz);
        return (T)(!sections.isEmpty() ? (Section)sections.get(0) : null);
    }

    public static <T extends Section> List<T> getSections(ClinicalDocument clinicalDocument, Class<T> clazz, Filter<T> filter) {
        ArrayList<Section> sections = new ArrayList<Section>();
        for (Section section : CDAUtil.getSections(clinicalDocument, clazz)) {
            if (!filter.accept(section)) continue;
            sections.add(section);
        }
        return sections;
    }

    public static <T extends Section> List<T> getSections(ClinicalDocument clinicalDocument, Class<T> clazz) {
        ArrayList<Section> sections = new ArrayList<Section>();
        for (Section section : CDAUtil.getAllSections(clinicalDocument)) {
            if (!clazz.isInstance(section)) continue;
            sections.add((Section)clazz.cast(section));
        }
        return sections;
    }

    public static List<Section> getAllSections(ClinicalDocument clinicalDocument) {
        StructuredBody structuredBody;
        ArrayList<Section> allSections = new ArrayList<Section>();
        Component2 component2 = clinicalDocument.getComponent();
        if (component2 != null && (structuredBody = component2.getStructuredBody()) != null) {
            for (Component3 component3 : structuredBody.getComponents()) {
                Section section = component3.getSection();
                if (section == null) continue;
                allSections.addAll(CDAUtil.getSections(section));
            }
        }
        return allSections;
    }

    public static List<Section> getAllSections(Section section) {
        return CDAUtil.getSections(section);
    }

    private static List<Section> getSections(Section section) {
        ArrayList<Section> sections = new ArrayList<Section>();
        LinkedList<Section> queue = new LinkedList<Section>();
        queue.add(section);
        while (!queue.isEmpty()) {
            Section sect = (Section)queue.remove();
            sections.add(sect);
            for (Component5 component : sect.getComponents()) {
                Section child = component.getSection();
                if (child == null) continue;
                queue.add(child);
            }
        }
        return sections;
    }

    public static <T extends ClinicalStatement> T getClinicalStatement(ClinicalDocument clinicalDocument, Class<T> clazz, Filter<T> filter) {
        List<T> clinicalStatements = CDAUtil.getClinicalStatements(clinicalDocument, clazz, filter);
        return (T)(!clinicalStatements.isEmpty() ? (ClinicalStatement)clinicalStatements.get(0) : null);
    }

    public static <T extends ClinicalStatement> T getClinicalStatement(ClinicalDocument clinicalDocument, Class<T> clazz) {
        List<T> clinicalStatements = CDAUtil.getClinicalStatements(clinicalDocument, clazz);
        return (T)(!clinicalStatements.isEmpty() ? (ClinicalStatement)clinicalStatements.get(0) : null);
    }

    public static <T extends ClinicalStatement> List<T> getClinicalStatements(ClinicalDocument clinicalDocument, Class<T> clazz, Filter<T> filter) {
        ArrayList<ClinicalStatement> clinicalStatements = new ArrayList<ClinicalStatement>();
        for (ClinicalStatement clinicalStatement : CDAUtil.getClinicalStatements(clinicalDocument, clazz)) {
            if (!filter.accept(clinicalStatement)) continue;
            clinicalStatements.add(clinicalStatement);
        }
        return clinicalStatements;
    }

    public static <T extends ClinicalStatement> List<T> getClinicalStatements(ClinicalDocument clinicalDocument, Class<T> clazz) {
        ArrayList<ClinicalStatement> clinicalStatements = new ArrayList<ClinicalStatement>();
        for (EObject eObject : CDAUtil.getAllClinicalStatements(clinicalDocument)) {
            if (!clazz.isInstance(eObject)) continue;
            clinicalStatements.add((ClinicalStatement)clazz.cast(eObject));
        }
        return clinicalStatements;
    }

    public static List<ClinicalStatement> getAllClinicalStatements(ClinicalDocument clinicalDocument) {
        ArrayList<ClinicalStatement> allClinicalStatements = new ArrayList<ClinicalStatement>();
        for (Section section : CDAUtil.getAllSections(clinicalDocument)) {
            allClinicalStatements.addAll(CDAUtil.getClinicalStatements(section));
        }
        return allClinicalStatements;
    }

    private static List<ClinicalStatement> getClinicalStatements(Section section) {
        ArrayList<ClinicalStatement> clinicalStatements = new ArrayList<ClinicalStatement>();
        for (Entry entry : section.getEntries()) {
            ClinicalStatement clinicalStatement = CDAUtil.getClinicalStatement(entry);
            if (clinicalStatement == null) continue;
            clinicalStatements.addAll(CDAUtil.getClinicalStatements(clinicalStatement));
        }
        return clinicalStatements;
    }

    private static List<ClinicalStatement> getClinicalStatements(ClinicalStatement clinicalStatement) {
        ArrayList<ClinicalStatement> clinicalStatements = new ArrayList<ClinicalStatement>();
        LinkedList<ClinicalStatement> queue = new LinkedList<ClinicalStatement>();
        queue.add(clinicalStatement);
        while (!queue.isEmpty()) {
            ClinicalStatement stmt = (ClinicalStatement)queue.remove();
            clinicalStatements.add(stmt);
            if (stmt instanceof Organizer) {
                Organizer organizer = (Organizer)stmt;
                for (Component4 component : organizer.getComponents()) {
                    ClinicalStatement child = CDAUtil.getClinicalStatement(component);
                    if (child == null) continue;
                    queue.add(child);
                }
                continue;
            }
            for (EntryRelationship entryRelationship : CDAUtil.getEntryRelationships(stmt)) {
                ClinicalStatement child = CDAUtil.getClinicalStatement(entryRelationship);
                if (child == null) continue;
                queue.add(child);
            }
        }
        return clinicalStatements;
    }

    private static List<EntryRelationship> getEntryRelationships(ClinicalStatement clinicalStatement) {
        if (clinicalStatement instanceof Act) {
            return ((Act)clinicalStatement).getEntryRelationships();
        }
        if (clinicalStatement instanceof Encounter) {
            return ((Encounter)clinicalStatement).getEntryRelationships();
        }
        if (clinicalStatement instanceof Observation) {
            return ((Observation)clinicalStatement).getEntryRelationships();
        }
        if (clinicalStatement instanceof ObservationMedia) {
            return ((ObservationMedia)clinicalStatement).getEntryRelationships();
        }
        if (clinicalStatement instanceof Procedure) {
            return ((Procedure)clinicalStatement).getEntryRelationships();
        }
        if (clinicalStatement instanceof RegionOfInterest) {
            return ((RegionOfInterest)clinicalStatement).getEntryRelationships();
        }
        if (clinicalStatement instanceof SubstanceAdministration) {
            return ((SubstanceAdministration)clinicalStatement).getEntryRelationships();
        }
        if (clinicalStatement instanceof Supply) {
            return ((Supply)clinicalStatement).getEntryRelationships();
        }
        return Collections.emptyList();
    }

    private static ClinicalStatement getClinicalStatement(Entry entry) {
        if (entry.getAct() != null) {
            return entry.getAct();
        }
        if (entry.getEncounter() != null) {
            return entry.getEncounter();
        }
        if (entry.getObservation() != null) {
            return entry.getObservation();
        }
        if (entry.getObservationMedia() != null) {
            return entry.getObservationMedia();
        }
        if (entry.getOrganizer() != null) {
            return entry.getOrganizer();
        }
        if (entry.getProcedure() != null) {
            return entry.getProcedure();
        }
        if (entry.getRegionOfInterest() != null) {
            return entry.getRegionOfInterest();
        }
        if (entry.getSubstanceAdministration() != null) {
            return entry.getSubstanceAdministration();
        }
        if (entry.getSupply() != null) {
            return entry.getSupply();
        }
        return null;
    }

    private static ClinicalStatement getClinicalStatement(EntryRelationship entryRelationship) {
        if (entryRelationship.getAct() != null) {
            return entryRelationship.getAct();
        }
        if (entryRelationship.getEncounter() != null) {
            return entryRelationship.getEncounter();
        }
        if (entryRelationship.getObservation() != null) {
            return entryRelationship.getObservation();
        }
        if (entryRelationship.getObservationMedia() != null) {
            return entryRelationship.getObservationMedia();
        }
        if (entryRelationship.getOrganizer() != null) {
            return entryRelationship.getOrganizer();
        }
        if (entryRelationship.getProcedure() != null) {
            return entryRelationship.getProcedure();
        }
        if (entryRelationship.getRegionOfInterest() != null) {
            return entryRelationship.getRegionOfInterest();
        }
        if (entryRelationship.getSubstanceAdministration() != null) {
            return entryRelationship.getSubstanceAdministration();
        }
        if (entryRelationship.getSupply() != null) {
            return entryRelationship.getSupply();
        }
        return null;
    }

    private static ClinicalStatement getClinicalStatement(Component4 component) {
        if (component.getAct() != null) {
            return component.getAct();
        }
        if (component.getEncounter() != null) {
            return component.getEncounter();
        }
        if (component.getObservation() != null) {
            return component.getObservation();
        }
        if (component.getObservationMedia() != null) {
            return component.getObservationMedia();
        }
        if (component.getOrganizer() != null) {
            return component.getOrganizer();
        }
        if (component.getProcedure() != null) {
            return component.getProcedure();
        }
        if (component.getRegionOfInterest() != null) {
            return component.getRegionOfInterest();
        }
        if (component.getSubstanceAdministration() != null) {
            return component.getSubstanceAdministration();
        }
        if (component.getSupply() != null) {
            return component.getSupply();
        }
        return null;
    }

    public static <T extends EObject> T getEObject(ClinicalDocument clinicalDocument, Class<T> clazz, Filter<T> filter) {
        List<T> eObjects = CDAUtil.getEObjects(clinicalDocument, clazz, filter);
        return (T)(!eObjects.isEmpty() ? (EObject)eObjects.get(0) : null);
    }

    public static <T extends EObject> T getEObject(ClinicalDocument clinicalDocument, Class<T> clazz) {
        List<T> eObjects = CDAUtil.getEObjects(clinicalDocument, clazz);
        return (T)(!eObjects.isEmpty() ? (EObject)eObjects.get(0) : null);
    }

    public static <T extends EObject> List<T> getEObjects(ClinicalDocument clinicalDocument, Class<T> clazz, Filter<T> filter) {
        ArrayList<EObject> eObjects = new ArrayList<EObject>();
        for (EObject eObject : CDAUtil.getEObjects(clinicalDocument, clazz)) {
            if (!filter.accept(eObject)) continue;
            eObjects.add(eObject);
        }
        return eObjects;
    }

    public static <T extends EObject> List<T> getEObjects(ClinicalDocument clinicalDocument, Class<T> clazz) {
        ArrayList<EObject> eObjects = new ArrayList<EObject>();
        for (EObject eObject : CDAUtil.getAllEObjects(clinicalDocument)) {
            if (!clazz.isInstance(eObject)) continue;
            eObjects.add((EObject)clazz.cast(eObject));
        }
        return eObjects;
    }

    public static List<EObject> getAllEObjects(ClinicalDocument clinicalDocument) {
        ArrayList<EObject> allEObjects = new ArrayList<EObject>();
        LinkedList<ClinicalDocument> queue = new LinkedList<ClinicalDocument>();
        queue.add(clinicalDocument);
        while (!queue.isEmpty()) {
            EObject eObject = (EObject)queue.remove();
            allEObjects.add(eObject);
            for (EObject child : eObject.eContents()) {
                queue.add((ClinicalDocument)child);
            }
        }
        return allEObjects;
    }

    public static CDAXPath createCDAXPath(ClinicalDocument clinicalDocument) {
        CDAXPath xpath = CACHE.get(clinicalDocument);
        if (xpath == null) {
            try {
                xpath = new CDAXPath(clinicalDocument);
                CACHE.put(clinicalDocument, xpath);
            }
            catch (Exception exception) {}
        }
        return xpath;
    }

    public static String getPath(EObject eObject) {
        String path = "";
        while (eObject != null && !(eObject instanceof DocumentRoot)) {
            List list;
            int index;
            EStructuralFeature feature = eObject.eContainingFeature();
            EObject container = eObject.eContainer();
            Object value = container.eGet(feature);
            path = feature.isMany() ? ((index = (list = (List)value).indexOf(eObject) + 1) > 1 ? "/" + CDAUtil.getName((ENamedElement)feature) + "[" + index + "]" + path : "/" + CDAUtil.getName((ENamedElement)feature) + path) : "/" + CDAUtil.getName((ENamedElement)feature) + path;
            eObject = eObject.eContainer();
        }
        return path;
    }

    public static String getName(ENamedElement eNamedElement) {
        String result = EcoreUtil.getAnnotation((EModelElement)eNamedElement, (String)"http:///org/eclipse/emf/ecore/util/ExtendedMetaData", (String)"name");
        if (result != null) {
            return result;
        }
        return eNamedElement.getName();
    }

    public static void loadPackages() {
        CDAPackageLoader.loadPackages();
    }

    public static void loadPackages(String location) {
        CDAPackageLoader.loadPackages(location);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CDAXPath {
        private ClinicalDocument clinicalDocument = null;
        private Document document = null;
        private DocumentRoot documentRoot = null;
        private Map<Node, Object> nodeToObject = null;
        private Map<Object, Node> objectToNode = null;
        private XPath xpath = null;

        public CDAXPath(ClinicalDocument clinicalDocument) throws Exception {
            this.clinicalDocument = clinicalDocument;
            this.nodeToObject = new HashMap<Node, Object>();
            this.objectToNode = new HashMap<Object, Node>();
            this.document = CDAUtil.save(clinicalDocument, new DOMHandler(){

                public DOMHelper getDOMHelper() {
                    return null;
                }

                public void recordValues(Node node, EObject container, EStructuralFeature feature, Object value) {
                    if (value != null) {
                        CDAXPath.this.nodeToObject.put(node, value);
                        CDAXPath.this.objectToNode.put(value, node);
                    }
                }
            });
            this.documentRoot = (DocumentRoot)clinicalDocument.eContainer();
            this.nodeToObject.put(this.document, this.documentRoot);
            this.objectToNode.put(this.documentRoot, this.document);
            this.xpath = XPathFactory.newInstance().newXPath();
            this.xpath.setNamespaceContext(new NamespaceContext(){

                @Override
                public String getNamespaceURI(String prefix) {
                    if ("cda".equals(prefix)) {
                        return "urn:hl7-org:v3";
                    }
                    if ("sdtc".equals(prefix)) {
                        return "urn:hl7-org:sdtc";
                    }
                    if ("xsi".equals(prefix)) {
                        return "http://www.w3.org/2001/XMLSchema-instance";
                    }
                    return null;
                }

                @Override
                public String getPrefix(String namespaceURI) {
                    if ("urn:hl7-org:v3".equals(namespaceURI)) {
                        return "cda";
                    }
                    if ("urn:hl7-org:sdtc".equals(namespaceURI)) {
                        return "sdtc";
                    }
                    if ("http://www.w3.org/2001/XMLSchema-instance".equals(namespaceURI)) {
                        return "xsi";
                    }
                    return null;
                }

                @Override
                public Iterator<String> getPrefixes(String namespaceURI) {
                    return null;
                }
            });
        }

        public Object evaluate(Node item, String expr, QName returnType) throws Exception {
            XPathExpression expression = this.xpath.compile(expr);
            return expression.evaluate(item, returnType);
        }

        public <T> T evaluate(Object item, String expr, Class<T> clazz) throws Exception {
            QName returnType = null;
            if (clazz.equals(Double.class)) {
                returnType = XPathConstants.NUMBER;
            } else if (clazz.equals(String.class)) {
                returnType = XPathConstants.STRING;
            } else if (clazz.equals(Boolean.class)) {
                returnType = XPathConstants.BOOLEAN;
            } else if (clazz.equals(NodeList.class)) {
                returnType = XPathConstants.NODESET;
            } else if (clazz.equals(Node.class)) {
                returnType = XPathConstants.NODE;
            }
            return returnType != null ? (T)clazz.cast(this.evaluate(this.getNode(item), expr, returnType)) : null;
        }

        public <T> T evaluate(String expr, Class<T> clazz) throws Exception {
            return this.evaluate(this.documentRoot, expr, clazz);
        }

        public Object evaluate(String expr, QName returnType) throws Exception {
            return this.evaluate(this.document, expr, returnType);
        }

        public ClinicalDocument getClinicalDocument() {
            return this.clinicalDocument;
        }

        public Document getDocument() {
            return this.document;
        }

        public DocumentRoot getDocumentRoot() {
            return this.documentRoot;
        }

        public Node getNode(Object object) {
            return this.objectToNode.get(object);
        }

        public Object getObject(Node node) {
            return this.nodeToObject.get(node);
        }

        public List<Node> selectNodes(Node item, String expr) throws Exception {
            ArrayList<Node> result = new ArrayList<Node>();
            NodeList nodeList = (NodeList)this.evaluate(item, expr, XPathConstants.NODESET);
            if (nodeList != null) {
                int i = 0;
                while (i < nodeList.getLength()) {
                    result.add(nodeList.item(i));
                    ++i;
                }
            }
            return result;
        }

        public <T extends EObject> List<T> selectNodes(Object item, String expr, Class<T> clazz) throws Exception {
            ArrayList<EObject> result = new ArrayList<EObject>();
            for (Node node : this.selectNodes(this.getNode(item), expr)) {
                Object object = this.getObject(node);
                if (!clazz.isInstance(object)) continue;
                result.add((EObject)clazz.cast(object));
            }
            return result;
        }

        public List<Node> selectNodes(String expr) throws Exception {
            return this.selectNodes(this.document, expr);
        }

        public <T extends EObject> List<T> selectNodes(String expr, Class<T> clazz) throws Exception {
            return this.selectNodes(this.documentRoot, expr, clazz);
        }

        public Node selectSingleNode(Node item, String expr) throws Exception {
            List<Node> result = this.selectNodes(item, expr);
            return !result.isEmpty() ? result.get(0) : null;
        }

        public <T extends EObject> T selectSingleNode(Object item, String expr, Class<T> clazz) throws Exception {
            List<T> result = this.selectNodes(item, expr, clazz);
            return (T)(!result.isEmpty() ? (EObject)result.get(0) : null);
        }

        public Node selectSingleNode(String expr) throws Exception {
            return this.selectSingleNode(this.document, expr);
        }

        public <T extends EObject> T selectSingleNode(String expr, Class<T> clazz) throws Exception {
            return this.selectSingleNode(this.documentRoot, expr, clazz);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Filter<T> {
        public boolean accept(T var1);
    }

    public static interface LoadHandler {
        public boolean handleUnknownFeature(EObject var1, EStructuralFeature var2, Object var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OCLFilter<T extends EObject>
    implements Filter<T> {
        protected String body = null;

        public OCLFilter(String body) {
            this.body = body;
        }

        @Override
        public boolean accept(T item) {
            boolean result = false;
            try {
                result = CDAUtil.check(item, this.body);
            }
            catch (Exception exception) {}
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Query {
        private ClinicalDocument clinicalDocument = null;
        private List<Section> allSections = null;
        private List<ClinicalStatement> allClinicalStatements = null;
        private List<EObject> allEObjects = null;

        public Query(ClinicalDocument clinicalDocument) {
            this.clinicalDocument = clinicalDocument;
        }

        public <T extends Section> T getSection(Class<T> clazz, Filter<T> filter) {
            List<T> sections = this.getSections(clazz, filter);
            return (T)(!sections.isEmpty() ? (Section)sections.get(0) : null);
        }

        public <T extends Section> T getSection(Class<T> clazz) {
            List<T> sections = this.getSections(clazz);
            return (T)(!sections.isEmpty() ? (Section)sections.get(0) : null);
        }

        public <T extends Section> List<T> getSections(Class<T> clazz, Filter<T> filter) {
            ArrayList<Section> sections = new ArrayList<Section>();
            for (Section section : this.getSections(clazz)) {
                if (!filter.accept(section)) continue;
                sections.add(section);
            }
            return sections;
        }

        public <T extends Section> List<T> getSections(Class<T> clazz) {
            ArrayList<Section> sections = new ArrayList<Section>();
            for (Section section : this.getAllSections()) {
                if (!clazz.isInstance(section)) continue;
                sections.add((Section)clazz.cast(section));
            }
            return sections;
        }

        public List<Section> getAllSections() {
            if (this.allSections == null) {
                this.allSections = CDAUtil.getAllSections(this.clinicalDocument);
            }
            return this.allSections;
        }

        public <T extends ClinicalStatement> T getClinicalStatement(Class<T> clazz, Filter<T> filter) {
            List<T> clinicalStatements = this.getClinicalStatements(clazz, filter);
            return (T)(!clinicalStatements.isEmpty() ? (ClinicalStatement)clinicalStatements.get(0) : null);
        }

        public <T extends ClinicalStatement> T getClinicalStatement(Class<T> clazz) {
            List<T> clinicalStatements = this.getClinicalStatements(clazz);
            return (T)(!clinicalStatements.isEmpty() ? (ClinicalStatement)clinicalStatements.get(0) : null);
        }

        public <T extends ClinicalStatement> List<T> getClinicalStatements(Class<T> clazz, Filter<T> filter) {
            ArrayList<ClinicalStatement> clinicalStatements = new ArrayList<ClinicalStatement>();
            for (ClinicalStatement clinicalStatement : this.getClinicalStatements(clazz)) {
                if (!filter.accept(clinicalStatement)) continue;
                clinicalStatements.add(clinicalStatement);
            }
            return clinicalStatements;
        }

        public <T extends ClinicalStatement> List<T> getClinicalStatements(Class<T> clazz) {
            ArrayList<ClinicalStatement> clinicalStatements = new ArrayList<ClinicalStatement>();
            for (EObject eObject : this.getAllClinicalStatements()) {
                if (!clazz.isInstance(eObject)) continue;
                clinicalStatements.add((ClinicalStatement)clazz.cast(eObject));
            }
            return clinicalStatements;
        }

        public List<ClinicalStatement> getAllClinicalStatements() {
            if (this.allClinicalStatements == null) {
                this.allClinicalStatements = CDAUtil.getAllClinicalStatements(this.clinicalDocument);
            }
            return this.allClinicalStatements;
        }

        public <T extends EObject> T getEObject(Class<T> clazz, Filter<T> filter) {
            List<T> eObjects = this.getEObjects(clazz, filter);
            return (T)(!eObjects.isEmpty() ? (EObject)eObjects.get(0) : null);
        }

        public <T extends EObject> T getEObject(Class<T> clazz) {
            List<T> eObjects = this.getEObjects(clazz);
            return (T)(!eObjects.isEmpty() ? (EObject)eObjects.get(0) : null);
        }

        public <T extends EObject> List<T> getEObjects(Class<T> clazz, Filter<T> filter) {
            ArrayList<EObject> eObjects = new ArrayList<EObject>();
            for (EObject eObject : this.getEObjects(clazz)) {
                if (!filter.accept(eObject)) continue;
                eObjects.add(eObject);
            }
            return eObjects;
        }

        public <T extends EObject> List<T> getEObjects(Class<T> clazz) {
            ArrayList<EObject> eObjects = new ArrayList<EObject>();
            for (EObject eObject : this.getAllEObjects()) {
                if (!clazz.isInstance(eObject)) continue;
                eObjects.add((EObject)clazz.cast(eObject));
            }
            return eObjects;
        }

        public List<EObject> getAllEObjects() {
            if (this.allEObjects == null) {
                this.allEObjects = CDAUtil.getAllEObjects(this.clinicalDocument);
            }
            return this.allEObjects;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReferenceFilter<T extends EObject>
    implements Filter<T> {
        private II id;

        public ReferenceFilter(II id) {
            this.id = id;
        }

        @Override
        public boolean accept(T item) {
            EObject itemId = CDAUtil.getChildElement(item, "id");
            EObject templateId = CDAUtil.getChildElement(item, "templateId");
            return itemId instanceof II && templateId != null && this.id.equals(itemId);
        }
    }

    public static class SchemaValidationHandler
    implements ErrorHandler {
        private ValidationHandler handler = null;

        public SchemaValidationHandler(ValidationHandler handler) {
            this.handler = handler;
        }

        public void error(SAXParseException exception) throws SAXException {
            this.handler.handleError(this.createDiagnostic(4, exception));
        }

        public void fatalError(SAXParseException exception) throws SAXException {
        }

        public void warning(SAXParseException exception) throws SAXException {
            this.handler.handleWarning(this.createDiagnostic(2, exception));
        }

        private Diagnostic createDiagnostic(int severity, SAXParseException exception) {
            return new BasicDiagnostic(severity, "javax.xml.validation.Validator", 0, exception.getMessage(), new Object[]{exception});
        }
    }

    public static interface ValidationHandler {
        public void handleError(Diagnostic var1);

        public void handleWarning(Diagnostic var1);

        public void handleInfo(Diagnostic var1);
    }
}

