/*
 * Decompiled with CFR 0.152.
 */
package org.openhealthtools.mdht.uml.cda.validate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class XPathIndexer
implements ContentHandler {
    private ElementEntry currentXMLElement = null;
    public HashMap<String, HashMap<String, ArrayList<Locator>>> elementIndexes = new HashMap();
    public HashMap<String, ElementLocationData> xpathLocations = new HashMap();
    public HashMap<String, ElementLocationData> xpathAttributes = new HashMap();
    Locator locator = null;

    public void characters(char[] text, int start, int length) throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void endElement(String namespace, String local, String name) throws SAXException {
        this.currentXMLElement = this.currentXMLElement.elementParent;
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public ElementLocationData getAttributeLocationByValue(String value) {
        ElementLocationData elementLocationData = null;
        if (this.xpathAttributes.containsKey(value)) {
            elementLocationData = this.xpathAttributes.get(value);
        }
        return elementLocationData;
    }

    public ElementLocationData getElementLocationByPath(String xpath) {
        ElementLocationData elementLocationData = null;
        String upperXPath = xpath.toUpperCase();
        if (this.xpathLocations.containsKey(upperXPath)) {
            elementLocationData = this.xpathLocations.get(upperXPath);
        }
        return elementLocationData;
    }

    private String getXPathFromEntry(ElementEntry elementEntry) {
        Stack<String> path = new Stack<String>();
        while (elementEntry != null) {
            path.push("/" + elementEntry.elementName + "[" + elementEntry.elementIndex + "]");
            elementEntry = elementEntry.elementParent;
        }
        String result = "";
        while (!path.isEmpty()) {
            result = String.valueOf(result) + (String)path.pop();
        }
        return result;
    }

    public void ignorableWhitespace(char[] text, int start, int length) throws SAXException {
    }

    private int indexElement(String parent, String element) {
        if (!this.elementIndexes.containsKey(parent)) {
            this.elementIndexes.put(parent, new HashMap());
        }
        if (!this.elementIndexes.get(parent).containsKey(element)) {
            this.elementIndexes.get(parent).put(element, new ArrayList());
        }
        this.elementIndexes.get(parent).get(element).add(this.locator);
        return this.elementIndexes.get(parent).get(element).size();
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void startDocument() throws SAXException {
    }

    public void startElement(String namespace, String local, String name, Attributes attrs) throws SAXException {
        int index = this.indexElement(this.getXPathFromEntry(this.currentXMLElement), name);
        this.currentXMLElement = new ElementEntry(name, index, this.currentXMLElement);
        ElementLocationData location = new ElementLocationData(this.locator.getLineNumber(), this.locator.getColumnNumber());
        this.xpathLocations.put(this.getXPathFromEntry(this.currentXMLElement).toUpperCase(), location);
        int actr = 0;
        while (actr < attrs.getLength()) {
            if (!this.xpathAttributes.containsKey(attrs.getValue(actr))) {
                this.xpathAttributes.put(attrs.getValue(actr), location);
            }
            ++actr;
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    private static class ElementEntry {
        final String elementName;
        final int elementIndex;
        final ElementEntry elementParent;

        ElementEntry(String elementName, int elementIndex, ElementEntry next) {
            this.elementName = elementName;
            this.elementIndex = elementIndex;
            this.elementParent = next;
        }
    }

    public static class ElementLocationData {
        public int line;
        public int column;

        public ElementLocationData(int line, int column) {
            this.line = line;
            this.column = column;
        }
    }
}

