/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.experiment.agent;

import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import org.openimaj.aop.ClassTransformer;
import org.openimaj.experiment.annotations.Time;

public class TimeClassTransformer
implements ClassTransformer {
    public void transform(String className, CtClass ctclz) throws Exception {
        CtMethod[] methods;
        for (CtMethod m : methods = ctclz.getDeclaredMethods()) {
            Time ann = (Time)m.getAnnotation(Time.class);
            if (ann == null) continue;
            String timerName = ann.identifier();
            if (timerName == null || timerName.length() == 0) {
                timerName = String.format("%s#%s", className, m.getLongName());
            }
            TimeClassTransformer.addTimingInterceptor(ctclz, m, timerName);
        }
    }

    private static void addTimingInterceptor(CtClass clazz, CtMethod method, String timerName) throws CannotCompileException, NotFoundException {
        String oname = method.getName();
        String nname = oname + "$impl";
        method.setName(nname);
        CtMethod interceptor = CtNewMethod.copy((CtMethod)method, (String)oname, (CtClass)clazz, null);
        String type = method.getReturnType().getName();
        StringBuffer body = new StringBuffer();
        body.append("{\norg.openimaj.time.NanoTimer timer = org.openimaj.time.NanoTimer.timer();\n");
        if (!"void".equals(type)) {
            body.append(type + " result = ");
        }
        body.append(nname + "($$);\n");
        body.append("timer.stop();org.openimaj.experiment.agent.TimeTracker.accumulate(\"" + timerName + "\", timer.duration());\n");
        if (!"void".equals(type)) {
            body.append("return result;\n");
        }
        body.append("}");
        interceptor.setBody(body.toString());
        clazz.addMethod(interceptor);
    }
}

