/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.experiment.dataset.sampling;

import java.util.ArrayList;
import java.util.Collections;
import org.openimaj.data.dataset.Dataset;
import org.openimaj.data.dataset.GroupedDataset;
import org.openimaj.data.dataset.ListDataset;
import org.openimaj.data.dataset.MapBackedDataset;
import org.openimaj.experiment.dataset.sampling.Sampler;

public class GroupSampler<KEY, INSTANCE>
implements Sampler<GroupedDataset<KEY, ? extends ListDataset<INSTANCE>, INSTANCE>> {
    int numGroups;
    boolean random;

    public GroupSampler(int numGroups, boolean random) {
        this.numGroups = numGroups;
        this.random = random;
    }

    @Override
    public GroupedDataset<KEY, ListDataset<INSTANCE>, INSTANCE> sample(GroupedDataset<KEY, ? extends ListDataset<INSTANCE>, INSTANCE> dataset) {
        MapBackedDataset sample = new MapBackedDataset();
        ArrayList keys = new ArrayList(dataset.getGroups());
        if (this.random) {
            Collections.shuffle(keys);
        }
        for (int i = 0; i < this.numGroups; ++i) {
            Object key = keys.get(i);
            sample.add(key, (Dataset)dataset.get(key));
        }
        return sample;
    }

    public static <KEY, INSTANCE> GroupedDataset<KEY, ListDataset<INSTANCE>, INSTANCE> sample(GroupedDataset<KEY, ? extends ListDataset<INSTANCE>, INSTANCE> dataset, int numGroups, boolean random) {
        return new GroupSampler<KEY, INSTANCE>(numGroups, random).sample(dataset);
    }
}

