/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.experiment.dataset.sampling;

import java.util.Map;
import org.openimaj.data.RandomData;
import org.openimaj.data.dataset.GroupedDataset;
import org.openimaj.data.dataset.ListBackedDataset;
import org.openimaj.data.dataset.ListDataset;
import org.openimaj.data.dataset.MapBackedDataset;
import org.openimaj.experiment.dataset.sampling.Sampler;
import org.openimaj.util.pair.IndependentPair;

public class GroupedUniformRandomisedSampler<KEY, INSTANCE>
implements Sampler<GroupedDataset<KEY, ? extends ListDataset<INSTANCE>, INSTANCE>> {
    private boolean withReplacement = false;
    private double percentage;

    public GroupedUniformRandomisedSampler(double percentage) {
        if (percentage < 0.0 || percentage > 1.0) {
            throw new IllegalArgumentException("percentage of sample instances must be between 0 and 1");
        }
        this.percentage = percentage;
    }

    public GroupedUniformRandomisedSampler(double percentage, boolean withReplacement) {
        this(percentage);
        this.withReplacement = withReplacement;
    }

    public GroupedUniformRandomisedSampler(int number) {
        if (number < 1) {
            throw new IllegalArgumentException("number of sample instances must be greater than 0");
        }
        this.percentage = -number;
    }

    public GroupedUniformRandomisedSampler(int number, boolean withReplacement) {
        this(number);
        this.withReplacement = withReplacement;
    }

    @Override
    public GroupedDataset<KEY, ListDataset<INSTANCE>, INSTANCE> sample(GroupedDataset<KEY, ? extends ListDataset<INSTANCE>, INSTANCE> dataset) {
        int N = this.percentage >= 0.0 ? (int)Math.round((double)dataset.numInstances() * this.percentage) : (int)(-this.percentage);
        int[] selectedIds = this.withReplacement ? RandomData.getRandomIntArray((int)N, (int)0, (int)dataset.numInstances()) : RandomData.getUniqueRandomInts((int)N, (int)0, (int)dataset.numInstances());
        MapBackedDataset sample = new MapBackedDataset();
        Map map = sample.getMap();
        for (int i = 0; i < N; ++i) {
            IndependentPair<KEY, INSTANCE> p = this.select(selectedIds[i], dataset);
            ListBackedDataset lbd = (ListBackedDataset)map.get(p.firstObject());
            if (lbd == null) {
                lbd = new ListBackedDataset();
                map.put(p.firstObject(), lbd);
            }
            lbd.add(p.getSecondObject());
        }
        return sample;
    }

    private IndependentPair<KEY, INSTANCE> select(int idx, GroupedDataset<KEY, ? extends ListDataset<INSTANCE>, INSTANCE> dataset) {
        for (Object k : dataset.getGroups()) {
            ListDataset instances = (ListDataset)dataset.getInstances(k);
            int sz = instances.size();
            if (idx < sz) {
                return new IndependentPair(k, instances.getInstance(idx));
            }
            idx -= sz;
        }
        return null;
    }

    public static <KEY, INSTANCE> GroupedDataset<KEY, ListDataset<INSTANCE>, INSTANCE> sample(GroupedDataset<KEY, ? extends ListDataset<INSTANCE>, INSTANCE> dataset, double percentage) {
        return new GroupedUniformRandomisedSampler<KEY, INSTANCE>(percentage).sample(dataset);
    }

    public static <KEY, INSTANCE> GroupedDataset<KEY, ListDataset<INSTANCE>, INSTANCE> sample(GroupedDataset<KEY, ? extends ListDataset<INSTANCE>, INSTANCE> dataset, double percentage, boolean withReplacement) {
        return new GroupedUniformRandomisedSampler<KEY, INSTANCE>(percentage, withReplacement).sample(dataset);
    }

    public static <KEY, INSTANCE> GroupedDataset<KEY, ListDataset<INSTANCE>, INSTANCE> sample(GroupedDataset<KEY, ? extends ListDataset<INSTANCE>, INSTANCE> dataset, int number) {
        return new GroupedUniformRandomisedSampler<KEY, INSTANCE>(number).sample(dataset);
    }

    public static <KEY, INSTANCE> GroupedDataset<KEY, ListDataset<INSTANCE>, INSTANCE> sample(GroupedDataset<KEY, ? extends ListDataset<INSTANCE>, INSTANCE> dataset, int number, boolean withReplacement) {
        return new GroupedUniformRandomisedSampler<KEY, INSTANCE>(number, withReplacement).sample(dataset);
    }
}

