/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.experiment.dataset.sampling;

import java.util.List;
import java.util.Map;
import org.openimaj.data.RandomData;
import org.openimaj.data.dataset.GroupedDataset;
import org.openimaj.data.dataset.ListBackedDataset;
import org.openimaj.data.dataset.ListDataset;
import org.openimaj.data.dataset.MapBackedDataset;
import org.openimaj.experiment.dataset.sampling.Sampler;
import org.openimaj.experiment.dataset.util.DatasetAdaptors;
import org.openimaj.util.list.AcceptingListView;
import org.openimaj.util.list.SkippingListView;

public class StratifiedGroupedUniformRandomisedSampler<KEY, INSTANCE>
implements Sampler<GroupedDataset<KEY, ListDataset<INSTANCE>, INSTANCE>> {
    private boolean withReplacement = false;
    private double percentage;

    public StratifiedGroupedUniformRandomisedSampler(double percentage) {
        if (percentage < 0.0 || percentage > 1.0) {
            throw new IllegalArgumentException("percentage of sample instances must be between 0 and 1");
        }
        this.percentage = percentage;
    }

    public StratifiedGroupedUniformRandomisedSampler(double percentage, boolean withReplacement) {
        this(percentage);
        this.withReplacement = withReplacement;
    }

    public StratifiedGroupedUniformRandomisedSampler(int number) {
        if (number < 1) {
            throw new IllegalArgumentException("number of sample instances must be greater than 1");
        }
        this.percentage = -number;
    }

    public StratifiedGroupedUniformRandomisedSampler(int number, boolean withReplacement) {
        this(number);
        this.withReplacement = withReplacement;
    }

    @Override
    public GroupedDataset<KEY, ListDataset<INSTANCE>, INSTANCE> sample(GroupedDataset<KEY, ListDataset<INSTANCE>, INSTANCE> dataset) {
        MapBackedDataset sample = new MapBackedDataset();
        Map map = sample.getMap();
        for (Object key : dataset.getGroups()) {
            int N;
            boolean skip;
            List list = DatasetAdaptors.asList(dataset.getInstances(key));
            int size = list.size();
            if (this.percentage >= 0.0) {
                skip = this.percentage > 0.5;
                double per = skip ? 1.0 - this.percentage : this.percentage;
                N = (int)Math.round((double)size * per);
            } else {
                N = (int)(-this.percentage);
                skip = N > size / 2;
            }
            int[] selectedIds = this.withReplacement ? RandomData.getRandomIntArray((int)N, (int)0, (int)size) : RandomData.getUniqueRandomInts((int)N, (int)0, (int)size);
            if (!skip) {
                map.put(key, new ListBackedDataset((List)new AcceptingListView(list, selectedIds)));
                continue;
            }
            map.put(key, new ListBackedDataset((List)new SkippingListView(list, selectedIds)));
        }
        return sample;
    }
}

