/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.experiment.evaluation.classification;

import gnu.trove.map.hash.TObjectDoubleHashMap;
import gnu.trove.procedure.TObjectDoubleProcedure;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.openimaj.experiment.evaluation.classification.ClassificationResult;
import org.openimaj.util.pair.ObjectDoublePair;

public class BasicClassificationResult<CLASS>
implements ClassificationResult<CLASS> {
    private final TObjectDoubleHashMap<CLASS> data = new TObjectDoubleHashMap();
    private double threshold = 0.0;

    public BasicClassificationResult() {
    }

    public BasicClassificationResult(double threshold) {
        this.threshold = threshold;
    }

    public void put(CLASS clz, double confidence) {
        this.data.put(clz, confidence);
    }

    @Override
    public double getConfidence(CLASS clazz) {
        return this.data.get(clazz);
    }

    @Override
    public Set<CLASS> getPredictedClasses() {
        final ArrayList toSort = new ArrayList();
        this.data.forEachEntry(new TObjectDoubleProcedure<CLASS>(){

            public boolean execute(CLASS key, double confidence) {
                if (confidence > BasicClassificationResult.this.threshold) {
                    toSort.add(new ObjectDoublePair(key, confidence));
                }
                return true;
            }
        });
        Collections.sort(toSort, new Comparator<ObjectDoublePair<CLASS>>(){

            @Override
            public int compare(ObjectDoublePair<CLASS> o1, ObjectDoublePair<CLASS> o2) {
                return -1 * Double.compare(o1.second, o2.second);
            }
        });
        LinkedHashSet<Object> keys = new LinkedHashSet<Object>(toSort.size());
        for (ObjectDoublePair p : toSort) {
            keys.add(p.first);
        }
        return keys;
    }
}

