/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.experiment.evaluation.cluster.analyser;

import gnu.trove.map.hash.TIntLongHashMap;
import gnu.trove.procedure.TIntLongProcedure;
import gov.sandia.cognition.math.MathUtil;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;
import org.openimaj.experiment.evaluation.cluster.analyser.AdjustedRandomIndexAnalysis;
import org.openimaj.experiment.evaluation.cluster.analyser.ClusterAnalyser;
import org.openimaj.experiment.evaluation.cluster.analyser.ClusterAnalyserUtils;

public class AdjustedRandomIndexClusterAnalyser
implements ClusterAnalyser<AdjustedRandomIndexAnalysis> {
    static final Logger logger = Logger.getLogger(AdjustedRandomIndexAnalysis.class);

    @Override
    public AdjustedRandomIndexAnalysis analyse(int[][] correct, int[][] estimated) {
        TIntLongHashMap nij = new TIntLongHashMap();
        TIntLongHashMap ni = new TIntLongHashMap();
        TIntLongHashMap nj = new TIntLongHashMap();
        Map<Integer, Integer> invCor = ClusterAnalyserUtils.invert(correct);
        logger.debug((Object)("Correct keys: " + invCor.size()));
        Map<Integer, Integer> invEst = ClusterAnalyserUtils.invert(estimated);
        logger.debug((Object)("Estimated keys: " + invCor.size()));
        HashSet<Integer> sharedKeys = new HashSet<Integer>();
        sharedKeys.addAll(invCor.keySet());
        sharedKeys.retainAll(invEst.keySet());
        logger.debug((Object)("Shared keys: " + sharedKeys.size()));
        for (Integer index : sharedKeys) {
            int i = invCor.get(index);
            int j = invEst.get(index);
            nij.adjustOrPutValue(i * correct.length + j, 1L, 1L);
            ni.adjustOrPutValue(i, 1L, 1L);
            nj.adjustOrPutValue(j, 1L, 1L);
        }
        final long[] sumnij = new long[1];
        final long[] sumni = new long[1];
        final long[] sumnj = new long[1];
        final long[] sumn = new long[1];
        nj.forEachEntry(new TIntLongProcedure(){

            public boolean execute(int a, long b) {
                if (b > 1L) {
                    sumnj[0] = sumnj[0] + (long)MathUtil.binomialCoefficient((int)((int)b), (int)2);
                }
                return true;
            }
        });
        ni.forEachEntry(new TIntLongProcedure(){

            public boolean execute(int a, long b) {
                if (b > 1L) {
                    sumni[0] = sumni[0] + (long)MathUtil.binomialCoefficient((int)((int)b), (int)2);
                }
                sumn[0] = sumn[0] + b;
                return true;
            }
        });
        nij.forEachEntry(new TIntLongProcedure(){

            public boolean execute(int a, long b) {
                if (b > 1L) {
                    sumnij[0] = sumnij[0] + (long)MathUtil.binomialCoefficient((int)((int)b), (int)2);
                }
                return true;
            }
        });
        double bisumn = MathUtil.binomialCoefficient((int)((int)sumn[0]), (int)2);
        double div = (double)(sumni[0] * sumnj[0]) / bisumn;
        AdjustedRandomIndexAnalysis ret = new AdjustedRandomIndexAnalysis();
        ret.adjRandInd = ((double)sumnij[0] - div) / (0.5 * (double)(sumni[0] + sumnj[0]) - div);
        return ret;
    }
}

