/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.experiment.evaluation.cluster.analyser;

import gov.sandia.cognition.math.MathUtil;
import java.util.Map;
import org.openimaj.experiment.evaluation.AnalysisResult;
import org.openimaj.experiment.evaluation.cluster.analyser.ClusterAnalyser;
import org.openimaj.experiment.evaluation.cluster.analyser.ClusterAnalyserUtils;
import org.openimaj.experiment.evaluation.cluster.analyser.DecisionAnalysis;

public abstract class DecisionClusterAnalyser<T extends AnalysisResult>
implements ClusterAnalyser<T> {
    @Override
    public T analyse(int[][] correct, int[][] estimated) {
        DecisionAnalysis ret = new DecisionAnalysis();
        Map<Integer, Integer> invCor = ClusterAnalyserUtils.invert(correct);
        long positive = 0L;
        long negative = 0L;
        long remainingTotal = 0L;
        long[] remaining = new long[correct.length];
        long[] classCount = new long[correct.length];
        for (int i = 0; i < correct.length; ++i) {
            remainingTotal += (long)correct[i].length;
            remaining[i] = correct[i].length;
        }
        ret.FN = 0L;
        ret.TP = 0L;
        for (int[] cluster : estimated) {
            if (cluster.length > 1) {
                positive += (long)MathUtil.binomialCoefficient((int)cluster.length, (int)2);
            }
            negative += (remainingTotal -= (long)cluster.length) * (long)cluster.length;
            for (int i : cluster) {
                Integer integer = invCor.get(i);
                if (integer == null) continue;
                int n = integer;
                classCount[n] = classCount[n] + 1L;
            }
            for (int i = 0; i < classCount.length; ++i) {
                if (classCount[i] > 1L) {
                    ret.TP += (long)MathUtil.binomialCoefficient((int)((int)classCount[i]), (int)2);
                }
                int n = i;
                remaining[n] = remaining[n] - classCount[i];
                ret.FN += remaining[i] * classCount[i];
                classCount[i] = 0L;
            }
        }
        ret.FP = positive - ret.TP;
        ret.TN = negative - ret.FN;
        return this.analysisResults(ret);
    }

    public abstract T analysisResults(DecisionAnalysis var1);
}

