/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.experiment.evaluation.retrieval.analysers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.lemurproject.ireval.IREval;
import org.lemurproject.ireval.RetrievalEvaluator;
import org.openimaj.data.identity.Identifiable;
import org.openimaj.experiment.evaluation.retrieval.Ranked;
import org.openimaj.experiment.evaluation.retrieval.RetrievalAnalyser;
import org.openimaj.experiment.evaluation.retrieval.Scored;
import org.openimaj.experiment.evaluation.retrieval.analysers.IREvalResult;

public class IREvalAnalyser<QUERY, DOCUMENT extends Identifiable>
implements RetrievalAnalyser<IREvalResult, QUERY, DOCUMENT> {
    protected static <Q, D extends Identifiable> TreeMap<String, ArrayList<RetrievalEvaluator.Document>> convertResults(Map<Q, List<D>> results) {
        TreeMap<String, ArrayList<RetrievalEvaluator.Document>> allRankings = new TreeMap<String, ArrayList<RetrievalEvaluator.Document>>();
        for (Map.Entry<Q, List<D>> entry : results.entrySet()) {
            String key = entry.getKey() instanceof Identifiable ? ((Identifiable)entry.getKey()).getID() : entry.getKey().toString();
            ArrayList<RetrievalEvaluator.Document> docs = new ArrayList<RetrievalEvaluator.Document>();
            for (int i = 0; i < entry.getValue().size(); ++i) {
                Identifiable doc = (Identifiable)entry.getValue().get(i);
                int rnk = i + 1;
                if (doc instanceof Ranked) {
                    rnk = ((Ranked)doc).getRank();
                }
                double score = 1.0 / (double)rnk;
                if (doc instanceof Scored) {
                    score = ((Scored)doc).getScore();
                }
                docs.add(new RetrievalEvaluator.Document(doc.getID(), rnk, score));
            }
            allRankings.put(key, docs);
        }
        return allRankings;
    }

    protected static <Q, D extends Identifiable> TreeMap<String, ArrayList<RetrievalEvaluator.Judgment>> convertRelevant(Map<Q, Set<D>> relevant) {
        TreeMap<String, ArrayList<RetrievalEvaluator.Judgment>> allJudgments = new TreeMap<String, ArrayList<RetrievalEvaluator.Judgment>>();
        for (Map.Entry<Q, Set<D>> entry : relevant.entrySet()) {
            String key = entry.getKey() instanceof Identifiable ? ((Identifiable)entry.getKey()).getID() : entry.getKey().toString();
            ArrayList<RetrievalEvaluator.Judgment> docs = new ArrayList<RetrievalEvaluator.Judgment>();
            for (Identifiable doc : entry.getValue()) {
                docs.add(new RetrievalEvaluator.Judgment(doc.getID(), 1));
            }
            allJudgments.put(key, docs);
        }
        return allJudgments;
    }

    @Override
    public IREvalResult analyse(Map<QUERY, List<DOCUMENT>> results, Map<QUERY, Set<DOCUMENT>> relevant) {
        return new IREvalResult(IREval.create(IREvalAnalyser.convertResults(results), IREvalAnalyser.convertRelevant(relevant)));
    }
}

