/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.experiment.evaluation.retrieval.analysers;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openimaj.data.identity.Identifiable;
import org.openimaj.experiment.evaluation.retrieval.RetrievalAnalyser;
import org.openimaj.experiment.evaluation.retrieval.analysers.PrecisionAtNResult;

public class PrecisionAtN<QUERY, DOCUMENT extends Identifiable>
implements RetrievalAnalyser<PrecisionAtNResult<QUERY>, QUERY, DOCUMENT> {
    protected int N;

    public PrecisionAtN(int n) {
        this.N = n;
    }

    @Override
    public PrecisionAtNResult<QUERY> analyse(Map<QUERY, List<DOCUMENT>> results, Map<QUERY, Set<DOCUMENT>> relevant) {
        PrecisionAtNResult scores = new PrecisionAtNResult(this.N);
        for (QUERY query : relevant.keySet()) {
            List<DOCUMENT> qres = results.get(query);
            if (qres != null) {
                List<DOCUMENT> topN = qres.subList(0, Math.min(this.N, qres.size()));
                scores.allScores.put(query, this.score(topN, relevant.get(query)));
                continue;
            }
            scores.allScores.put(query, 0.0);
        }
        return null;
    }

    private double score(List<DOCUMENT> topN, Set<DOCUMENT> rel) {
        int count = 0;
        for (Identifiable ret : topN) {
            if (!rel.contains(ret)) continue;
            ++count;
        }
        return (double)count / (double)topN.size();
    }
}

