/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image;

import com.sun.media.jai.codec.SeekableStream;
import com.twelvemonkeys.imageio.plugins.jpeg.JPEGImageReader;
import com.twelvemonkeys.imageio.plugins.jpeg.JPEGImageReaderSpi;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.spi.IIORegistry;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.JAI;
import org.apache.sanselan.ImageFormat;
import org.apache.sanselan.ImageInfo;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.Sanselan;

class ExtendedImageIO {
    ExtendedImageIO() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage read(File input) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("input == null!");
        }
        if (!input.canRead()) {
            throw new IIOException("Can't read input file!");
        }
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(input);
            BufferedImage bufferedImage = ExtendedImageIO.read(stream);
            return bufferedImage;
        }
        finally {
            try {
                ((InputStream)stream).close();
            }
            catch (IOException iOException) {}
        }
    }

    public static BufferedImage read(InputStream input) throws IOException {
        BufferedImage bi;
        if (input == null) {
            throw new IllegalArgumentException("input == null!");
        }
        NonClosableInputStream buffer = new NonClosableInputStream(input);
        buffer.mark(0xA00000);
        try {
            bi = ExtendedImageIO.readInternal(buffer);
        }
        catch (Exception ex) {
            bi = null;
        }
        if (bi == null) {
            buffer.reset();
            try {
                bi = Sanselan.getBufferedImage((InputStream)buffer);
            }
            catch (Throwable e) {
                throw new IOException(e);
            }
        }
        return bi;
    }

    public static BufferedImage read(URL input) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("input == null!");
        }
        InputStream istream = null;
        try {
            istream = input.openStream();
        }
        catch (IOException e) {
            throw new IIOException("Can't get input stream from URL!", e);
        }
        return ExtendedImageIO.read(istream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage readInternal(BufferedInputStream binput) throws IOException, ImageReadException {
        ImageInfo info;
        if (binput == null) {
            throw new IllegalArgumentException("stream == null!");
        }
        try {
            info = Sanselan.getImageInfo((InputStream)binput, null);
        }
        catch (ImageReadException ire) {
            info = null;
        }
        finally {
            binput.reset();
        }
        if (info != null && info.getFormat() == ImageFormat.IMAGE_FORMAT_JPEG) {
            if (info.getColorType() == 3) {
                ImageReader reader = ExtendedImageIO.getMonkeyReader();
                if (reader == null) {
                    return ImageIO.read(binput);
                }
                return ExtendedImageIO.loadWithReader(reader, binput);
            }
            try {
                Class.forName("com.sun.image.codec.jpeg.ImageFormatException");
                Class<JAI> reader = JAI.class;
                synchronized (JAI.class) {
                    // ** MonitorExit[reader] (shouldn't be in output)
                    return JAI.create((String)"stream", (Object)SeekableStream.wrapInputStream((InputStream)binput, (boolean)false)).getAsBufferedImage();
                }
            }
            catch (Exception e) {
                binput.reset();
                ImageReader reader = ExtendedImageIO.getMonkeyReader();
                if (reader == null) {
                    return ImageIO.read(binput);
                }
                try {
                    return ExtendedImageIO.loadWithReader(reader, binput);
                }
                catch (Exception ee) {
                    return ImageIO.read(binput);
                }
            }
        }
        return ImageIO.read(binput);
    }

    private static BufferedImage loadWithReader(ImageReader reader, BufferedInputStream binput) throws IOException {
        ImageInputStream stream = ImageIO.createImageInputStream(binput);
        ImageReadParam param = reader.getDefaultReadParam();
        reader.setInput(stream, true, true);
        return reader.read(0, param);
    }

    private static ImageReader getMonkeyReader() {
        ImageReader reader;
        Iterator<ImageReader> iter = ImageIO.getImageReadersByFormatName("jpeg");
        while (iter.hasNext()) {
            reader = iter.next();
            if (!(reader instanceof JPEGImageReader)) continue;
            return reader;
        }
        IIORegistry.getDefaultInstance().registerServiceProvider(new JPEGImageReaderSpi());
        iter = ImageIO.getImageReadersByFormatName("jpeg");
        while (iter.hasNext()) {
            reader = iter.next();
            if (!(reader instanceof JPEGImageReader)) continue;
            return reader;
        }
        return null;
    }

    static class NonClosableInputStream
    extends BufferedInputStream {
        public NonClosableInputStream(InputStream in) {
            super(in);
        }

        @Override
        public void close() throws IOException {
        }

        public void reallyClose() throws IOException {
            super.close();
        }
    }
}

