/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image;

import java.util.Comparator;
import org.openimaj.image.FImage;
import org.openimaj.image.ImageUtilities;
import org.openimaj.image.MultiBandImage;
import org.openimaj.image.SingleBandImage;
import org.openimaj.image.colour.ColourSpace;
import org.openimaj.image.pixel.Pixel;
import org.openimaj.image.renderer.MBFImageRenderer;
import org.openimaj.image.renderer.RenderHints;

public class MBFImage
extends MultiBandImage<Float, MBFImage, FImage> {
    private static final long serialVersionUID = 1L;

    public MBFImage() {
        super(ColourSpace.RGB);
    }

    public MBFImage(ColourSpace colourSpace, FImage ... images) {
        super(colourSpace, (SingleBandImage[])images);
    }

    public MBFImage(FImage ... images) {
        super(images.length == 3 ? ColourSpace.RGB : (images.length == 4 ? ColourSpace.RGBA : ColourSpace.CUSTOM), (SingleBandImage[])images);
    }

    public MBFImage(int width, int height) {
        this(width, height, ColourSpace.RGB);
    }

    public MBFImage(int width, int height, ColourSpace colourSpace) {
        this.colourSpace = colourSpace;
        for (int i = 0; i < colourSpace.getNumBands(); ++i) {
            this.bands.add(new FImage(width, height));
        }
    }

    public MBFImage(int width, int height, int nbands) {
        if (nbands == 3) {
            this.colourSpace = ColourSpace.RGB;
        } else if (nbands == 4) {
            this.colourSpace = ColourSpace.RGBA;
        }
        for (int i = 0; i < nbands; ++i) {
            this.bands.add(new FImage(width, height));
        }
    }

    public MBFImage(int[] data, int width, int height) {
        this(data, width, height, false);
    }

    public MBFImage(int[] data, int width, int height, boolean alpha) {
        this(width, height, alpha ? 4 : 3);
        this.internalAssign(data, width, height);
    }

    public MBFImage(double[] ds, int width, int height, int nbands, boolean interlaced) {
        if (interlaced) {
            for (int i = 0; i < nbands; ++i) {
                this.bands.add(new FImage(width, height));
            }
            int c = 0;
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int i = 0;
                    while (i < nbands) {
                        ((FImage)this.bands.get((int)i)).pixels[y][x] = (float)ds[c];
                        ++i;
                        ++c;
                    }
                }
            }
        } else {
            for (int i = 0; i < nbands; ++i) {
                this.bands.add(new FImage(ds, width, height, i * width * height));
            }
        }
    }

    @Override
    public FImage flattenMax() {
        int width = this.getWidth();
        int height = this.getHeight();
        FImage out = new FImage(width, height);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                float max = ((FImage)this.bands.get((int)0)).pixels[y][x];
                for (int i = 1; i < this.numBands(); ++i) {
                    if (!(max < ((FImage)this.bands.get((int)i)).pixels[y][x])) continue;
                    max = ((FImage)this.bands.get((int)i)).pixels[y][x];
                }
                out.pixels[y][x] = max;
            }
        }
        return out;
    }

    @Override
    public FImage flatten() {
        int x;
        int y;
        float[][] bnd;
        int width = this.getWidth();
        int height = this.getHeight();
        FImage out = new FImage(width, height);
        float[][] outp = out.pixels;
        int nb = this.numBands();
        for (int i = 1; i < nb; ++i) {
            bnd = ((FImage)this.bands.get((int)i)).pixels;
            for (y = 0; y < height; ++y) {
                for (x = 0; x < width; ++x) {
                    float[] fArray = outp[y];
                    int n = x;
                    fArray[n] = fArray[n] + bnd[y][x];
                }
            }
        }
        float norm = 1.0f / (float)nb;
        bnd = ((FImage)this.bands.get((int)0)).pixels;
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                outp[y][x] = (outp[y][x] + bnd[y][x]) * norm;
            }
        }
        return out;
    }

    @Override
    public Float[] getPixel(int x, int y) {
        Float[] pixels = new Float[this.bands.size()];
        for (int i = 0; i < this.bands.size(); ++i) {
            pixels[i] = ((FImage)this.bands.get(i)).getPixel(x, y);
        }
        return pixels;
    }

    @Override
    public Comparator<? super Float[]> getPixelComparator() {
        return new Comparator<Float[]>(){

            @Override
            public int compare(Float[] o1, Float[] o2) {
                int sumDiff = 0;
                boolean anyDiff = false;
                for (int i = 0; i < o1.length; ++i) {
                    anyDiff = (sumDiff = (int)((float)sumDiff + (o1[i].floatValue() - o2[i].floatValue()))) != 0 || anyDiff;
                }
                if (anyDiff) {
                    if (sumDiff > 0) {
                        return 1;
                    }
                    return -1;
                }
                return 0;
            }
        };
    }

    @Override
    public Float[] getPixelInterp(double x, double y) {
        Float[] result = new Float[this.bands.size()];
        for (int i = 0; i < this.bands.size(); ++i) {
            result[i] = ((FImage)this.bands.get(i)).getPixelInterp(x, y);
        }
        return result;
    }

    @Override
    public Float[] getPixelInterp(double x, double y, Float[] b) {
        Float[] result = new Float[this.bands.size()];
        for (int i = 0; i < this.bands.size(); ++i) {
            result[i] = ((FImage)this.bands.get(i)).getPixelInterp(x, y, b[i]);
        }
        return result;
    }

    public MBFImage internalAssign(byte[] bytes, int width, int height) {
        if (this.getWidth() != width || this.getHeight() != height) {
            this.internalAssign(this.newInstance(width, height));
        }
        float[][] br = ((FImage)this.bands.get((int)0)).pixels;
        float[][] bg = ((FImage)this.bands.get((int)1)).pixels;
        float[][] bb = ((FImage)this.bands.get((int)2)).pixels;
        int i = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int blue = bytes[i++] & 0xFF;
                int green = bytes[i++] & 0xFF;
                int red = bytes[i++] & 0xFF;
                br[y][x] = ImageUtilities.BYTE_TO_FLOAT_LUT[red];
                bg[y][x] = ImageUtilities.BYTE_TO_FLOAT_LUT[green];
                bb[y][x] = ImageUtilities.BYTE_TO_FLOAT_LUT[blue];
            }
        }
        return this;
    }

    @Override
    public MBFImage internalAssign(int[] data, int width, int height) {
        if (this.getWidth() != width || this.getHeight() != height) {
            this.internalAssign(this.newInstance(width, height));
        }
        float[][] br = ((FImage)this.bands.get((int)0)).pixels;
        float[][] bg = ((FImage)this.bands.get((int)1)).pixels;
        float[][] bb = ((FImage)this.bands.get((int)2)).pixels;
        float[][] ba = null;
        if (this.colourSpace == ColourSpace.RGBA) {
            ba = ((FImage)this.bands.get((int)3)).pixels;
        }
        int i = 0;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                int rgb = data[i];
                int alpha = rgb >> 24 & 0xFF;
                int red = rgb >> 16 & 0xFF;
                int green = rgb >> 8 & 0xFF;
                int blue = rgb & 0xFF;
                br[y][x] = ImageUtilities.BYTE_TO_FLOAT_LUT[red];
                bg[y][x] = ImageUtilities.BYTE_TO_FLOAT_LUT[green];
                bb[y][x] = ImageUtilities.BYTE_TO_FLOAT_LUT[blue];
                if (ba != null) {
                    ba[y][x] = ImageUtilities.BYTE_TO_FLOAT_LUT[alpha];
                }
                ++x;
                ++i;
            }
        }
        return this;
    }

    @Override
    protected Float intToT(int n) {
        return Float.valueOf(n);
    }

    @Override
    public FImage newBandInstance(int width, int height) {
        return new FImage(width, height);
    }

    @Override
    public MBFImage newInstance() {
        return new MBFImage();
    }

    @Override
    public MBFImage newInstance(int width, int height) {
        MBFImage ret = new MBFImage(width, height, this.bands.size());
        ret.colourSpace = this.colourSpace;
        return ret;
    }

    public MBFImageRenderer createRenderer() {
        return new MBFImageRenderer(this);
    }

    public MBFImageRenderer createRenderer(RenderHints options) {
        return new MBFImageRenderer(this, options);
    }

    public float[] getPixelNative(Pixel p) {
        return this.getPixelNative(p.x, p.y);
    }

    public float[] getPixelNative(int x, int y) {
        float[] pixels = new float[this.bands.size()];
        for (int i = 0; i < this.bands.size(); ++i) {
            pixels[i] = ((FImage)this.bands.get(i)).getPixelNative(x, y);
        }
        return pixels;
    }

    public float[][] getPixelVectorNative(float[][] f) {
        for (int y = 0; y < this.getHeight(); ++y) {
            for (int x = 0; x < this.getWidth(); ++x) {
                f[x + y * this.getWidth()] = this.getPixelNative(x, y);
            }
        }
        return f;
    }

    public void setPixelNative(int x, int y, float[] val) {
        int np = this.bands.size();
        if (np == val.length) {
            for (int i = 0; i < np; ++i) {
                ((FImage)this.bands.get(i)).setPixel(x, y, Float.valueOf(val[i]));
            }
        } else {
            int offset = val.length - np;
            for (int i = 0; i < np; ++i) {
                if (i + offset < 0) continue;
                ((FImage)this.bands.get(i)).setPixel(x, y, Float.valueOf(val[i + offset]));
            }
        }
    }

    @Override
    public MBFImage overlayInplace(MBFImage image, int x, int y) {
        FImage alpha = (FImage)image.getBand(image.numBands() - 1);
        for (int i = 0; i < this.numBands(); ++i) {
            ((FImage)this.bands.get(i)).overlayInplace((FImage)image.bands.get(i), alpha, x, y);
        }
        return this;
    }

    public static MBFImage randomImage(int width, int height) {
        MBFImage img = new MBFImage();
        img.colourSpace = ColourSpace.RGB;
        for (int i = 0; i < 3; ++i) {
            img.bands.add(FImage.randomImage(width, height));
        }
        return img;
    }

    public static MBFImage createRGB(FImage image) {
        return new MBFImage(image.clone(), image.clone(), image.clone());
    }

    @Override
    public MBFImage fill(Float[] colour) {
        return (MBFImage)super.fill(this.colourSpace.sanitise(colour));
    }

    @Override
    public void setPixel(int x, int y, Float[] val) {
        if (this.colourSpace == ColourSpace.RGBA && this.numBands() >= 4 && val.length >= 4 && x >= 0 && x < this.getWidth() && y >= 0 && y < this.getHeight()) {
            float[] p = ImageUtilities.alphaCompositePixel(this.getPixel(x, y), val);
            ((FImage)this.getBand((int)0)).pixels[y][x] = p[0];
            ((FImage)this.getBand((int)1)).pixels[y][x] = p[1];
            ((FImage)this.getBand((int)2)).pixels[y][x] = p[2];
            if (this.numBands() >= 4) {
                ((FImage)this.getBand((int)3)).pixels[y][x] = p[3];
            }
        } else {
            super.setPixel(x, y, val);
        }
    }

    protected Float[] createPixelArray(int n) {
        return new Float[n];
    }

    public double[] getDoublePixelVector() {
        int height = this.getHeight();
        int width = this.getWidth();
        double[] f = new double[width * height * this.numBands()];
        for (int i = 0; i < this.bands.size(); ++i) {
            float[][] pixels = ((FImage)this.bands.get((int)i)).pixels;
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    f[x + y * width + i * height * width] = pixels[y][x];
                }
            }
        }
        return f;
    }
}

