/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image;

import org.openimaj.image.Image;
import org.openimaj.image.pixel.Pixel;
import org.openimaj.image.renderer.ImageRenderer;

public class Plotter<Q, I extends Image<Q, I>> {
    protected Pixel penPosition = new Pixel(0, 0);
    protected Q penColour;
    protected int penThickness;
    protected I image;
    protected ImageRenderer<Q, I> renderer;

    public Plotter(I image) {
        this(image, ((Image)image).getPixel(0, 0), 1);
    }

    public Plotter(I image, Q colour) {
        this(image, colour, 1);
    }

    public Plotter(I image, Q colour, int thickness) {
        this.image = image;
        this.renderer = ((Image)image).createRenderer();
        this.penColour = colour;
        this.penThickness = thickness;
    }

    public void moveTo(Pixel p) {
        this.moveTo(p.x, p.y);
    }

    public void moveTo(int x, int y) {
        this.penPosition.x = x;
        this.penPosition.y = y;
    }

    public void lineTo(Pixel p) {
        this.lineTo(p.x, p.y);
    }

    public void lineTo(int x, int y) {
        this.renderer.drawLine(this.penPosition.x, this.penPosition.y, x, y, this.penThickness, this.penColour);
        this.moveTo(x, y);
    }

    public Pixel getPenPosition() {
        return this.penPosition;
    }

    public void setPenPosition(Pixel penPosition) {
        this.penPosition = penPosition;
    }

    public Q getPenColour() {
        return this.penColour;
    }

    public void setPenColour(Q penColour) {
        this.penColour = penColour;
    }

    public int getPenThickness() {
        return this.penThickness;
    }

    public void setPenThickness(int penThickness) {
        this.penThickness = penThickness;
    }

    public I getImage() {
        return this.image;
    }

    public void setImage(I image) {
        this.image = image;
        this.renderer = ((Image)image).createRenderer();
    }
}

