/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.dataset;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.billylieurance.azuresearch.AbstractAzureSearchQuery;
import net.billylieurance.azuresearch.AzureSearchImageQuery;
import net.billylieurance.azuresearch.AzureSearchImageResult;
import org.openimaj.data.dataset.ReadableListDataset;
import org.openimaj.data.identity.Identifiable;
import org.openimaj.image.Image;
import org.openimaj.io.HttpUtils;
import org.openimaj.io.InputStreamObjectReader;
import org.openimaj.util.api.auth.common.BingAPIToken;

public class BingImageDataset<IMAGE extends Image<?, IMAGE>>
extends ReadableListDataset<IMAGE, InputStream>
implements Identifiable {
    List<AzureSearchImageResult> images;
    AzureSearchImageQuery query;

    protected BingImageDataset(InputStreamObjectReader<IMAGE> reader, List<AzureSearchImageResult> results, AzureSearchImageQuery query) {
        super(reader);
        this.images = results;
        this.query = query;
    }

    public IMAGE getInstance(int index) {
        return this.read(this.getImage(index));
    }

    private IMAGE read(AzureSearchImageResult next) {
        Image image;
        if (next == null) {
            return null;
        }
        InputStream stream = null;
        try {
            String imageURL = next.getMediaUrl();
            stream = HttpUtils.readURL((URL)new URL(imageURL));
            image = (Image)this.reader.read((Object)stream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {}
        }
        return (IMAGE)image;
    }

    public int numInstances() {
        return this.images.size();
    }

    public List<AzureSearchImageResult> getImages() {
        return this.images;
    }

    public AzureSearchImageResult getImage(int index) {
        return this.images.get(index);
    }

    private static List<AzureSearchImageResult> performSinglePageQuery(AzureSearchImageQuery query) {
        query.setFormat(AbstractAzureSearchQuery.AZURESEARCH_FORMAT.XML);
        query.doQuery();
        return query.getQueryResult().getASRs();
    }

    private static List<AzureSearchImageResult> performQuery(AzureSearchImageQuery query, int number) {
        List<AzureSearchImageResult> res;
        if (number <= 0) {
            number = 1000;
        }
        query.setPage(0);
        query.setPerPage(Integer.valueOf(50));
        query.setFormat(AbstractAzureSearchQuery.AZURESEARCH_FORMAT.XML);
        ArrayList<AzureSearchImageResult> images = new ArrayList<AzureSearchImageResult>();
        for (int i = 0; i < 20 && (res = BingImageDataset.performSinglePageQuery(query)) != null && res.size() != 0; ++i) {
            images.addAll(res);
            if (images.size() >= number) break;
        }
        if (images.size() <= number) {
            return images;
        }
        return images.subList(0, number);
    }

    public static <IMAGE extends Image<?, IMAGE>> BingImageDataset<IMAGE> create(InputStreamObjectReader<IMAGE> reader, AzureSearchImageQuery query, int number) {
        return new BingImageDataset<IMAGE>(reader, BingImageDataset.performQuery(query, number), query);
    }

    public static <IMAGE extends Image<?, IMAGE>> BingImageDataset<IMAGE> create(InputStreamObjectReader<IMAGE> reader, BingAPIToken token, AzureSearchImageQuery query, int number) {
        query.setAppid(token.accountKey);
        return new BingImageDataset<IMAGE>(reader, BingImageDataset.performQuery(query, number), query);
    }

    public static <IMAGE extends Image<?, IMAGE>> BingImageDataset<IMAGE> create(InputStreamObjectReader<IMAGE> reader, BingAPIToken token, String query, String imageFilters, int number) {
        AzureSearchImageQuery aq = new AzureSearchImageQuery();
        aq.setAppid(token.accountKey);
        aq.setQuery(query);
        if (imageFilters != null) {
            aq.setImageFilters(imageFilters);
        }
        return new BingImageDataset<IMAGE>(reader, BingImageDataset.performQuery(aq, number), aq);
    }

    public static <IMAGE extends Image<?, IMAGE>> BingImageDataset<IMAGE> create(InputStreamObjectReader<IMAGE> reader, BingAPIToken token, String query, int number) {
        AzureSearchImageQuery aq = new AzureSearchImageQuery();
        aq.setAppid(token.accountKey);
        aq.setQuery(query);
        return new BingImageDataset<IMAGE>(reader, BingImageDataset.performQuery(aq, number), aq);
    }

    public String getID() {
        return this.query.getQuery();
    }
}

