/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.dataset;

import com.flickr4java.flickr.Flickr;
import com.flickr4java.flickr.REST;
import com.flickr4java.flickr.Transport;
import com.flickr4java.flickr.collections.CollectionsInterface;
import com.flickr4java.flickr.galleries.Gallery;
import com.flickr4java.flickr.photos.Extras;
import com.flickr4java.flickr.photos.Photo;
import com.flickr4java.flickr.photos.PhotoList;
import com.flickr4java.flickr.photos.SearchParameters;
import com.flickr4java.flickr.photosets.PhotosetsInterface;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import org.openimaj.data.dataset.ReadableListDataset;
import org.openimaj.image.Image;
import org.openimaj.io.HttpUtils;
import org.openimaj.io.InputStreamObjectReader;
import org.openimaj.util.api.auth.common.FlickrAPIToken;

public class FlickrImageDataset<IMAGE extends Image<?, IMAGE>>
extends ReadableListDataset<IMAGE, InputStream> {
    private static final Pattern GALLERY_URL_PATTERN = Pattern.compile(".*/photos/.*/galleries/[0-9]*(/|$)");
    private static final Pattern PHOTOSET_URL_PATTERN = Pattern.compile(".*/photos/.*/sets/([0-9]*)(/|$)");
    private static final Pattern COLLECTION_URL_PATTERN = Pattern.compile(".*/photos/(.*)/collections/([0-9]*)(/|$)");
    protected List<Photo> photos;
    protected Size targetSize = Size.Medium;

    protected FlickrImageDataset(InputStreamObjectReader<IMAGE> reader, List<Photo> photos) {
        super(reader);
        this.photos = photos;
    }

    public void setImageSize(Size size) {
        this.targetSize = size;
    }

    public Size getImageSize() {
        return this.targetSize;
    }

    public List<Photo> getPhotos() {
        return this.photos;
    }

    public Photo getPhoto(int index) {
        return this.photos.get(index);
    }

    public IMAGE getInstance(int index) {
        return this.read(this.photos.get(index));
    }

    public int numInstances() {
        return this.photos.size();
    }

    public String getID(int index) {
        return this.targetSize.getURL(this.photos.get(index)).toString();
    }

    private IMAGE read(Photo next) {
        Image image;
        if (next == null) {
            return null;
        }
        InputStream stream = null;
        try {
            stream = HttpUtils.readURL((URL)this.targetSize.getURL(next));
            image = (Image)this.reader.read((Object)stream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {}
        }
        return (IMAGE)image;
    }

    public Iterator<IMAGE> iterator() {
        return new Iterator<IMAGE>(){
            Iterator<Photo> internal;
            {
                this.internal = FlickrImageDataset.this.photos.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.internal.hasNext();
            }

            @Override
            public IMAGE next() {
                return FlickrImageDataset.this.read(this.internal.next());
            }

            @Override
            public void remove() {
                this.internal.remove();
            }
        };
    }

    public String toString() {
        return String.format("%s(%d images)", ((Object)((Object)this)).getClass().getName(), this.photos.size());
    }

    public static <IMAGE extends Image<?, IMAGE>> FlickrImageDataset<IMAGE> create(InputStreamObjectReader<IMAGE> reader, FlickrAPIToken token, URL url) throws Exception {
        return FlickrImageDataset.create(reader, token, url, 0);
    }

    public static <IMAGE extends Image<?, IMAGE>> FlickrImageDataset<IMAGE> create(InputStreamObjectReader<IMAGE> reader, FlickrAPIToken token, String searchTerms) throws Exception {
        return FlickrImageDataset.create(reader, token, searchTerms, 0);
    }

    public static <IMAGE extends Image<?, IMAGE>> FlickrImageDataset<IMAGE> create(InputStreamObjectReader<IMAGE> reader, FlickrAPIToken token, String searchTerms, int number) throws Exception {
        SearchParameters params = new SearchParameters();
        params.setText(searchTerms);
        return FlickrImageDataset.createFromSearch(reader, token, params, number);
    }

    public static <IMAGE extends Image<?, IMAGE>> FlickrImageDataset<IMAGE> create(InputStreamObjectReader<IMAGE> reader, FlickrAPIToken token, URL url, int number) throws Exception {
        String urlString = url.toString();
        if (GALLERY_URL_PATTERN.matcher(urlString).matches()) {
            return FlickrImageDataset.fromGallery(reader, token, urlString, number);
        }
        if (PHOTOSET_URL_PATTERN.matcher(urlString).matches()) {
            return FlickrImageDataset.fromPhotoset(reader, token, urlString, number);
        }
        if (COLLECTION_URL_PATTERN.matcher(urlString).matches()) {
            return FlickrImageDataset.fromCollection(reader, token, urlString, number);
        }
        throw new IllegalArgumentException("Unknown URL type " + urlString);
    }

    private static <IMAGE extends Image<?, IMAGE>> FlickrImageDataset<IMAGE> fromGallery(InputStreamObjectReader<IMAGE> reader, FlickrAPIToken token, String urlString, int number) throws Exception {
        Flickr flickr = FlickrImageDataset.makeFlickr(token);
        Gallery gallery = flickr.getUrlsInterface().lookupGallery(urlString);
        return FlickrImageDataset.createFromGallery(reader, token, gallery, number);
    }

    private static <IMAGE extends Image<?, IMAGE>> FlickrImageDataset<IMAGE> fromPhotoset(InputStreamObjectReader<IMAGE> reader, FlickrAPIToken token, String urlString, int number) throws Exception {
        Matcher matcher = PHOTOSET_URL_PATTERN.matcher(urlString);
        matcher.find();
        String setId = matcher.group(1);
        return FlickrImageDataset.createFromPhotoset(reader, token, setId, number);
    }

    private static <IMAGE extends Image<?, IMAGE>> FlickrImageDataset<IMAGE> fromCollection(InputStreamObjectReader<IMAGE> reader, FlickrAPIToken token, String urlString, int number) throws Exception {
        Matcher matcher = COLLECTION_URL_PATTERN.matcher(urlString);
        matcher.find();
        String userId = matcher.group(1);
        String collectionsId = matcher.group(2);
        return FlickrImageDataset.createFromCollection(reader, token, collectionsId, userId, number);
    }

    public static <IMAGE extends Image<?, IMAGE>> FlickrImageDataset<IMAGE> createFromGallery(InputStreamObjectReader<IMAGE> reader, FlickrAPIToken token, Gallery gallery) throws Exception {
        return FlickrImageDataset.createFromGallery(reader, token, gallery.getId(), 0);
    }

    public static <IMAGE extends Image<?, IMAGE>> FlickrImageDataset<IMAGE> createFromGallery(InputStreamObjectReader<IMAGE> reader, FlickrAPIToken token, Gallery gallery, int number) throws Exception {
        return FlickrImageDataset.createFromGallery(reader, token, gallery.getId(), number);
    }

    public static <IMAGE extends Image<?, IMAGE>> FlickrImageDataset<IMAGE> createFromGallery(InputStreamObjectReader<IMAGE> reader, FlickrAPIToken token, String galleryId) throws Exception {
        return FlickrImageDataset.createFromGallery(reader, token, galleryId, 0);
    }

    public static <IMAGE extends Image<?, IMAGE>> FlickrImageDataset<IMAGE> createFromGallery(InputStreamObjectReader<IMAGE> reader, FlickrAPIToken token, String galleryId, int number) throws Exception {
        Flickr flickr = FlickrImageDataset.makeFlickr(token);
        List<Object> photos = new ArrayList<Photo>();
        PhotoList first = flickr.getGalleriesInterface().getPhotos(galleryId, Extras.ALL_EXTRAS, 250, 0);
        photos.addAll((Collection<Photo>)first);
        if (number > 0) {
            number = Math.min(number, first.getTotal());
        }
        int page = 1;
        int n = photos.size();
        while (n < number) {
            PhotoList result = flickr.getGalleriesInterface().getPhotos(galleryId, Extras.ALL_EXTRAS, 250, page);
            photos.addAll((Collection<Photo>)result);
            n += result.size();
            ++page;
        }
        if (number > 0 && number < photos.size()) {
            photos = photos.subList(0, number);
        }
        return new FlickrImageDataset<IMAGE>(reader, photos);
    }

    public static <IMAGE extends Image<?, IMAGE>> FlickrImageDataset<IMAGE> createFromPhotoset(InputStreamObjectReader<IMAGE> reader, FlickrAPIToken token, String setId) throws Exception {
        return FlickrImageDataset.createFromPhotoset(reader, token, setId, 0);
    }

    public static <IMAGE extends Image<?, IMAGE>> FlickrImageDataset<IMAGE> createFromPhotoset(InputStreamObjectReader<IMAGE> reader, FlickrAPIToken token, String setId, int number) throws Exception {
        Flickr flickr = FlickrImageDataset.makeFlickr(token);
        PhotosetsInterface setsInterface = flickr.getPhotosetsInterface();
        List<Object> photos = new ArrayList<Photo>();
        PhotoList first = setsInterface.getPhotos(setId, Extras.ALL_EXTRAS, 0, 250, 0);
        photos.addAll((Collection<Photo>)first);
        if (number > 0) {
            number = Math.min(number, first.getTotal());
        }
        int page = 1;
        int n = photos.size();
        while (n < number) {
            PhotoList result = setsInterface.getPhotos(setId, Extras.ALL_EXTRAS, 0, 250, page);
            photos.addAll((Collection<Photo>)result);
            n += result.size();
            ++page;
        }
        if (number > 0 && number < photos.size()) {
            photos = photos.subList(0, number);
        }
        return new FlickrImageDataset<IMAGE>(reader, photos);
    }

    public static <IMAGE extends Image<?, IMAGE>> FlickrImageDataset<IMAGE> createFromCollection(InputStreamObjectReader<IMAGE> reader, FlickrAPIToken token, String collectionsId, String userId) throws Exception {
        return FlickrImageDataset.createFromCollection(reader, token, collectionsId, userId, 0);
    }

    public static <IMAGE extends Image<?, IMAGE>> FlickrImageDataset<IMAGE> createFromCollection(InputStreamObjectReader<IMAGE> reader, FlickrAPIToken token, String collectionId, String userId, int number) throws Exception {
        Flickr flickr = FlickrImageDataset.makeFlickr(token);
        List<Object> photos = new ArrayList<Photo>();
        CollectionsInterface collectionsInterface = flickr.getCollectionsInterface();
        List collections = collectionsInterface.getTree(collectionId, userId);
        for (com.flickr4java.flickr.collections.Collection collection : collections) {
            photos.addAll(collection.getPhotos());
        }
        if (number > 0 && number < photos.size()) {
            photos = photos.subList(0, number);
        }
        return new FlickrImageDataset<IMAGE>(reader, photos);
    }

    public static <IMAGE extends Image<?, IMAGE>> FlickrImageDataset<IMAGE> createFromSearch(InputStreamObjectReader<IMAGE> reader, FlickrAPIToken token, SearchParameters params) throws Exception {
        return FlickrImageDataset.createFromSearch(reader, token, params, 0);
    }

    public static <IMAGE extends Image<?, IMAGE>> FlickrImageDataset<IMAGE> createFromSearch(InputStreamObjectReader<IMAGE> reader, FlickrAPIToken token, SearchParameters params, int number) throws Exception {
        Flickr flickr = FlickrImageDataset.makeFlickr(token);
        params.setExtras(Extras.ALL_EXTRAS);
        List<Object> photos = new ArrayList<Photo>();
        PhotoList first = flickr.getPhotosInterface().search(params, 250, 0);
        photos.addAll((Collection<Photo>)first);
        if (number > 0) {
            number = Math.min(number, first.getTotal());
        }
        int page = 1;
        int n = photos.size();
        while (n < number) {
            PhotoList result = flickr.getPhotosInterface().search(params, 250, page);
            photos.addAll((Collection<Photo>)result);
            n += result.size();
            ++page;
        }
        if (number > 0 && number < photos.size()) {
            photos = photos.subList(0, number);
        }
        return new FlickrImageDataset<IMAGE>(reader, photos);
    }

    private static Flickr makeFlickr(FlickrAPIToken token) throws ParserConfigurationException {
        return new Flickr(token.apikey, token.secret, (Transport)new REST());
    }

    public static enum Size {
        Original{

            @Override
            protected URL getURL(Photo photo) {
                try {
                    return new URL(photo.getOriginalUrl());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        ,
        Large{

            @Override
            protected URL getURL(Photo photo) {
                try {
                    return new URL(photo.getLargeUrl());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        ,
        Medium{

            @Override
            protected URL getURL(Photo photo) {
                try {
                    return new URL(photo.getMediumUrl());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        ,
        Small{

            @Override
            protected URL getURL(Photo photo) {
                try {
                    return new URL(photo.getSmallUrl());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        ,
        Thumbnail{

            @Override
            protected URL getURL(Photo photo) {
                try {
                    return new URL(photo.getThumbnailUrl());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        ,
        Square{

            @Override
            protected URL getURL(Photo photo) {
                try {
                    return new URL(photo.getSmallSquareUrl());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };


        protected abstract URL getURL(Photo var1);
    }
}

