/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processor.connectedcomponent.render;

import java.util.EnumMap;
import java.util.EnumSet;
import org.openimaj.image.MBFImage;
import org.openimaj.image.pixel.ConnectedComponent;
import org.openimaj.image.processor.connectedcomponent.ConnectedComponentProcessor;
import org.openimaj.image.processor.connectedcomponent.render.AxisRenderer;
import org.openimaj.image.processor.connectedcomponent.render.BlobRenderer;
import org.openimaj.image.processor.connectedcomponent.render.BorderRenderer;
import org.openimaj.image.processor.connectedcomponent.render.CentroidRenderer;
import org.openimaj.image.processor.connectedcomponent.render.ConfigurableRenderOptions;
import org.openimaj.math.geometry.shape.Polygon;

public class ConfigurableRendererRGB
implements ConnectedComponentProcessor {
    protected MBFImage image;
    protected EnumSet<ConfigurableRenderOptions> options;
    EnumMap<ConfigurableRenderOptions, Float[]> colours = new EnumMap(ConfigurableRenderOptions.class);

    protected ConfigurableRendererRGB(EnumSet<ConfigurableRenderOptions> options) {
        this.options = options;
        this.colours.put(ConfigurableRenderOptions.AXIS, new Float[]{Float.valueOf(0.8f), Float.valueOf(0.0f), Float.valueOf(0.0f)});
        this.colours.put(ConfigurableRenderOptions.BLOB, new Float[]{Float.valueOf(0.5f), Float.valueOf(0.5f), Float.valueOf(0.5f)});
        this.colours.put(ConfigurableRenderOptions.BORDER, new Float[]{Float.valueOf(0.7f), Float.valueOf(0.0f), Float.valueOf(0.0f)});
        this.colours.put(ConfigurableRenderOptions.CENTROID, new Float[]{Float.valueOf(0.7f), Float.valueOf(0.0f), Float.valueOf(0.0f)});
        this.colours.put(ConfigurableRenderOptions.CH_AXIS, new Float[]{Float.valueOf(0.9f), Float.valueOf(0.0f), Float.valueOf(0.0f)});
        this.colours.put(ConfigurableRenderOptions.CH_BLOB, new Float[]{Float.valueOf(0.2f), Float.valueOf(0.2f), Float.valueOf(0.2f)});
        this.colours.put(ConfigurableRenderOptions.CH_BORDER, new Float[]{Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)});
        this.colours.put(ConfigurableRenderOptions.CH_CENTROID, new Float[]{Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)});
    }

    public ConfigurableRendererRGB(MBFImage image, EnumSet<ConfigurableRenderOptions> options) {
        this(options);
        this.image = image;
    }

    public ConfigurableRendererRGB(int rows, int cols, EnumSet<ConfigurableRenderOptions> options) {
        this(options);
        this.image = new MBFImage(cols, rows, 3);
    }

    public MBFImage getImage() {
        return this.image;
    }

    @Override
    public void process(ConnectedComponent cc) {
        Polygon ch = cc.calculateConvexHull();
        ConnectedComponent chcc = new ConnectedComponent(ch);
        if (this.options.contains((Object)ConfigurableRenderOptions.CH_BLOB)) {
            chcc.process(new BlobRenderer<Float[]>(this.image, this.colours.get((Object)ConfigurableRenderOptions.CH_BLOB)));
        }
        if (this.options.contains((Object)ConfigurableRenderOptions.BLOB)) {
            cc.process(new BlobRenderer<Float[]>(this.image, this.colours.get((Object)ConfigurableRenderOptions.BLOB)));
        }
        if (this.options.contains((Object)ConfigurableRenderOptions.CH_BORDER)) {
            this.image.createRenderer().drawPolygon(ch, this.colours.get((Object)ConfigurableRenderOptions.CH_BORDER));
        }
        if (this.options.contains((Object)ConfigurableRenderOptions.BORDER)) {
            cc.process(new BorderRenderer<Float[]>(this.image, this.colours.get((Object)ConfigurableRenderOptions.BLOB), ConnectedComponent.ConnectMode.CONNECT_8));
        }
        if (this.options.contains((Object)ConfigurableRenderOptions.CH_CENTROID)) {
            chcc.process(new CentroidRenderer<Float[]>(this.image, this.colours.get((Object)ConfigurableRenderOptions.CH_CENTROID)));
        }
        if (this.options.contains((Object)ConfigurableRenderOptions.CENTROID)) {
            cc.process(new CentroidRenderer<Float[]>(this.image, this.colours.get((Object)ConfigurableRenderOptions.CENTROID)));
        }
        if (this.options.contains((Object)ConfigurableRenderOptions.CH_AXIS)) {
            chcc.process(new AxisRenderer<Float[]>(this.image, this.colours.get((Object)ConfigurableRenderOptions.CH_AXIS)));
        }
        if (this.options.contains((Object)ConfigurableRenderOptions.AXIS)) {
            cc.process(new AxisRenderer<Float[]>(this.image, this.colours.get((Object)ConfigurableRenderOptions.AXIS)));
        }
    }

    public void setColour(ConfigurableRenderOptions r, Float[] colour) {
        this.colours.put(r, colour);
    }

    public Float[] getColour(ConfigurableRenderOptions r) {
        return this.colours.get((Object)r);
    }
}

