/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.face.detection;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.openimaj.image.FImage;
import org.openimaj.image.Image;
import org.openimaj.image.MBFImage;
import org.openimaj.image.processing.face.detection.DetectedFace;
import org.openimaj.image.processing.face.detection.FaceDetector;

public class IdentityFaceDetector<IMAGE extends Image<?, IMAGE>>
implements FaceDetector<DetectedFace, IMAGE> {
    public void readBinary(DataInput in) throws IOException {
    }

    public byte[] binaryHeader() {
        return IdentityFaceDetector.class.getName().getBytes();
    }

    public void writeBinary(DataOutput out) throws IOException {
    }

    @Override
    public List<DetectedFace> detectFaces(IMAGE image) {
        DetectedFace face = null;
        IMAGE oimage = image;
        if (oimage instanceof FImage) {
            face = new DetectedFace(image.getBounds(), (FImage)oimage, 1.0f);
        } else if (oimage instanceof MBFImage) {
            face = new DetectedFace(image.getBounds(), ((MBFImage)oimage).flatten(), 1.0f);
        } else {
            throw new RuntimeException("unsupported image type");
        }
        ArrayList<DetectedFace> faces = new ArrayList<DetectedFace>(1);
        faces.add(face);
        return faces;
    }

    public String toString() {
        return "Identity Face Detector";
    }
}

