/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.face.feature;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.openimaj.feature.DoubleFV;
import org.openimaj.feature.FeatureVectorProvider;
import org.openimaj.image.processing.face.detection.CLMDetectedFace;
import org.openimaj.image.processing.face.feature.FacialFeature;
import org.openimaj.image.processing.face.feature.FacialFeatureExtractor;

public class CLMShapeFeature
implements FacialFeature,
FeatureVectorProvider<DoubleFV> {
    private DoubleFV fv;

    protected CLMShapeFeature() {
        this(null);
    }

    public CLMShapeFeature(DoubleFV fv) {
        this.fv = fv;
    }

    public void readBinary(DataInput in) throws IOException {
        this.fv = new DoubleFV();
        this.fv.readBinary(in);
    }

    public byte[] binaryHeader() {
        return this.getClass().getName().getBytes();
    }

    public void writeBinary(DataOutput out) throws IOException {
        this.fv.writeBinary(out);
    }

    public DoubleFV getFeatureVector() {
        return this.fv;
    }

    public static class Extractor
    implements FacialFeatureExtractor<CLMShapeFeature, CLMDetectedFace> {
        public CLMShapeFeature extractFeature(CLMDetectedFace face) {
            return new CLMShapeFeature(face.getShapeParameters());
        }

        public void readBinary(DataInput in) throws IOException {
        }

        public byte[] binaryHeader() {
            return this.getClass().getName().getBytes();
        }

        public void writeBinary(DataOutput out) throws IOException {
        }
    }
}

