/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.face.feature.ltp;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.image.FImage;
import org.openimaj.image.Image;
import org.openimaj.image.ImageUtilities;
import org.openimaj.image.analyser.ImageAnalyser;
import org.openimaj.image.analysis.algorithm.EuclideanDistanceTransform;
import org.openimaj.image.feature.dense.binarypattern.LocalTernaryPattern;
import org.openimaj.image.feature.dense.binarypattern.UniformBinaryPattern;
import org.openimaj.image.pixel.Pixel;
import org.openimaj.image.processing.algorithm.DifferenceOfGaussian;
import org.openimaj.image.processing.algorithm.GammaCorrection;
import org.openimaj.image.processing.algorithm.MaskedRobustContrastEqualisation;
import org.openimaj.image.processing.face.feature.FacialFeature;
import org.openimaj.image.processing.face.feature.ltp.LTPWeighting;
import org.openimaj.image.processor.ImageProcessor;
import org.openimaj.image.processor.PixelProcessor;
import org.openimaj.io.wrappers.ReadableListBinary;
import org.openimaj.io.wrappers.WriteableArrayBinary;
import org.openimaj.io.wrappers.WriteableListBinary;

@Reference(type=ReferenceType.Article, author={"Tan, Xiaoyang", "Triggs, Bill"}, title="Enhanced local texture feature sets for face recognition under difficult lighting conditions", year="2010", journal="Trans. Img. Proc.", pages={"1635", "1650"}, url="http://dx.doi.org/10.1109/TIP.2010.2042645", month="June", number="6", publisher="IEEE Press", volume="19")
public class AbstractLtpDtFeature
implements FacialFeature {
    public List<List<Pixel>> ltpPixels;
    private int width;
    private int height;
    private LTPWeighting weighting;
    private FImage[] cachedDistanceMaps;

    public AbstractLtpDtFeature(int width, int height, LTPWeighting weighting, List<List<Pixel>> ltpPixels) {
        this.width = width;
        this.height = height;
        this.weighting = weighting;
        this.ltpPixels = ltpPixels;
    }

    public FImage[] getDistanceMaps() {
        if (this.cachedDistanceMaps == null) {
            this.cachedDistanceMaps = this.extractDistanceTransforms(this.constructSlices(this.ltpPixels, this.width, this.height), this.weighting);
        }
        return this.cachedDistanceMaps;
    }

    protected static FImage normaliseImage(FImage image, FImage mask) {
        if (mask == null) {
            return (FImage)((FImage)((FImage)image.process((PixelProcessor)new GammaCorrection())).processInplace((ImageProcessor)new DifferenceOfGaussian())).processInplace((ImageProcessor)new MaskedRobustContrastEqualisation());
        }
        return (FImage)((FImage)((FImage)((FImage)image.process((PixelProcessor)new GammaCorrection())).processInplace((ImageProcessor)new DifferenceOfGaussian())).processInplace((ImageProcessor)new MaskedRobustContrastEqualisation(mask))).multiply((Image)mask);
    }

    protected static List<List<Pixel>> extractLTPSlicePixels(FImage image) {
        LocalTernaryPattern ltp = new LocalTernaryPattern(2.0f, 8, 0.1f);
        image.analyseWith((ImageAnalyser)ltp);
        List positiveSlices = UniformBinaryPattern.extractPatternPixels((int[][])ltp.getPositivePattern(), (int)8);
        List negativeSlices = UniformBinaryPattern.extractPatternPixels((int[][])ltp.getNegativePattern(), (int)8);
        positiveSlices.addAll(negativeSlices);
        return positiveSlices;
    }

    protected FImage[] extractDistanceTransforms(FImage[] slices, LTPWeighting weighting) {
        FImage[] dist = new FImage[slices.length];
        int width = slices[0].width;
        int height = slices[0].height;
        int[][] indices = new int[height][width];
        for (int i = 0; i < slices.length; ++i) {
            if (slices[i] == null) continue;
            dist[i] = new FImage(width, height);
            EuclideanDistanceTransform.squaredEuclideanDistanceBinary((FImage)slices[i], (FImage)dist[i], (int[][])indices);
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    dist[i].pixels[y][x] = weighting.weightDistance((float)Math.sqrt(dist[i].pixels[y][x]));
                }
            }
        }
        return dist;
    }

    protected FImage[] constructSlices(List<List<Pixel>> ltpPixels, int width, int height) {
        FImage[] slices = new FImage[ltpPixels.size()];
        for (int i = 0; i < slices.length; ++i) {
            List<Pixel> pixels = ltpPixels.get(i);
            if (pixels == null) continue;
            slices[i] = new FImage(width, height);
            for (Pixel p : pixels) {
                slices[i].pixels[p.y][p.x] = 1.0f;
            }
        }
        return slices;
    }

    public void readBinary(DataInput in) throws IOException {
        new ReadableListBinary<List<Pixel>>(this.ltpPixels){

            protected List<Pixel> readValue(DataInput in) throws IOException {
                ArrayList<Pixel> pixels = new ArrayList<Pixel>();
                new ReadableListBinary<Pixel>(pixels){

                    protected Pixel readValue(DataInput in) throws IOException {
                        Pixel p = new Pixel();
                        p.readBinary(in);
                        return p;
                    }
                }.readBinary(in);
                return pixels;
            }
        }.readBinary(in);
        ArrayList images = new ArrayList();
        new ReadableListBinary<FImage>(images){

            protected FImage readValue(DataInput in) throws IOException {
                return ImageUtilities.readF((DataInput)in);
            }
        }.readBinary(in);
        this.cachedDistanceMaps = images.size() == 0 ? null : images.toArray(new FImage[images.size()]);
    }

    public byte[] binaryHeader() {
        return null;
    }

    public void writeBinary(DataOutput out) throws IOException {
        new WriteableListBinary<List<Pixel>>(this.ltpPixels){

            protected void writeValue(List<Pixel> v, DataOutput out) throws IOException {
                new WriteableListBinary<Pixel>(v){

                    protected void writeValue(Pixel v, DataOutput out) throws IOException {
                        v.writeBinary(out);
                    }
                }.writeBinary(out);
            }
        }.writeBinary(out);
        new WriteableArrayBinary<FImage>(this.cachedDistanceMaps){

            protected void writeValue(FImage v, DataOutput out) throws IOException {
                ImageUtilities.write((Image)v, (String)"png", (DataOutput)out);
            }
        }.writeBinary(out);
    }
}

