/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.knn.pq;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.data.DataSource;
import org.openimaj.io.IOUtils;
import org.openimaj.io.ReadWriteableBinary;
import org.openimaj.knn.DoubleNearestNeighbours;
import org.openimaj.knn.IncrementalNearestNeighbours;
import org.openimaj.knn.pq.DoubleProductQuantiser;
import org.openimaj.util.pair.IntDoublePair;
import org.openimaj.util.queue.BoundedPriorityQueue;

@Reference(type=ReferenceType.Article, author={"Jegou, Herve", "Douze, Matthijs", "Schmid, Cordelia"}, title="Product Quantization for Nearest Neighbor Search", year="2011", journal="IEEE Trans. Pattern Anal. Mach. Intell.", pages={"117", "", "128"}, url="http://dx.doi.org/10.1109/TPAMI.2010.57", month="January", number="1", publisher="IEEE Computer Society", volume="33", customData={"issn", "0162-8828", "numpages", "12", "doi", "10.1109/TPAMI.2010.57", "acmid", "1916695", "address", "Washington, DC, USA", "keywords", "High-dimensional indexing, High-dimensional indexing, image indexing, very large databases, approximate search., approximate search., image indexing, very large databases"})
public class IncrementalDoubleADCNearestNeighbours
extends DoubleNearestNeighbours
implements IncrementalNearestNeighbours<double[], double[], IntDoublePair>,
ReadWriteableBinary {
    protected DoubleProductQuantiser pq;
    protected int ndims;
    protected List<byte[]> data;

    protected IncrementalDoubleADCNearestNeighbours() {
    }

    public IncrementalDoubleADCNearestNeighbours(DoubleProductQuantiser pq, double[][] dataPoints) {
        this.pq = pq;
        this.ndims = dataPoints[0].length;
        this.data = new ArrayList<byte[]>(dataPoints.length);
        for (int i = 0; i < dataPoints.length; ++i) {
            this.data.add(pq.quantise(dataPoints[i]));
        }
    }

    public IncrementalDoubleADCNearestNeighbours(DoubleProductQuantiser pq, List<double[]> dataPoints) {
        this.pq = pq;
        this.ndims = dataPoints.get(0).length;
        int size = dataPoints.size();
        this.data = new ArrayList<byte[]>(size);
        for (int i = 0; i < size; ++i) {
            this.data.add(pq.quantise(dataPoints.get(i)));
        }
    }

    public IncrementalDoubleADCNearestNeighbours(DoubleProductQuantiser pq, DataSource<double[]> dataPoints) {
        this.pq = pq;
        this.ndims = ((double[])dataPoints.getData(0)).length;
        int size = dataPoints.size();
        this.data = new ArrayList<byte[]>(size);
        for (int i = 0; i < size; ++i) {
            this.data.add(pq.quantise((double[])dataPoints.getData(i)));
        }
    }

    public IncrementalDoubleADCNearestNeighbours(DoubleProductQuantiser pq, int ndims) {
        this.pq = pq;
        this.ndims = ndims;
        this.data = new ArrayList<byte[]>();
    }

    public IncrementalDoubleADCNearestNeighbours(DoubleProductQuantiser pq, int ndims, int nitems) {
        this.pq = pq;
        this.ndims = ndims;
        this.data = new ArrayList<byte[]>(nitems);
    }

    @Override
    public int[] addAll(List<double[]> d) {
        int[] indexes = new int[d.size()];
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = this.add(d.get(i));
        }
        return indexes;
    }

    @Override
    public int add(double[] o) {
        int ret = this.data.size();
        this.data.add(this.pq.quantise(o));
        return ret;
    }

    @Override
    public int numDimensions() {
        return this.ndims;
    }

    @Override
    public int size() {
        return this.data.size();
    }

    public void readBinary(DataInput in) throws IOException {
        this.pq = (DoubleProductQuantiser)IOUtils.read((DataInput)in);
        this.ndims = in.readInt();
        int size = in.readInt();
        int dim = this.pq.assigners.length;
        this.data = new ArrayList<byte[]>(size);
        for (int i = 0; i < size; ++i) {
            byte[] bytes = new byte[dim];
            in.readFully(bytes);
            this.data.add(bytes);
        }
    }

    public byte[] binaryHeader() {
        return "IDoubleADCNN".getBytes();
    }

    public void writeBinary(DataOutput out) throws IOException {
        IOUtils.write((Object)this.pq, (DataOutput)out);
        out.writeInt(this.ndims);
        int size = this.data.size();
        out.writeInt(size);
        for (int i = 0; i < size; ++i) {
            out.write(this.data.get(i));
        }
    }

    public void searchNN(double[][] qus, int[] indices, double[] distances) {
        int N = qus.length;
        BoundedPriorityQueue queue = new BoundedPriorityQueue(1, IntDoublePair.SECOND_ITEM_ASCENDING_COMPARATOR);
        ArrayList<IntDoublePair> list = new ArrayList<IntDoublePair>(2);
        list.add(new IntDoublePair());
        list.add(new IntDoublePair());
        for (int n = 0; n < N; ++n) {
            List<IntDoublePair> result = this.search(qus[n], (BoundedPriorityQueue<IntDoublePair>)queue, list);
            IntDoublePair p = result.get(0);
            indices[n] = p.first;
            distances[n] = p.second;
        }
    }

    public void searchKNN(double[][] qus, int K, int[][] indices, double[][] distances) {
        K = Math.min(K, this.data.size());
        int N = qus.length;
        BoundedPriorityQueue queue = new BoundedPriorityQueue(K, IntDoublePair.SECOND_ITEM_ASCENDING_COMPARATOR);
        ArrayList<IntDoublePair> list = new ArrayList<IntDoublePair>(K + 1);
        for (int i = 0; i < K + 1; ++i) {
            list.add(new IntDoublePair());
        }
        for (int n = 0; n < N; ++n) {
            List<IntDoublePair> result = this.search(qus[n], (BoundedPriorityQueue<IntDoublePair>)queue, list);
            for (int k = 0; k < K; ++k) {
                IntDoublePair p = result.get(k);
                indices[n][k] = p.first;
                distances[n][k] = p.second;
            }
        }
    }

    @Override
    public void searchNN(List<double[]> qus, int[] indices, double[] distances) {
        int N = qus.size();
        BoundedPriorityQueue queue = new BoundedPriorityQueue(1, IntDoublePair.SECOND_ITEM_ASCENDING_COMPARATOR);
        ArrayList<IntDoublePair> list = new ArrayList<IntDoublePair>(2);
        list.add(new IntDoublePair());
        list.add(new IntDoublePair());
        for (int n = 0; n < N; ++n) {
            List<IntDoublePair> result = this.search(qus.get(n), (BoundedPriorityQueue<IntDoublePair>)queue, list);
            IntDoublePair p = result.get(0);
            indices[n] = p.first;
            distances[n] = p.second;
        }
    }

    public void searchKNN(List<double[]> qus, int K, int[][] indices, double[][] distances) {
        K = Math.min(K, this.data.size());
        int N = qus.size();
        BoundedPriorityQueue queue = new BoundedPriorityQueue(K, IntDoublePair.SECOND_ITEM_ASCENDING_COMPARATOR);
        ArrayList<IntDoublePair> list = new ArrayList<IntDoublePair>(K + 1);
        for (int i = 0; i < K + 1; ++i) {
            list.add(new IntDoublePair());
        }
        for (int n = 0; n < N; ++n) {
            List<IntDoublePair> result = this.search(qus.get(n), (BoundedPriorityQueue<IntDoublePair>)queue, list);
            for (int k = 0; k < K; ++k) {
                IntDoublePair p = result.get(k);
                indices[n][k] = p.first;
                distances[n][k] = p.second;
            }
        }
    }

    @Override
    public List<IntDoublePair> searchKNN(double[] query, int K) {
        K = Math.min(K, this.data.size());
        BoundedPriorityQueue queue = new BoundedPriorityQueue(K, IntDoublePair.SECOND_ITEM_ASCENDING_COMPARATOR);
        ArrayList<IntDoublePair> list = new ArrayList<IntDoublePair>(K + 1);
        for (int i = 0; i < K + 1; ++i) {
            list.add(new IntDoublePair());
        }
        return this.search(query, (BoundedPriorityQueue<IntDoublePair>)queue, list);
    }

    @Override
    public IntDoublePair searchNN(double[] query) {
        BoundedPriorityQueue queue = new BoundedPriorityQueue(1, IntDoublePair.SECOND_ITEM_ASCENDING_COMPARATOR);
        ArrayList<IntDoublePair> list = new ArrayList<IntDoublePair>(2);
        list.add(new IntDoublePair());
        list.add(new IntDoublePair());
        return this.search(query, (BoundedPriorityQueue<IntDoublePair>)queue, list).get(0);
    }

    private List<IntDoublePair> search(double[] query, BoundedPriorityQueue<IntDoublePair> queue, List<IntDoublePair> results) {
        IntDoublePair wp = null;
        for (IntDoublePair p : results) {
            p.second = 3.4028234663852886E38;
            p.first = -1;
            wp = (IntDoublePair)queue.offerItem((Object)p);
        }
        this.computeDistances(query, queue, wp);
        return queue.toOrderedListDestructive();
    }

    protected void computeDistances(double[] fullQuery, BoundedPriorityQueue<IntDoublePair> queue, IntDoublePair wp) {
        double[][] distances = new double[this.pq.assigners.length][];
        int from = 0;
        for (int j = 0; j < this.pq.assigners.length; ++j) {
            DoubleNearestNeighbours nn = this.pq.assigners[j];
            int to = nn.numDimensions();
            int K = nn.size();
            double[][] qus = new double[][]{Arrays.copyOfRange(fullQuery, from, from + to)};
            int[][] idx = new int[1][K];
            double[][] dst = new double[1][K];
            nn.searchKNN((DATA[])qus, K, idx, (DISTANCES[])dst);
            distances[j] = new double[K];
            for (int k = 0; k < K; ++k) {
                distances[j][idx[0][k]] = dst[0][k];
            }
            from += to;
        }
        int size = this.data.size();
        for (int i = 0; i < size; ++i) {
            wp.first = i;
            wp.second = 0.0;
            for (int j = 0; j < this.pq.assigners.length; ++j) {
                int centroid = this.data.get(i)[j] + 128;
                wp.second += distances[j][centroid];
            }
            wp = (IntDoublePair)queue.offerItem((Object)wp);
        }
    }
}

