/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.knn.pq;

import java.util.Arrays;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.knn.ShortNearestNeighbours;

@Reference(type=ReferenceType.Article, author={"Jegou, Herve", "Douze, Matthijs", "Schmid, Cordelia"}, title="Product Quantization for Nearest Neighbor Search", year="2011", journal="IEEE Trans. Pattern Anal. Mach. Intell.", pages={"117", "", "128"}, url="http://dx.doi.org/10.1109/TPAMI.2010.57", month="January", number="1", publisher="IEEE Computer Society", volume="33", customData={"issn", "0162-8828", "numpages", "12", "doi", "10.1109/TPAMI.2010.57", "acmid", "1916695", "address", "Washington, DC, USA", "keywords", "High-dimensional indexing, High-dimensional indexing, image indexing, very large databases, approximate search., approximate search., image indexing, very large databases"})
public class ShortProductQuantiser {
    protected ShortNearestNeighbours[] assigners;

    public ShortProductQuantiser(ShortNearestNeighbours[] assigners) {
        this.assigners = assigners;
    }

    public byte[] quantise(short[] data) {
        byte[] quantised = new byte[this.assigners.length];
        int[] idx = new int[]{0};
        float[] dst = new float[]{0.0f};
        short[][] qus = new short[1][0];
        int from = 0;
        for (int i = 0; i < this.assigners.length; ++i) {
            int to = this.assigners[i].numDimensions();
            qus[0] = Arrays.copyOfRange(data, from, from + to);
            this.assigners[i].searchNN((DATA[])qus, idx, dst);
            quantised[i] = (byte)(idx[0] - 128);
            from += to;
        }
        return quantised;
    }
}

