/*
 * Decompiled with CFR 0.152.
 */
package org.openjfx;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Profile;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.openjfx.JavaFXBaseMojo;
import org.openjfx.model.JavaFXModule;

@Mojo(name="run", requiresDependencyResolution=ResolutionScope.COMPILE)
@Execute(phase=LifecyclePhase.PROCESS_RESOURCES)
public class JavaFXRunFixMojo
extends JavaFXBaseMojo {
    @Parameter(readonly=true, required=true, defaultValue="${basedir}/pom.xml")
    String pom;
    @Parameter(readonly=true, required=true, defaultValue="${basedir}/runPom.xml")
    String runpom;
    @Parameter(readonly=true, required=true, defaultValue="${project.basedir}/modifiedPom.xml")
    String modifiedPom;
    @Parameter(defaultValue="${session}", readonly=true)
    MavenSession session;
    @Parameter(defaultValue="${javafx.platform}", readonly=true)
    String javafxPlatform;

    public void execute() throws MojoExecutionException {
        String osName = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        String classifier = "";
        if (osName.contains("mac")) {
            classifier = "mac";
        } else if (osName.contains("nux")) {
            classifier = "linux";
        } else if (osName.contains("windows")) {
            classifier = "win";
        } else {
            throw new MojoExecutionException("Error, os.name " + osName + " not supported");
        }
        String PLATFORM = this.javafxPlatform != null ? this.javafxPlatform : classifier;
        DefaultInvocationRequest invocationRequest = new DefaultInvocationRequest();
        invocationRequest.setProfiles(this.project.getActiveProfiles().stream().map(Profile::getId).collect(Collectors.toList()));
        invocationRequest.setProperties(this.session.getRequest().getUserProperties());
        File modifiedPomFile = new File(this.modifiedPom);
        try (FileInputStream is = new FileInputStream(new File(this.runpom).exists() ? this.runpom : this.pom);){
            Model model = new MavenXpp3Reader().read((InputStream)is);
            HashSet javaFXDependencies = new HashSet();
            ArrayList<Dependency> toRemove = new ArrayList<Dependency>();
            for (Dependency p : model.getDependencies()) {
                if (!p.getGroupId().equalsIgnoreCase("org.openjfx")) continue;
                toRemove.add(p);
                Optional<JavaFXModule> javaFXModule = JavaFXModule.fromArtifactName(p.getArtifactId());
                javaFXModule.ifPresent(module -> {
                    javaFXDependencies.add(module.getMavenDependency(PLATFORM, p.getVersion()));
                    javaFXDependencies.addAll(module.getTransitiveMavenDependencies(PLATFORM, p.getVersion()));
                });
            }
            model.getDependencies().removeAll(toRemove);
            model.getDependencies().addAll(javaFXDependencies);
            try (FileOutputStream os = new FileOutputStream(modifiedPomFile);){
                new MavenXpp3Writer().write((OutputStream)os, model);
            }
        }
        catch (Exception e) {
            if (modifiedPomFile.exists()) {
                modifiedPomFile.delete();
            }
            throw new MojoExecutionException("Error generating modified pom", e);
        }
        invocationRequest.setPomFile(modifiedPomFile);
        invocationRequest.setGoals(Collections.singletonList("javafx:dorun"));
        invocationRequest.setUserSettingsFile(this.session.getRequest().getUserSettingsFile());
        DefaultInvoker invoker = new DefaultInvoker();
        try {
            InvocationResult invocationResult = invoker.execute((InvocationRequest)invocationRequest);
            if (invocationResult.getExitCode() != 0) {
                throw new MojoExecutionException("Error, javafx:run failed", (Exception)invocationResult.getExecutionException());
            }
        }
        catch (MavenInvocationException e) {
            e.printStackTrace();
            throw new MojoExecutionException("Error", (Exception)((Object)e));
        }
        finally {
            if (modifiedPomFile.exists()) {
                modifiedPomFile.delete();
            }
        }
    }
}

