/*
 * Decompiled with CFR 0.152.
 */
package org.openjfx.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Stream;
import org.openjfx.model.JavaFXDependency;

public enum JavaFXModule {
    BASE(new JavaFXModule[0]),
    GRAPHICS(BASE),
    CONTROLS(BASE, GRAPHICS),
    FXML(BASE, GRAPHICS),
    MEDIA(BASE, GRAPHICS),
    SWING(BASE, GRAPHICS),
    WEB(BASE, CONTROLS, GRAPHICS, MEDIA);

    static final String PREFIX_MODULE = "javafx.";
    private static final String PREFIX_ARTIFACT = "javafx-";
    private List<JavaFXModule> dependentModules;

    private JavaFXModule(JavaFXModule ... dependentModules) {
        this.dependentModules = List.of(dependentModules);
    }

    public static Optional<JavaFXModule> fromArtifactName(String artifactName) {
        return Stream.of(JavaFXModule.values()).filter(javaFXModule -> artifactName.equals(javaFXModule.getArtifactName())).findFirst();
    }

    public String getModuleName() {
        return PREFIX_MODULE + this.name().toLowerCase(Locale.ROOT);
    }

    public String getModuleJarFileName() {
        return this.getModuleName() + ".jar";
    }

    public String getArtifactName() {
        return PREFIX_ARTIFACT + this.name().toLowerCase(Locale.ROOT);
    }

    public List<JavaFXModule> getDependentModules() {
        return this.dependentModules;
    }

    public List<JavaFXDependency> getTransitiveMavenDependencies(String platform, String version) {
        ArrayList<JavaFXDependency> mavenDependencies = new ArrayList<JavaFXDependency>();
        for (JavaFXModule dependentModule : this.dependentModules) {
            mavenDependencies.add(dependentModule.getMavenDependency(platform, version));
        }
        return mavenDependencies;
    }

    public JavaFXDependency getMavenDependency(String platform, String version) {
        JavaFXDependency dependency = new JavaFXDependency(this.getArtifactName(), version);
        dependency.setVersion(version);
        dependency.setClassifier(platform);
        return dependency;
    }
}

