/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.rio.helpers;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.RioSetting;
import org.openrdf.rio.WriterConfig;

public abstract class AbstractRDFWriter
implements RDFWriter {
    protected Map<String, String> namespaceTable;
    private WriterConfig writerConfig = new WriterConfig();

    @Override
    public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
        this.namespaceTable.put(prefix, uri);
    }

    @Override
    public RDFWriter setWriterConfig(WriterConfig config) {
        this.writerConfig = config;
        return this;
    }

    @Override
    public WriterConfig getWriterConfig() {
        return this.writerConfig;
    }

    @Override
    public Collection<RioSetting<?>> getSupportedSettings() {
        return Collections.emptyList();
    }

    @Override
    public <T> RDFWriter set(RioSetting<T> setting, T value) {
        this.getWriterConfig().set((RioSetting)setting, (Object)value);
        return this;
    }
}

