/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.rio.nquads;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.ntriples.NTriplesUtil;
import org.openrdf.rio.ntriples.NTriplesWriter;

public class NQuadsWriter
extends NTriplesWriter {
    public NQuadsWriter(OutputStream outputStream) {
        super(outputStream);
    }

    public NQuadsWriter(Writer writer) {
        super(writer);
    }

    public void handleStatement(Statement st) throws RDFHandlerException {
        if (!this.writingStarted) {
            throw new RuntimeException("Document writing has not yet been started");
        }
        try {
            NTriplesUtil.append((Resource)st.getSubject(), (Appendable)this.writer);
            this.writer.write(" ");
            NTriplesUtil.append((URI)st.getPredicate(), (Appendable)this.writer);
            this.writer.write(" ");
            NTriplesUtil.append((Value)st.getObject(), (Appendable)this.writer);
            if (null != st.getContext()) {
                this.writer.write(" ");
                NTriplesUtil.append((Resource)st.getContext(), (Appendable)this.writer);
            }
            this.writer.write(" .\n");
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }
}

