/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.codehaus.plexus;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class PlexusFileUtilsRecipes
extends Recipe {
    public String getDisplayName() {
        return "`PlexusFileUtils` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster template recipes for `org.openrewrite.codehaus.plexus.PlexusFileUtils`.";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new DeleteDirectoryFileRecipe(), new DeleteDirectoryStringRecipe(), new FileExistsStringRecipe(), new GetFileRecipe()});
    }

    @NullMarked
    public static class DeleteDirectoryFileRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `FileUtils.deleteDirectory(File)` with JDK provided API";
        }

        public String getDescription() {
            return "Replace Plexus `FileUtils.deleteDirectory(File directory)` with JDK provided API.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.codehaus.plexus.util.FileUtils.deleteDirectory(#{dir:any(java.io.File)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.codehaus.plexus.util.FileUtils");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.apache.commons.io.FileUtils.deleteDirectory(#{dir:any(java.io.File)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.io.File", Boolean.valueOf(true)), new UsesType("org.codehaus.plexus.util.FileUtils", Boolean.valueOf(true)), new UsesMethod("org.codehaus.plexus.util.FileUtils deleteDirectory(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class DeleteDirectoryStringRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `FileUtils.deleteDirectory(String)` with JDK provided API";
        }

        public String getDescription() {
            return "Replace Plexus `FileUtils.deleteDirectory(String directory)` with JDK provided API.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.codehaus.plexus.util.FileUtils.deleteDirectory(#{dir:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.codehaus.plexus.util.FileUtils");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.apache.commons.io.FileUtils.deleteDirectory(new java.io.File(#{dir:any(java.lang.String)}));").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.codehaus.plexus.util.FileUtils", Boolean.valueOf(true)), new UsesMethod("org.codehaus.plexus.util.FileUtils deleteDirectory(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class FileExistsStringRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `FileUtils.fileExists(String)` with JDK provided API";
        }

        public String getDescription() {
            return "Replace Plexus `FileUtils.fileExists(String fileName)` with JDK provided API.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.codehaus.plexus.util.FileUtils.fileExists(#{fileName:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.codehaus.plexus.util.FileUtils");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"new java.io.File(#{fileName:any(java.lang.String)}).exists()").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.codehaus.plexus.util.FileUtils", Boolean.valueOf(true)), new UsesMethod("org.codehaus.plexus.util.FileUtils fileExists(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class GetFileRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `FileUtils.getFile(String)` with JDK provided API";
        }

        public String getDescription() {
            return "Replace Plexus `FileUtils.getFile(String fileName)` with JDK provided API.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.codehaus.plexus.util.FileUtils.getFile(#{fileName:any(java.lang.String)})").bindType("java.io.File").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.codehaus.plexus.util.FileUtils");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"new java.io.File(#{fileName:any(java.lang.String)})").bindType("java.io.File").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.io.File", Boolean.valueOf(true)), new UsesType("org.codehaus.plexus.util.FileUtils", Boolean.valueOf(true)), new UsesMethod("org.codehaus.plexus.util.FileUtils getFile(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

