/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.lang;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

public final class StringFormatted
extends Recipe {
    private static final MethodMatcher STRING_FORMAT = new MethodMatcher("java.lang.String format(String, ..)");

    public String getDisplayName() {
        return "Prefer `String.formatted(Object...)`";
    }

    public String getDescription() {
        return "Prefer `String.formatted(Object...)` over `String.format(String, Object...)` in Java 17 or higher.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesJavaVersion(17), new UsesMethod(STRING_FORMAT)}), (TreeVisitor)new StringFormattedVisitor());
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(1L);
    }

    @NonNull
    public String toString() {
        return "StringFormatted()";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StringFormatted)) {
            return false;
        }
        StringFormatted other = (StringFormatted)((Object)o);
        return other.canEqual((Object)this);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof StringFormatted;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    private static class StringFormattedVisitor
    extends JavaVisitor<ExecutionContext> {
        private StringFormattedVisitor() {
        }

        public J visitMethodInvocation(J.MethodInvocation m, ExecutionContext ctx) {
            m = (J.MethodInvocation)super.visitMethodInvocation(m, (Object)ctx);
            if (!STRING_FORMAT.matches((MethodCall)m) || m.getMethodType() == null) {
                return m;
            }
            List arguments = m.getArguments();
            boolean wrapperNotNeeded = StringFormattedVisitor.wrapperNotNeeded((Expression)arguments.get(0));
            this.maybeRemoveImport("java.lang.String.format");
            J.MethodInvocation mi = m.withName(m.getName().withSimpleName("formatted"));
            JavaType.Method formatted = m.getMethodType().getDeclaringType().getMethods().stream().filter(it -> it.getName().equals("formatted")).findAny().orElse(null);
            mi = mi.withMethodType(formatted);
            if (mi.getName().getType() != null) {
                mi = mi.withName(mi.getName().withType((JavaType)mi.getMethodType()));
            }
            J.Parentheses select = wrapperNotNeeded ? (Expression)arguments.get(0) : new J.Parentheses(Tree.randomId(), Space.EMPTY, Markers.EMPTY, JRightPadded.build((Object)((Expression)arguments.get(0))));
            mi = mi.withSelect((Expression)select);
            if ((mi = mi.withArguments(arguments.subList(1, arguments.size()))).getArguments().isEmpty()) {
                mi = mi.withArguments(Collections.singletonList(new J.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY)));
            }
            return this.maybeAutoFormat((J)m, (J)mi, ctx);
        }

        private static boolean wrapperNotNeeded(Expression expression) {
            return expression instanceof J.Identifier || expression instanceof J.Literal || expression instanceof J.MethodInvocation || expression instanceof J.FieldAccess;
        }
    }
}

