/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.guava;

import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.ShortenFullyQualifiedTypeReferences;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;

public class NoGuavaPredicatesEqualTo
extends Recipe {
    private static final MethodMatcher PREDICATES_EQUAL_TO = new MethodMatcher("com.google.common.base.Predicates equalTo(..)");

    public String getDisplayName() {
        return "Prefer `Predicate.isEqual(Object)`";
    }

    public String getDescription() {
        return "Prefer `Predicate.isEqual(Object)` over `Predicates.equalTo(Object)`.";
    }

    public Set<String> getTags() {
        return Collections.singleton("guava");
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(PREDICATES_EQUAL_TO), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                if (PREDICATES_EQUAL_TO.matches((MethodCall)method)) {
                    this.maybeRemoveImport("com.google.common.base.Predicates");
                    this.maybeAddImport("java.util.function.Predicate");
                    if (method.getMethodType().getParameterTypes().get(0) instanceof JavaType.Parameterized) {
                        String typeString = ((Expression)method.getArguments().get(0)).getType().toString();
                        J.MethodInvocation genericMethod = (J.MethodInvocation)JavaTemplate.builder((String)("Predicate.<" + typeString + ">isEqual(#{any(java.lang.Object)})")).imports(new String[]{"java.util.function.Predicate"}).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{method.getArguments().get(0)});
                        this.doAfterVisit((TreeVisitor)ShortenFullyQualifiedTypeReferences.modifyOnly((J)genericMethod));
                        return genericMethod;
                    }
                    return (J.MethodInvocation)JavaTemplate.builder((String)"Predicate.isEqual(#{any(java.lang.Object)})").imports(new String[]{"java.util.function.Predicate"}).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{method.getArguments().get(0)});
                }
                return super.visitMethodInvocation(method, (Object)ctx);
            }
        });
    }
}

