/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.JavadocVisitor;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Javadoc;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.java.tree.TypedTree;

public class UnnecessaryThrows
extends Recipe {
    public String getDisplayName() {
        return "Unnecessary throws";
    }

    public String getDescription() {
        return "Remove unnecessary `throws` declarations. This recipe will only remove unused, checked exceptions if:\n\n- The declaring class or the method declaration is `final`.\n- The method declaration is `static` or `private`.\n- The method overrides a method declaration in a super class and the super class does not throw the exception.\n- The method is `public` or `protected` and the exception is not documented via a JavaDoc as a `@throws` tag.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-S1130");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                J.MethodDeclaration m = super.visitMethodDeclaration(method, (Object)ctx);
                final Set unusedThrows = UnnecessaryThrows.this.findExceptionCandidates(method);
                if (!unusedThrows.isEmpty()) {
                    new JavaIsoVisitor<ExecutionContext>(){

                        public @Nullable J visit(@Nullable Tree tree, ExecutionContext ctx) {
                            if (unusedThrows.isEmpty()) {
                                return (J)tree;
                            }
                            return (J)super.visit(tree, (Object)ctx);
                        }

                        public J.Try.Resource visitTryResource(J.Try.Resource tryResource, ExecutionContext ctx) {
                            TypedTree resource = tryResource.getVariableDeclarations();
                            JavaType.FullyQualified resourceType = TypeUtils.asFullyQualified((JavaType)resource.getType());
                            if (resourceType != null) {
                                if (TypeUtils.isAssignableTo((JavaType)JavaType.ShallowClass.build((String)"java.io.Closeable"), (JavaType)resourceType)) {
                                    unusedThrows.remove(JavaType.ShallowClass.build((String)"java.io.IOException"));
                                } else if (TypeUtils.isAssignableTo((JavaType)JavaType.ShallowClass.build((String)"java.lang.AutoCloseable"), (JavaType)resourceType)) {
                                    unusedThrows.remove(JavaType.ShallowClass.build((String)"java.lang.Exception"));
                                }
                            }
                            return super.visitTryResource(tryResource, (Object)ctx);
                        }

                        public J.Throw visitThrow(J.Throw thrown, ExecutionContext ctx) {
                            JavaType.FullyQualified type = TypeUtils.asFullyQualified((JavaType)thrown.getException().getType());
                            if (type != null) {
                                unusedThrows.removeIf(t -> TypeUtils.isAssignableTo((JavaType)t, (JavaType)type));
                            }
                            return thrown;
                        }

                        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                            this.removeThrownTypes(method.getMethodType());
                            return super.visitMethodInvocation(method, (Object)ctx);
                        }

                        public J.NewClass visitNewClass(J.NewClass newClass, ExecutionContext ctx) {
                            this.removeThrownTypes(newClass.getConstructorType());
                            return super.visitNewClass(newClass, (Object)ctx);
                        }

                        private void removeThrownTypes(// Could not load outer class - annotation placement on inner may be incorrect
                        @Nullable JavaType.Method type) {
                            if (type != null) {
                                for (JavaType.FullyQualified thrownException : type.getThrownExceptions()) {
                                    unusedThrows.removeIf(t -> TypeUtils.isAssignableTo((JavaType)t, (JavaType)thrownException));
                                }
                            }
                        }
                    }.visit((Tree)m, ctx);
                    if (!unusedThrows.isEmpty()) {
                        m = m.withThrows(ListUtils.map((List)m.getThrows(), t -> {
                            JavaType.FullyQualified type = TypeUtils.asFullyQualified((JavaType)t.getType());
                            if (type != null && unusedThrows.contains(type)) {
                                this.maybeRemoveImport(type);
                                return null;
                            }
                            return t;
                        }));
                    }
                }
                return m;
            }
        };
    }

    private Set<JavaType.FullyQualified> findExceptionCandidates(// Could not load outer class - annotation placement on inner may be incorrect
    @Nullable J.MethodDeclaration method) {
        if (method == null || method.getMethodType() == null || method.isAbstract()) {
            return Collections.emptySet();
        }
        TreeSet<JavaType.FullyQualified> candidates = new TreeSet<JavaType.FullyQualified>(Comparator.comparing(JavaType.FullyQualified::getFullyQualifiedName));
        if (method.getThrows() != null) {
            for (NameTree exception : method.getThrows()) {
                if (exception.getType() == null || exception.getType() instanceof JavaType.Unknown) {
                    return Collections.emptySet();
                }
                if (!(exception.getType() instanceof JavaType.FullyQualified) || TypeUtils.isAssignableTo((JavaType)JavaType.ShallowClass.build((String)"java.lang.RuntimeException"), (JavaType)exception.getType())) continue;
                candidates.add(TypeUtils.asFullyQualified((JavaType)exception.getType()));
            }
        }
        if (candidates.isEmpty()) {
            return Collections.emptySet();
        }
        if (method.getMethodType().getDeclaringType() != null && method.getMethodType().getDeclaringType().getFlags().contains(Flag.Final) || method.isAbstract() || method.hasModifier(J.Modifier.Type.Static) || method.hasModifier(J.Modifier.Type.Private) || method.hasModifier(J.Modifier.Type.Final)) {
            return candidates;
        }
        Optional superMethod = TypeUtils.findOverriddenMethod((JavaType.Method)method.getMethodType());
        if (superMethod.isPresent()) {
            JavaType.Method baseMethod = (JavaType.Method)superMethod.get();
            baseMethod.getThrownExceptions();
            for (JavaType.FullyQualified baseException : baseMethod.getThrownExceptions()) {
                candidates.remove(baseException);
            }
        }
        if (!candidates.isEmpty()) {
            new JavaVisitor<Set<JavaType.FullyQualified>>(){

                protected JavadocVisitor<Set<JavaType.FullyQualified>> getJavadocVisitor() {
                    return new JavadocVisitor<Set<JavaType.FullyQualified>>((JavaVisitor)this){

                        public Javadoc visitThrows(Javadoc.Throws aThrows, Set<JavaType.FullyQualified> candidates) {
                            JavaType.FullyQualified exceptionType;
                            if (aThrows.getExceptionName() instanceof TypeTree && (exceptionType = TypeUtils.asFullyQualified((JavaType)((TypeTree)aThrows.getExceptionName()).getType())) != null) {
                                candidates.remove(exceptionType);
                            }
                            return super.visitThrows(aThrows, candidates);
                        }
                    };
                }
            }.visit((Tree)method, candidates);
        }
        return candidates;
    }
}

