/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.List;
import java.util.Optional;
import org.openrewrite.ExecutionContext;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Statement;

class RemoveUnreachableCodeVisitor
extends JavaVisitor<ExecutionContext> {
    RemoveUnreachableCodeVisitor() {
    }

    public J visitBlock(J.Block block, ExecutionContext executionContext) {
        List statements = (block = (J.Block)super.visitBlock(block, (Object)executionContext)).getStatements();
        Optional<Integer> maybeFirstJumpIndex = this.findFirstJump(statements);
        if (!maybeFirstJumpIndex.isPresent()) {
            return block;
        }
        int firstJumpIndex = maybeFirstJumpIndex.get();
        if (firstJumpIndex == statements.size() - 1) {
            return block;
        }
        List newStatements = statements.subList(0, firstJumpIndex + 1);
        return block.withStatements(newStatements);
    }

    private Optional<Integer> findFirstJump(List<Statement> statements) {
        for (int i = 0; i < statements.size(); ++i) {
            Statement statement = statements.get(i);
            if (!(statement instanceof J.Return) && !(statement instanceof J.Throw) && !(statement instanceof J.Break) && !(statement instanceof J.Continue)) continue;
            return Optional.of(i);
        }
        return Optional.empty();
    }
}

