/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.cleanup.SimplifyBooleanExpressionVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JLeftPadded;

public class SimplifyCompoundVisitor
extends JavaVisitor<ExecutionContext> {
    public J visitAssignmentOperation(J.AssignmentOperation assignOp, ExecutionContext ctx) {
        Expression cleanedUpAssignment = this.cleanupBooleanExpression(assignOp.getAssignment(), ctx);
        if (assignOp.getOperator() == J.AssignmentOperation.Type.BitAnd) {
            if (SimplifyCompoundVisitor.isLiteralTrue(cleanedUpAssignment)) {
                return null;
            }
            if (SimplifyCompoundVisitor.isLiteralFalse(cleanedUpAssignment)) {
                return this.maybeAutoFormat((J)assignOp, (J)new J.Assignment(Tree.randomId(), assignOp.getPrefix(), assignOp.getMarkers(), assignOp.getVariable(), JLeftPadded.build((Object)cleanedUpAssignment), assignOp.getType()), ctx);
            }
        } else if (assignOp.getOperator() == J.AssignmentOperation.Type.BitOr) {
            if (SimplifyCompoundVisitor.isLiteralFalse(cleanedUpAssignment)) {
                return null;
            }
            if (SimplifyCompoundVisitor.isLiteralTrue(cleanedUpAssignment)) {
                return this.maybeAutoFormat((J)assignOp, (J)new J.Assignment(Tree.randomId(), assignOp.getPrefix(), assignOp.getMarkers(), assignOp.getVariable(), JLeftPadded.build((Object)cleanedUpAssignment), assignOp.getType()), ctx);
            }
        }
        return super.visitAssignmentOperation(assignOp, (Object)ctx);
    }

    private <E extends Expression> E cleanupBooleanExpression(E expression, ExecutionContext ctx) {
        Expression ex1 = (Expression)new SimplifyBooleanExpressionVisitor().visitNonNull(expression, (Object)ctx, this.getCursor().getParentOrThrow());
        return (E)((Expression)new SimplifyBooleanExpressionVisitor().visitNonNull((Tree)ex1, (Object)ctx, this.getCursor().getParentOrThrow()));
    }

    private static boolean isLiteralTrue(@Nullable Expression expression) {
        return expression instanceof J.Literal && ((J.Literal)expression).getValue() == Boolean.valueOf(true);
    }

    private static boolean isLiteralFalse(@Nullable Expression expression) {
        return expression instanceof J.Literal && ((J.Literal)expression).getValue() == Boolean.valueOf(false);
    }
}

