/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.jmockit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.testing.jmockit.JMockitUtils;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaCoordinates;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;

class SetupStatementsRewriter {
    private final JavaVisitor<ExecutionContext> visitor;
    private J.Block methodBody;

    SetupStatementsRewriter(JavaVisitor<ExecutionContext> visitor, J.Block methodBody) {
        this.visitor = visitor;
        this.methodBody = methodBody;
    }

    J.Block rewriteMethodBody() {
        List statements = this.methodBody.getStatements();
        for (Statement s : statements) {
            if (!JMockitUtils.getJMockitBlock(s).isPresent()) continue;
            J.NewClass nc = (J.NewClass)s;
            HashSet<String> spies = new HashSet<String>();
            for (Expression newClassArg : nc.getArguments()) {
                if (!(newClassArg instanceof J.Identifier)) continue;
                spies.add(((J.Identifier)newClassArg).getSimpleName());
            }
            assert (nc.getBody() != null);
            if (nc.getBody().getStatements().isEmpty()) continue;
            J.Block expectationsBlock = (J.Block)nc.getBody().getStatements().get(0);
            ArrayList<J.Block> statementList = new ArrayList<J.Block>();
            if (TypeUtils.isAssignableTo((String)"mockit.Expectations", (JavaType)nc.getType()) || TypeUtils.isAssignableTo((String)"mockit.Verifications", (JavaType)nc.getType())) {
                statementList.addAll(nc.getBody().getStatements());
            } else {
                statementList.add(expectationsBlock);
            }
            ArrayList<Statement> setupStatements = new ArrayList<Statement>();
            ArrayList<Statement> newExpectationsBlockStatements = new ArrayList<Statement>();
            for (Statement statement : statementList) {
                for (Statement expectationStatement : ((J.Block)statement).getStatements()) {
                    if (!this.isSetupStatement(expectationStatement, spies)) {
                        newExpectationsBlockStatements.add(expectationStatement);
                        continue;
                    }
                    setupStatements.add(expectationStatement);
                }
            }
            Set<String> setupVariableNames = SetupStatementsRewriter.getVariableNames(setupStatements);
            Set<String> set = SetupStatementsRewriter.getVariableNames(this.methodBody.getStatements());
            boolean hasConflict = setupVariableNames.stream().anyMatch(set::contains);
            JavaCoordinates coordinates = nc.getCoordinates().before();
            if (!setupStatements.isEmpty()) {
                if (hasConflict) {
                    J.Block setupBlock = expectationsBlock.withStatements(setupStatements);
                    this.rewriteBodyStatement((Statement)setupBlock, coordinates);
                } else {
                    for (Statement setupStatement : setupStatements) {
                        this.rewriteBodyStatement(setupStatement, coordinates);
                        coordinates = setupStatement.getCoordinates().after();
                    }
                }
            }
            J.Block newExpectationsBlock = expectationsBlock.withStatements(newExpectationsBlockStatements);
            nc = nc.withBody(nc.getBody().withStatements(Collections.singletonList(newExpectationsBlock)));
            this.rewriteBodyStatement((Statement)nc, nc.getCoordinates().replace());
        }
        return this.methodBody;
    }

    private void rewriteBodyStatement(Statement statement, JavaCoordinates coordinates) {
        ArrayList<Statement> statements = new ArrayList<Statement>(this.methodBody.getStatements());
        if (coordinates.getMode() == JavaCoordinates.Mode.REPLACEMENT) {
            for (int i = 0; i < statements.size(); ++i) {
                if (!((Statement)statements.get(i)).isScope((Tree)coordinates.getTree())) continue;
                statements.set(i, statement);
                break;
            }
        } else {
            for (int i = 0; i < statements.size(); ++i) {
                if (!((Statement)statements.get(i)).isScope((Tree)coordinates.getTree())) continue;
                if (coordinates.getMode() == JavaCoordinates.Mode.BEFORE) {
                    statements.add(i, statement);
                } else {
                    statements.add(i + 1, statement);
                }
                break;
            }
        }
        this.methodBody = this.methodBody.withStatements(statements);
    }

    private boolean isSetupStatement(Statement expectationStatement, Set<String> spies) {
        if (expectationStatement instanceof J.MethodInvocation) {
            J.MethodInvocation methodInvocation = (J.MethodInvocation)expectationStatement;
            if (methodInvocation.getSelect() instanceof J.MethodInvocation) {
                return this.isSetupStatement((Statement)methodInvocation.getSelect(), spies);
            }
            if (methodInvocation.getSelect() instanceof J.Identifier) {
                return SetupStatementsRewriter.isNotMockIdentifier((J.Identifier)methodInvocation.getSelect(), spies);
            }
            if (methodInvocation.getSelect() instanceof J.FieldAccess) {
                return SetupStatementsRewriter.isNotMockIdentifier((J.Identifier)((J.FieldAccess)methodInvocation.getSelect()).getTarget(), spies);
            }
            return SetupStatementsRewriter.isNotMockIdentifier(methodInvocation.getName(), spies);
        }
        if (expectationStatement instanceof J.Assignment) {
            JavaType variableType = SetupStatementsRewriter.getVariableTypeFromAssignment((J.Assignment)expectationStatement);
            return !TypeUtils.isAssignableTo((String)"mockit.Invocations", (JavaType)variableType);
        }
        return true;
    }

    private static JavaType getVariableTypeFromAssignment(J.Assignment assignment) {
        J.FieldAccess fieldAccess;
        J.Identifier identifier = null;
        if (assignment.getVariable() instanceof J.Identifier) {
            identifier = (J.Identifier)assignment.getVariable();
        } else if (assignment.getVariable() instanceof J.FieldAccess && (fieldAccess = (J.FieldAccess)assignment.getVariable()).getTarget() instanceof J.Identifier) {
            identifier = (J.Identifier)fieldAccess.getTarget();
        }
        if (identifier == null) {
            return null;
        }
        return identifier.getFieldType() != null ? identifier.getFieldType().getOwner() : identifier.getType();
    }

    private static boolean isNotMockIdentifier(J.Identifier identifier, Set<String> spies) {
        if (spies.contains(identifier.getSimpleName())) {
            return false;
        }
        if (identifier.getType() instanceof JavaType.Method && TypeUtils.isAssignableTo((String)"mockit.Invocations", (JavaType)((JavaType.Method)identifier.getType()).getDeclaringType())) {
            return false;
        }
        JavaType.Variable fieldType = identifier.getFieldType();
        if (fieldType == null) {
            return true;
        }
        for (JavaType.FullyQualified annotationType : fieldType.getAnnotations()) {
            if (!TypeUtils.isAssignableTo((String)"mockit.Mocked", (JavaType)annotationType) && !TypeUtils.isAssignableTo((String)"mockit.Injectable", (JavaType)annotationType) && !TypeUtils.isAssignableTo((String)"mockit.Tested", (JavaType)annotationType)) continue;
            return false;
        }
        return true;
    }

    private static Set<String> getVariableNames(List<Statement> statements) {
        HashSet<String> variableNames = new HashSet<String>();
        for (Statement statement : statements) {
            if (!(statement instanceof J.VariableDeclarations)) continue;
            J.VariableDeclarations varDecls = (J.VariableDeclarations)statement;
            for (J.VariableDeclarations.NamedVariable namedVar : varDecls.getVariables()) {
                variableNames.add(namedVar.getSimpleName());
            }
        }
        return variableNames;
    }
}

