/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.tree;

import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openrewrite.DelegatingExecutionContext;
import org.openrewrite.ExecutionContext;
import org.openrewrite.ParseExceptionResult;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;
import org.openrewrite.quark.Quark;
import org.openrewrite.tree.ParsingEventListener;

public class ParsingExecutionContextView
extends DelegatingExecutionContext {
    private static final String PARSING_LISTENER = "org.openrewrite.core.parsingListener";
    private static final String CHARSET = "org.openrewrite.parser.charset";
    private static final String PARSING_FAILURES = "org.openrewrite.core.parsingFailures";

    public ParsingExecutionContextView(ExecutionContext delegate) {
        super(delegate);
    }

    public static ParsingExecutionContextView view(ExecutionContext ctx) {
        if (ctx instanceof ParsingExecutionContextView) {
            return (ParsingExecutionContextView)ctx;
        }
        return new ParsingExecutionContextView(ctx);
    }

    public ParsingExecutionContextView setParsingListener(ParsingEventListener listener) {
        this.putMessage(PARSING_LISTENER, listener);
        return this;
    }

    public ParsingEventListener getParsingListener() {
        return this.getMessage(PARSING_LISTENER, ParsingEventListener.NOOP);
    }

    public ParsingExecutionContextView parseFailure(Path path, Throwable t) {
        if (path.isAbsolute()) {
            throw new RuntimeException("Relative paths only");
        }
        this.putMessageInCollection(PARSING_FAILURES, new Quark(Tree.randomId(), path, Markers.EMPTY.addIfAbsent(new ParseExceptionResult(t)), null, null), ArrayList::new);
        return this;
    }

    public List<Quark> getParseFailures() {
        return this.getMessage(PARSING_FAILURES, Collections.emptyList());
    }

    public List<Quark> pollParseFailures() {
        return this.pollMessage(PARSING_FAILURES, Collections.emptyList());
    }

    public ParsingExecutionContextView setCharset(@Nullable Charset charset) {
        this.putMessage(CHARSET, charset);
        return this;
    }

    @Nullable
    public Charset getCharset() {
        return (Charset)this.getMessage(CHARSET);
    }
}

