/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.internal;

import java.util.regex.Pattern;
import org.openrewrite.Incubating;
import org.openrewrite.internal.StringUtils;

@Incubating(since="7.17.0")
public enum NameCaseConvention {
    LOWER_HYPHEN,
    LOWER_UNDERSCORE,
    LOWER_CAMEL,
    UPPER_CAMEL,
    UPPER_UNDERSCORE;

    private static final Pattern CAMEL_CASE_SPLIT;
    private static final int uppercaseAbbreviationMinLength = 3;

    public String format(String str) {
        return NameCaseConvention.format(this, str);
    }

    public static String format(NameCaseConvention convention, String str) {
        switch (convention.ordinal()) {
            case 0: {
                return NameCaseConvention.lowerHyphen(str);
            }
            case 1: {
                return NameCaseConvention.lowerUnderscore(str);
            }
            case 2: {
                return NameCaseConvention.toCamelCase(str, true);
            }
            case 3: {
                return NameCaseConvention.toCamelCase(str, false);
            }
            case 4: {
                return NameCaseConvention.upperUnderscore(str);
            }
        }
        return str;
    }

    public boolean matches(String str) {
        return NameCaseConvention.matches(this, str);
    }

    public static boolean matches(NameCaseConvention convention, String str) {
        if (str.isEmpty()) {
            return false;
        }
        switch (convention.ordinal()) {
            case 2: {
                if (!Character.isLowerCase(str.charAt(0)) && str.charAt(0) != '$') {
                    return false;
                }
                for (int i = 1; i < str.length(); ++i) {
                    char p = str.charAt(i - 1);
                    char c = str.charAt(i);
                    if (Character.isUpperCase(c) && Character.isUpperCase(p)) {
                        return false;
                    }
                    if (c != '_') continue;
                    return false;
                }
                return true;
            }
            case 3: {
                if (!Character.isUpperCase(str.charAt(0)) && str.charAt(0) != '$') {
                    return false;
                }
                for (int i = 1; i < str.length(); ++i) {
                    char p = str.charAt(i - 1);
                    char c = str.charAt(i);
                    if (Character.isUpperCase(c) && Character.isUpperCase(p)) {
                        return false;
                    }
                    if (c != '_') continue;
                    return false;
                }
                return true;
            }
            case 1: {
                for (int i = 0; i < str.length(); ++i) {
                    char c = str.charAt(i);
                    if (!Character.isAlphabetic(c) || !Character.isUpperCase(c)) continue;
                    return false;
                }
                return true;
            }
            case 4: {
                for (int i = 0; i < str.length(); ++i) {
                    char c = str.charAt(i);
                    if (!Character.isAlphabetic(c) || !Character.isLowerCase(c)) continue;
                    return false;
                }
                return true;
            }
            case 0: {
                for (int i = 0; i < str.length(); ++i) {
                    char c = str.charAt(i);
                    if (Character.isAlphabetic(c) && Character.isUpperCase(c)) {
                        return false;
                    }
                    if (c != '_') continue;
                    return false;
                }
                return true;
            }
        }
        return str.equals(NameCaseConvention.format(convention, str));
    }

    public static boolean equalsRelaxedBinding(String str0, String str1) {
        return LOWER_CAMEL.format(str0).equals(LOWER_CAMEL.format(str1));
    }

    public static boolean matchesGlobRelaxedBinding(String test, String pattern) {
        return StringUtils.matchesGlob(LOWER_CAMEL.format(test), LOWER_CAMEL.format(pattern));
    }

    public static boolean matchesRegexRelaxedBinding(String test, String pattern) {
        return LOWER_CAMEL.format(test).matches(LOWER_CAMEL.format(pattern));
    }

    private static String lowerHyphen(String str) {
        return NameCaseConvention.nameCaseJoiner(str.replace('_', '-').replace(' ', '-'), true, '-');
    }

    private static String lowerUnderscore(String str) {
        return NameCaseConvention.nameCaseJoiner(str.replace('-', '_').replace(' ', '_'), true, '_').toLowerCase();
    }

    private static String toCamelCase(String str, boolean lowerCaseFirstLetter) {
        int i;
        boolean allUpperCase = true;
        int strLength = str.length();
        boolean uppercaseAbbreviationIncluded = false;
        int uppercaseAbbreviationEndIndex = -1;
        for (i = 0; i < strLength; ++i) {
            char c = str.charAt(i);
            if (!Character.isLowerCase(c)) continue;
            allUpperCase = false;
            break;
        }
        if (i > 3) {
            uppercaseAbbreviationIncluded = true;
            uppercaseAbbreviationEndIndex = i - 1;
        }
        StringBuilder sb = new StringBuilder(strLength);
        if (allUpperCase) {
            str = str.toLowerCase();
        } else if (uppercaseAbbreviationIncluded) {
            String uppercaseAbbreviation = str.substring(0, uppercaseAbbreviationEndIndex);
            sb.append(StringUtils.capitalize(uppercaseAbbreviation.toLowerCase()));
            str = str.substring(uppercaseAbbreviationEndIndex);
        }
        for (String s : CAMEL_CASE_SPLIT.split(str)) {
            String capitalize = StringUtils.capitalize(s);
            sb.append(capitalize);
        }
        String result = sb.toString();
        if (lowerCaseFirstLetter) {
            return StringUtils.uncapitalize(result);
        }
        return result;
    }

    private static String upperUnderscore(String str) {
        return NameCaseConvention.nameCaseJoiner(str.replace('-', '_').replace(' ', '_'), false, '_').toUpperCase();
    }

    private static String nameCaseJoiner(String str, boolean lowerCaseFirstLetter, char separatorChar) {
        StringBuilder builder = new StringBuilder();
        if (lowerCaseFirstLetter) {
            char[] chars = str.toCharArray();
            boolean first = true;
            char last = '0';
            char secondLast = separatorChar;
            for (int i = 0; i < chars.length; ++i) {
                char c = chars[i];
                if (Character.isLowerCase(c) || !Character.isLetter(c)) {
                    first = false;
                    if (c != separatorChar) {
                        if (last == separatorChar) {
                            builder.append(separatorChar);
                        }
                        builder.append(c);
                    }
                } else {
                    char lowerCaseChar = Character.toLowerCase(c);
                    if (first) {
                        first = false;
                        builder.append(lowerCaseChar);
                    } else if (Character.isUpperCase(last) || last == '.') {
                        builder.append(lowerCaseChar);
                    } else if (Character.isDigit(last) && (Character.isUpperCase(secondLast) || secondLast == separatorChar)) {
                        builder.append(lowerCaseChar);
                    } else {
                        builder.append(separatorChar).append(lowerCaseChar);
                    }
                }
                if (i > 1) {
                    secondLast = last;
                }
                last = c;
            }
        } else {
            boolean first = true;
            char last = '0';
            for (char c : str.toCharArray()) {
                if (first) {
                    builder.append(c);
                    first = false;
                } else if (Character.isUpperCase(c) && !Character.isUpperCase(last)) {
                    if (c != separatorChar) {
                        builder.append(separatorChar);
                    }
                    builder.append(c);
                } else {
                    if (c == '.') {
                        first = true;
                    }
                    if (c != separatorChar) {
                        if (last == separatorChar) {
                            builder.append(separatorChar);
                        }
                        builder.append(c);
                    }
                }
                last = c;
            }
        }
        return builder.toString();
    }

    static {
        CAMEL_CASE_SPLIT = Pattern.compile("[\\s_-]");
    }
}

