/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.rpc.request;

import io.moderne.jsonrpc.JsonRpcMethod;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.rpc.RpcObjectData;
import org.openrewrite.rpc.RpcSendQueue;
import org.openrewrite.rpc.request.RpcRequest;

public final class GetRef
implements RpcRequest {
    private final int ref;

    @Generated
    public GetRef(int ref) {
        this.ref = ref;
    }

    @Generated
    public int getRef() {
        return this.ref;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetRef)) {
            return false;
        }
        GetRef other = (GetRef)o;
        return this.getRef() == other.getRef();
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getRef();
        return result;
    }

    @NonNull
    @Generated
    public String toString() {
        return "GetRef(ref=" + this.getRef() + ")";
    }

    public static class Handler
    extends JsonRpcMethod<GetRef> {
        private static final ExecutorService forkJoin = ForkJoinPool.commonPool();
        private final Map<Integer, Object> remoteRefs;
        private final IdentityHashMap<Object, Integer> localRefs;
        private final AtomicInteger batchSize;
        private final AtomicBoolean trace;
        private final Map<Integer, BlockingQueue<List<RpcObjectData>>> inProgress = new ConcurrentHashMap<Integer, BlockingQueue<List<RpcObjectData>>>();

        public List<RpcObjectData> handle(GetRef request) throws InterruptedException {
            Integer refId = request.getRef();
            Object after = this.localRefs.entrySet().stream().filter(e -> ((Integer)e.getValue()).equals(refId)).map(Map.Entry::getKey).findFirst().orElse(null);
            if (after == null) {
                ArrayList<RpcObjectData> deleted = new ArrayList<RpcObjectData>(2);
                deleted.add(new RpcObjectData(RpcObjectData.State.DELETE, null, null, null, null));
                deleted.add(new RpcObjectData(RpcObjectData.State.END_OF_OBJECT, null, null, null, null));
                return deleted;
            }
            BlockingQueue q = this.inProgress.computeIfAbsent(request.getRef(), id -> {
                ArrayBlockingQueue batch = new ArrayBlockingQueue(1);
                this.localRefs.remove(after);
                RpcSendQueue sendQueue = new RpcSendQueue(this.batchSize.get(), batch::put, this.localRefs, this.trace.get());
                forkJoin.submit(() -> {
                    try {
                        sendQueue.send(after, null, null);
                        this.remoteRefs.put((Integer)id, after);
                    }
                    catch (Throwable throwable) {
                    }
                    finally {
                        this.localRefs.put(after, (Integer)id);
                        sendQueue.put(new RpcObjectData(RpcObjectData.State.END_OF_OBJECT, null, null, null, null));
                        sendQueue.flush();
                    }
                    return 0;
                });
                return batch;
            });
            List batch = (List)q.take();
            if (((RpcObjectData)batch.get(batch.size() - 1)).getState() == RpcObjectData.State.END_OF_OBJECT) {
                this.inProgress.remove(request.getRef());
            }
            return batch;
        }

        @Generated
        public Handler(Map<Integer, Object> remoteRefs, IdentityHashMap<Object, Integer> localRefs, AtomicInteger batchSize, AtomicBoolean trace) {
            this.remoteRefs = remoteRefs;
            this.localRefs = localRefs;
            this.batchSize = batchSize;
            this.trace = trace;
        }
    }
}

