/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.search;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.marker.GitProvenance;
import org.openrewrite.table.CommitsByDay;
import org.openrewrite.table.DistinctCommitters;

public final class FindCommitters
extends ScanningRecipe<AtomicReference<GitProvenance>> {
    private final transient DistinctCommitters committers = new DistinctCommitters(this);
    private final transient CommitsByDay commitsByDay = new CommitsByDay(this);
    @Option(displayName="From date", required=false, description="Optional. Take into account only commits since this date (inclusive). Default will be the entire history.", example="2023-01-01")
    private final @Nullable String fromDate;

    @Override
    public String getDisplayName() {
        return "Find committers on repositories";
    }

    @Override
    public String getDescription() {
        return "List the committers on a repository.";
    }

    @Override
    public int maxCycles() {
        return 1;
    }

    @Override
    public AtomicReference<GitProvenance> getInitialValue(ExecutionContext ctx) {
        return new AtomicReference<GitProvenance>();
    }

    @Override
    public TreeVisitor<?, ExecutionContext> getScanner(final AtomicReference<GitProvenance> acc) {
        return Preconditions.check(acc.get() == null, new TreeVisitor<Tree, ExecutionContext>(){

            @Override
            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof SourceFile) {
                    SourceFile sourceFile = (SourceFile)tree;
                    sourceFile.getMarkers().findFirst(GitProvenance.class).ifPresent(provenance -> {
                        if (provenance.getCommitters() != null) {
                            acc.set(provenance);
                        }
                    });
                }
                return tree;
            }
        });
    }

    @Override
    public Collection<? extends SourceFile> generate(AtomicReference<GitProvenance> acc, ExecutionContext ctx) {
        GitProvenance gitProvenance = acc.get();
        if (gitProvenance != null) {
            LocalDate from = StringUtils.isBlank(this.fromDate) ? null : LocalDate.parse(this.fromDate);
            Collection<GitProvenance.Committer> committerList = FindCommitters.findCommitters(gitProvenance, from);
            for (GitProvenance.Committer committer : committerList) {
                this.committers.insertRow(ctx, new DistinctCommitters.Row(committer.getName(), committer.getEmail(), (LocalDate)committer.getCommitsByDay().lastKey(), committer.getCommitsByDay().values().stream().mapToInt(Integer::intValue).sum()));
                committer.getCommitsByDay().forEach((day, commits) -> this.commitsByDay.insertRow(ctx, new CommitsByDay.Row(committer.getName(), committer.getEmail(), (LocalDate)day, (int)commits)));
            }
        }
        return Collections.emptyList();
    }

    public static Collection<GitProvenance.Committer> findCommitters(GitProvenance gitProvenance, @Nullable LocalDate from) {
        LocalDate cutOff = from == null ? null : from.minusDays(1L);
        ArrayList<GitProvenance.Committer> committerList = new ArrayList<GitProvenance.Committer>();
        for (GitProvenance.Committer committer : Objects.requireNonNull(gitProvenance.getCommitters())) {
            if (cutOff != null && !committer.getCommitsByDay().keySet().stream().anyMatch(day -> day.isAfter(cutOff))) continue;
            committerList.add(committer);
        }
        return committerList;
    }

    @Generated
    public FindCommitters(@Nullable String fromDate) {
        this.fromDate = fromDate;
    }

    @Generated
    public DistinctCommitters getCommitters() {
        return this.committers;
    }

    @Generated
    public CommitsByDay getCommitsByDay() {
        return this.commitsByDay;
    }

    @Generated
    public @Nullable String getFromDate() {
        return this.fromDate;
    }

    @NonNull
    @Generated
    public String toString() {
        return "FindCommitters(committers=" + this.getCommitters() + ", commitsByDay=" + this.getCommitsByDay() + ", fromDate=" + this.getFromDate() + ")";
    }

    @Override
    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindCommitters)) {
            return false;
        }
        FindCommitters other = (FindCommitters)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$fromDate = this.getFromDate();
        String other$fromDate = other.getFromDate();
        return !(this$fromDate == null ? other$fromDate != null : !this$fromDate.equals(other$fromDate));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof FindCommitters;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $fromDate = this.getFromDate();
        result = result * 59 + ($fromDate == null ? 43 : $fromDate.hashCode());
        return result;
    }
}

