/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.text;

import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.text.PlainText;

public class PlainTextVisitor<P>
extends TreeVisitor<Tree, P> {
    @Override
    public boolean isAcceptable(SourceFile sourceFile, P p) {
        return sourceFile instanceof PlainText;
    }

    @Override
    public boolean isAdaptableTo(Class<? extends TreeVisitor> adaptTo) {
        if (adaptTo.isAssignableFrom(this.getClass())) {
            return true;
        }
        Class<Tree> theirs = this.visitorTreeType(adaptTo);
        return theirs.equals(PlainText.class) || theirs.equals(PlainText.Snippet.class);
    }

    public PlainText visitText(PlainText text, P p) {
        PlainText t = text;
        t = t.withMarkers(this.visitMarkers(t.getMarkers(), p));
        t = t.withSnippets(ListUtils.map(t.getSnippets(), s -> (PlainText.Snippet)this.visitAndCast((Tree)s, p)));
        return t;
    }

    public PlainText.Snippet visitSnippet(PlainText.Snippet snippet, P p) {
        return snippet.withMarkers(this.visitMarkers(snippet.getMarkers(), p));
    }
}

