/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.nio.file.Path;
import java.nio.file.PathMatcher;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

public final class DeleteSourceFiles
extends Recipe {
    @Option(displayName="File pattern", description="A glob expression representing a file path to delete (relative to the project root).", example=".github/workflows/*.yml")
    private final String filePattern;

    @Override
    public String getDisplayName() {
        return "Delete files";
    }

    @Override
    public String getDescription() {
        return "Delete files by source path.";
    }

    @Override
    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Override
            public @org.jspecify.annotations.Nullable Tree visit(@org.jspecify.annotations.Nullable Tree tree, ExecutionContext ctx) {
                SourceFile sourceFile;
                Path sourcePath;
                PathMatcher pathMatcher;
                if (tree instanceof SourceFile && (pathMatcher = (sourcePath = (sourceFile = (SourceFile)tree).getSourcePath()).getFileSystem().getPathMatcher("glob:" + DeleteSourceFiles.this.filePattern)).matches(sourcePath)) {
                    return null;
                }
                return tree;
            }
        };
    }

    @Generated
    public DeleteSourceFiles(String filePattern) {
        this.filePattern = filePattern;
    }

    @Generated
    public String getFilePattern() {
        return this.filePattern;
    }

    @NonNull
    @Generated
    public String toString() {
        return "DeleteSourceFiles(filePattern=" + this.getFilePattern() + ")";
    }

    @Override
    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteSourceFiles)) {
            return false;
        }
        DeleteSourceFiles other = (DeleteSourceFiles)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$filePattern = this.getFilePattern();
        String other$filePattern = other.getFilePattern();
        return !(this$filePattern == null ? other$filePattern != null : !this$filePattern.equals(other$filePattern));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof DeleteSourceFiles;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $filePattern = this.getFilePattern();
        result = result * 59 + ($filePattern == null ? 43 : $filePattern.hashCode());
        return result;
    }
}

