/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.ipc.http;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.time.Duration;
import java.util.Map;
import org.openrewrite.ipc.http.HttpSender;

public class HttpUrlConnectionSender
implements HttpSender {
    private static final int DEFAULT_CONNECT_TIMEOUT_MS = 1000;
    private static final int DEFAULT_READ_TIMEOUT_MS = 10000;
    private final int connectTimeoutMs;
    private final int readTimeoutMs;
    private final Proxy proxy;

    public HttpUrlConnectionSender(Duration connectTimeout, Duration readTimeout) {
        this(connectTimeout, readTimeout, null);
    }

    public HttpUrlConnectionSender(Duration connectTimeout, Duration readTimeout, Proxy proxy) {
        this.connectTimeoutMs = (int)connectTimeout.toMillis();
        this.readTimeoutMs = (int)readTimeout.toMillis();
        this.proxy = proxy;
    }

    public HttpUrlConnectionSender() {
        this.connectTimeoutMs = 1000;
        this.readTimeoutMs = 10000;
        this.proxy = null;
    }

    @Override
    public HttpSender.Response send(HttpSender.Request request) {
        try {
            InputStream is;
            HttpURLConnection con = this.proxy != null ? (HttpURLConnection)request.getUrl().openConnection(this.proxy) : (HttpURLConnection)request.getUrl().openConnection();
            if (request.getConnectTimeout() != null) {
                con.setConnectTimeout((int)request.getConnectTimeout().toMillis());
            } else {
                con.setConnectTimeout(this.connectTimeoutMs);
            }
            if (request.getReadTimeout() != null) {
                con.setReadTimeout((int)request.getReadTimeout().toMillis());
            } else {
                con.setReadTimeout(this.readTimeoutMs);
            }
            HttpSender.Method method = request.getMethod();
            con.setRequestMethod(method.name());
            for (Map.Entry<String, String> header : request.getRequestHeaders().entrySet()) {
                con.setRequestProperty(header.getKey(), header.getValue());
            }
            if (method != HttpSender.Method.GET) {
                con.setDoOutput(true);
                try (OutputStream os = con.getOutputStream();){
                    os.write(request.getEntity());
                    os.flush();
                }
            }
            int status = con.getResponseCode();
            Runnable onClose = () -> {
                try {
                    con.disconnect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            };
            if (con.getErrorStream() != null) {
                is = con.getErrorStream();
            } else if (status < 400 && con.getInputStream() != null) {
                is = con.getInputStream();
            } else {
                return new HttpSender.Response(status, new ByteArrayInputStream(new byte[0]), onClose);
            }
            return new HttpSender.Response(status, is, onClose);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

