/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.semver;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Validated;
import org.openrewrite.semver.LatestRelease;
import org.openrewrite.semver.Semver;

public class SetRange
extends LatestRelease {
    private static final Pattern SET_RANGE_PATTERN = Pattern.compile("([\\[(])(\\d+(\\.\\d+)?(\\.\\d+)?(\\.\\d+)?)?\\s*,\\s*(\\d+(\\.\\d+)?(\\.\\d+)?(\\.\\d+)?)?([\\])])");
    private final String upper;
    private final boolean upperClosed;
    private final String lower;
    private final boolean lowerClosed;

    private SetRange(String lower, boolean lowerClosed, String upper, boolean upperClosed, @Nullable String metadataPattern) {
        super(metadataPattern);
        this.lower = lower;
        this.lowerClosed = lowerClosed;
        this.upper = upper;
        this.upperClosed = upperClosed;
    }

    @Override
    public boolean isValid(@Nullable String currentVersion, String version) {
        return !(!super.isValid(currentVersion, version) || (!this.upperClosed || this.upper != null && super.compare(currentVersion, version, this.upper) > 0) && this.upper != null && super.compare(currentVersion, version, this.upper) >= 0 || (!this.lowerClosed || this.lower != null && super.compare(currentVersion, version, this.lower) < 0) && this.lower != null && super.compare(currentVersion, version, this.lower) <= 0);
    }

    public static Validated<SetRange> build(String pattern, @Nullable String metadataPattern) {
        Matcher matcher = SET_RANGE_PATTERN.matcher(pattern);
        if (!matcher.matches()) {
            return Validated.invalid("setRange", pattern, "not a set range");
        }
        return Validated.valid("setRange", new SetRange(matcher.group(2), "[".equals(matcher.group(1)), matcher.group(6), "]".equals(matcher.group(10)), metadataPattern));
    }

    @Override
    public int compare(@Nullable String currentVersion, String v1, String v2) {
        Validated<SetRange> maybeSetRangeV1 = SetRange.build(v1, null);
        Validated<SetRange> maybeSetRangeV2 = SetRange.build(v2, null);
        if (maybeSetRangeV1.isValid() && maybeSetRangeV2.isValid()) {
            SetRange setRangeV1 = Objects.requireNonNull(maybeSetRangeV1.getValue());
            SetRange setRangeV2 = Objects.requireNonNull(maybeSetRangeV2.getValue());
            int compare = super.compare(currentVersion, setRangeV1.upper, setRangeV2.upper);
            if (compare != 0) {
                return compare;
            }
            if (setRangeV1.upperClosed && !setRangeV2.upperClosed) {
                return 1;
            }
            if (!setRangeV1.upperClosed && setRangeV2.upperClosed) {
                return -1;
            }
            compare = super.compare(currentVersion, setRangeV1.lower, setRangeV2.lower);
            if (compare != 0) {
                return compare;
            }
            if (setRangeV1.lowerClosed && !setRangeV2.lowerClosed) {
                return -1;
            }
            if (!setRangeV1.lowerClosed && setRangeV2.lowerClosed) {
                return 1;
            }
            return 0;
        }
        if (maybeSetRangeV1.isValid()) {
            if (!Semver.isVersion(v2)) {
                return 1;
            }
            SetRange setRangeV1 = Objects.requireNonNull(maybeSetRangeV1.getValue());
            int compare = super.compare(currentVersion, setRangeV1.upper, v2);
            if (setRangeV1.upperClosed && compare < 0) {
                return compare;
            }
            if (!setRangeV1.upperClosed && compare == 0) {
                return -1;
            }
            compare = super.compare(currentVersion, setRangeV1.lower, v2);
            if (setRangeV1.lowerClosed && compare > 0) {
                return compare;
            }
            if (!setRangeV1.lowerClosed && compare == 0) {
                return 1;
            }
            return 0;
        }
        if (maybeSetRangeV2.isValid()) {
            if (!Semver.isVersion(v1)) {
                return -1;
            }
            SetRange setRangeV2 = Objects.requireNonNull(maybeSetRangeV2.getValue());
            int compare = super.compare(currentVersion, v1, setRangeV2.upper);
            if (setRangeV2.upperClosed && compare > 0) {
                return compare;
            }
            if (!setRangeV2.upperClosed && compare == 0) {
                return 1;
            }
            compare = super.compare(currentVersion, v1, setRangeV2.lower);
            if (setRangeV2.lowerClosed && compare < 0) {
                return compare;
            }
            if (!setRangeV2.lowerClosed && compare == 0) {
                return -1;
            }
            return 0;
        }
        return super.compare(currentVersion, v1, v2);
    }
}

