/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.rpc.request;

import io.moderne.jsonrpc.JsonRpcMethod;
import io.moderne.jsonrpc.internal.SnowflakeId;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Recipe;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.internal.RecipeLoader;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.rpc.internal.PreparedRecipeCache;
import org.openrewrite.rpc.request.PrepareRecipeResponse;
import org.openrewrite.rpc.request.RpcRequest;

public final class PrepareRecipe
implements RpcRequest {
    private final String id;
    private final Map<String, Object> options;

    @Generated
    public PrepareRecipe(String id, Map<String, Object> options) {
        this.id = id;
        this.options = options;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public Map<String, Object> getOptions() {
        return this.options;
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PrepareRecipe)) {
            return false;
        }
        PrepareRecipe other = (PrepareRecipe)o;
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Map<String, Object> this$options = this.getOptions();
        Map<String, Object> other$options = other.getOptions();
        return !(this$options == null ? other$options != null : !((Object)this$options).equals(other$options));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Map<String, Object> $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String toString() {
        return "PrepareRecipe(id=" + this.getId() + ", options=" + this.getOptions() + ")";
    }

    public static class Handler
    extends JsonRpcMethod<PrepareRecipe> {
        private final PreparedRecipeCache preparedRecipes;
        private final AtomicReference<@Nullable Loader> recipeLoader;

        protected Object handle(PrepareRecipe request) throws Exception {
            Loader loader = this.recipeLoader.get();
            if (loader == null) {
                loader = (recipeId, options) -> new RecipeLoader(null).load(recipeId, (Map<String, Object>)options);
            }
            Recipe recipe = loader.load(request.id, request.getOptions());
            String instanceId = SnowflakeId.generateId();
            this.preparedRecipes.getInstantiated().put(instanceId, recipe);
            return new PrepareRecipeResponse(instanceId, recipe.getDescriptor(), "edit:" + instanceId, Collections.emptyList(), recipe instanceof ScanningRecipe ? "scan:" + instanceId : null, Collections.emptyList());
        }

        @Generated
        public Handler(PreparedRecipeCache preparedRecipes, AtomicReference<@Nullable Loader> recipeLoader) {
            this.preparedRecipes = preparedRecipes;
            this.recipeLoader = recipeLoader;
        }
    }

    public static interface Loader {
        public Recipe load(String var1, Map<String, Object> var2) throws Exception;
    }
}

