/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.table;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.internal.lang.NonNull;

public class RecipeRunStats
extends DataTable<Row> {
    private final Map<String, RecipeTimers> recipeTimers = new ConcurrentHashMap<String, RecipeTimers>();
    private final Set<Path> sourceFileVisited = new HashSet<Path>();
    private final Set<Path> sourceFileChanged = new HashSet<Path>();

    public RecipeRunStats(Recipe recipe) {
        super(recipe, "Recipe performance", "Statistics used in analyzing the performance of recipes.");
    }

    public void recordSourceVisited(@Nullable SourceFile source) {
        if (source != null) {
            this.sourceFileVisited.add(source.getSourcePath());
        }
    }

    public void recordSourceFileChanged(@Nullable SourceFile before, @Nullable SourceFile after) {
        if (after != null) {
            this.sourceFileChanged.add(after.getSourcePath());
        } else if (before != null) {
            this.sourceFileChanged.add(before.getSourcePath());
        }
    }

    public void recordScan(Recipe recipe, Callable<SourceFile> scan) throws Exception {
        this.recipeTimers.computeIfAbsent(recipe.getName(), k -> new RecipeTimers()).recordScan(scan);
    }

    public @Nullable SourceFile recordEdit(Recipe recipe, Callable<SourceFile> edit) throws Exception {
        return this.recipeTimers.computeIfAbsent(recipe.getName(), k -> new RecipeTimers()).recordEdit(edit);
    }

    public void flush(ExecutionContext ctx) {
        for (Map.Entry<String, RecipeTimers> entry : this.recipeTimers.entrySet()) {
            String recipeName = entry.getKey();
            RecipeTimers timers = entry.getValue();
            Row row = new Row(recipeName, this.sourceFileVisited.size(), this.sourceFileChanged.size(), timers.scan.getTotalNs(), timers.scan.getMaxNs(), timers.edit.getTotalNs(), timers.edit.getMaxNs());
            this.addRowToDataTable(ctx, row);
        }
    }

    private void addRowToDataTable(ExecutionContext ctx, Row row) {
        ctx.computeMessage("org.openrewrite.dataTables", row, ConcurrentHashMap::new, (extract, allDataTables) -> {
            List dataTablesOfType = (List)allDataTables.computeIfAbsent(this, c -> new ArrayList());
            dataTablesOfType.add(row);
            return allDataTables;
        });
    }

    private static class RecipeTimers {
        final PhaseTimer scan = new PhaseTimer();
        final PhaseTimer edit = new PhaseTimer();

        private RecipeTimers() {
        }

        void recordScan(Callable<SourceFile> scanCallable) throws Exception {
            this.scan.recordTimed(scanCallable);
        }

        @Nullable SourceFile recordEdit(Callable<SourceFile> editCallable) throws Exception {
            return this.edit.recordTimed(editCallable);
        }
    }

    public static final class Row {
        @Column(displayName="The recipe", description="The recipe whose stats are being measured both individually and cumulatively.")
        private final String recipe;
        @Column(displayName="Source file count", description="The number of source files the recipe ran over.")
        private final Integer sourceFiles;
        @Column(displayName="Source file changed count", description="The number of source files which were changed in the recipe run. Includes files created, deleted, and edited.")
        private final Integer sourceFilesChanged;
        @Column(displayName="Cumulative scanning time (ns)", description="The total time spent across the scanning phase of this recipe.")
        private final Long scanTotalTimeNs;
        @Column(displayName="Max scanning time (ns)", description="The max time scanning any one source file.")
        private final Long scanMaxNs;
        @Column(displayName="Cumulative edit time (ns)", description="The total time spent across the editing phase of this recipe.")
        private final Long editTotalTimeNs;
        @Column(displayName="Max edit time (ns)", description="The max time editing any one source file.")
        private final Long editMaxNs;

        @Generated
        public Row(String recipe, Integer sourceFiles, Integer sourceFilesChanged, Long scanTotalTimeNs, Long scanMaxNs, Long editTotalTimeNs, Long editMaxNs) {
            this.recipe = recipe;
            this.sourceFiles = sourceFiles;
            this.sourceFilesChanged = sourceFilesChanged;
            this.scanTotalTimeNs = scanTotalTimeNs;
            this.scanMaxNs = scanMaxNs;
            this.editTotalTimeNs = editTotalTimeNs;
            this.editMaxNs = editMaxNs;
        }

        @Generated
        public String getRecipe() {
            return this.recipe;
        }

        @Generated
        public Integer getSourceFiles() {
            return this.sourceFiles;
        }

        @Generated
        public Integer getSourceFilesChanged() {
            return this.sourceFilesChanged;
        }

        @Generated
        public Long getScanTotalTimeNs() {
            return this.scanTotalTimeNs;
        }

        @Generated
        public Long getScanMaxNs() {
            return this.scanMaxNs;
        }

        @Generated
        public Long getEditTotalTimeNs() {
            return this.editTotalTimeNs;
        }

        @Generated
        public Long getEditMaxNs() {
            return this.editMaxNs;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            Integer this$sourceFiles = this.getSourceFiles();
            Integer other$sourceFiles = other.getSourceFiles();
            if (this$sourceFiles == null ? other$sourceFiles != null : !((Object)this$sourceFiles).equals(other$sourceFiles)) {
                return false;
            }
            Integer this$sourceFilesChanged = this.getSourceFilesChanged();
            Integer other$sourceFilesChanged = other.getSourceFilesChanged();
            if (this$sourceFilesChanged == null ? other$sourceFilesChanged != null : !((Object)this$sourceFilesChanged).equals(other$sourceFilesChanged)) {
                return false;
            }
            Long this$scanTotalTimeNs = this.getScanTotalTimeNs();
            Long other$scanTotalTimeNs = other.getScanTotalTimeNs();
            if (this$scanTotalTimeNs == null ? other$scanTotalTimeNs != null : !((Object)this$scanTotalTimeNs).equals(other$scanTotalTimeNs)) {
                return false;
            }
            Long this$scanMaxNs = this.getScanMaxNs();
            Long other$scanMaxNs = other.getScanMaxNs();
            if (this$scanMaxNs == null ? other$scanMaxNs != null : !((Object)this$scanMaxNs).equals(other$scanMaxNs)) {
                return false;
            }
            Long this$editTotalTimeNs = this.getEditTotalTimeNs();
            Long other$editTotalTimeNs = other.getEditTotalTimeNs();
            if (this$editTotalTimeNs == null ? other$editTotalTimeNs != null : !((Object)this$editTotalTimeNs).equals(other$editTotalTimeNs)) {
                return false;
            }
            Long this$editMaxNs = this.getEditMaxNs();
            Long other$editMaxNs = other.getEditMaxNs();
            if (this$editMaxNs == null ? other$editMaxNs != null : !((Object)this$editMaxNs).equals(other$editMaxNs)) {
                return false;
            }
            String this$recipe = this.getRecipe();
            String other$recipe = other.getRecipe();
            return !(this$recipe == null ? other$recipe != null : !this$recipe.equals(other$recipe));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $sourceFiles = this.getSourceFiles();
            result = result * 59 + ($sourceFiles == null ? 43 : ((Object)$sourceFiles).hashCode());
            Integer $sourceFilesChanged = this.getSourceFilesChanged();
            result = result * 59 + ($sourceFilesChanged == null ? 43 : ((Object)$sourceFilesChanged).hashCode());
            Long $scanTotalTimeNs = this.getScanTotalTimeNs();
            result = result * 59 + ($scanTotalTimeNs == null ? 43 : ((Object)$scanTotalTimeNs).hashCode());
            Long $scanMaxNs = this.getScanMaxNs();
            result = result * 59 + ($scanMaxNs == null ? 43 : ((Object)$scanMaxNs).hashCode());
            Long $editTotalTimeNs = this.getEditTotalTimeNs();
            result = result * 59 + ($editTotalTimeNs == null ? 43 : ((Object)$editTotalTimeNs).hashCode());
            Long $editMaxNs = this.getEditMaxNs();
            result = result * 59 + ($editMaxNs == null ? 43 : ((Object)$editMaxNs).hashCode());
            String $recipe = this.getRecipe();
            result = result * 59 + ($recipe == null ? 43 : $recipe.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "RecipeRunStats.Row(recipe=" + this.getRecipe() + ", sourceFiles=" + this.getSourceFiles() + ", sourceFilesChanged=" + this.getSourceFilesChanged() + ", scanTotalTimeNs=" + this.getScanTotalTimeNs() + ", scanMaxNs=" + this.getScanMaxNs() + ", editTotalTimeNs=" + this.getEditTotalTimeNs() + ", editMaxNs=" + this.getEditMaxNs() + ")";
        }
    }

    private static class PhaseTimer {
        private long totalNs = 0L;
        private long maxNs = 0L;

        private PhaseTimer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        <T> T recordTimed(Callable<T> callable) throws Exception {
            long startNs = System.nanoTime();
            try {
                T t = callable.call();
                return t;
            }
            finally {
                long elapsedNs = System.nanoTime() - startNs;
                this.record(elapsedNs);
            }
        }

        private void record(long elapsedNs) {
            this.totalNs += elapsedNs;
            this.maxNs = Math.max(this.maxNs, elapsedNs);
        }

        @Generated
        public long getTotalNs() {
            return this.totalNs;
        }

        @Generated
        public long getMaxNs() {
            return this.maxNs;
        }
    }
}

