/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.search;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.gradle.marker.GradleDependencyConfiguration;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.marker.JavaProject;
import org.openrewrite.java.marker.JavaSourceSet;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.marker.Markup;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.maven.table.DependenciesInUse;
import org.openrewrite.maven.tree.Dependency;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;

public final class DependencyInsight
extends Recipe {
    private final transient DependenciesInUse dependenciesInUse = new DependenciesInUse((Recipe)this);
    private static final MethodMatcher DEPENDENCY_CONFIGURATION_MATCHER = new MethodMatcher("DependencyHandlerSpec *(..)");
    private static final MethodMatcher DEPENDENCY_CLOSURE_MATCHER = new MethodMatcher("RewriteGradleProject dependencies(..)");
    @Option(displayName="Group pattern", description="Group glob pattern used to match dependencies.", example="com.fasterxml.jackson.module")
    private final String groupIdPattern;
    @Option(displayName="Artifact pattern", description="Artifact glob pattern used to match dependencies.", example="jackson-module-*")
    private final String artifactIdPattern;
    @Option(displayName="Version", description="Match only dependencies with the specified version. Node-style [version selectors](https://docs.openrewrite.org/reference/dependency-version-selectors) may be used.All versions are searched by default.", example="1.x", required=false)
    @Nullable
    private final String version;
    @Option(displayName="Scope", description="Match dependencies with the specified scope. If not specified, all configurations will be searched.", example="compileClasspath", required=false)
    @Nullable
    private final String configuration;

    public String getDisplayName() {
        return "Gradle dependency insight";
    }

    public String getDescription() {
        return "Find direct and transitive dependencies matching a group, artifact, and optionally a configuration name. Results include dependencies that either directly match or transitively include a matching dependency.";
    }

    public Validated<Object> validate() {
        Validated v = super.validate();
        if (this.version != null) {
            v = v.and(Semver.validate((String)this.version, null));
        }
        return v;
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TreeVisitor<Tree, ExecutionContext>(){

            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                SourceFile sourceFile = (SourceFile)Objects.requireNonNull(tree);
                Optional maybeGradleProject = sourceFile.getMarkers().findFirst(GradleProject.class);
                if (!maybeGradleProject.isPresent()) {
                    return sourceFile;
                }
                GradleProject gp = (GradleProject)maybeGradleProject.get();
                String projectName = sourceFile.getMarkers().findFirst(JavaProject.class).map(JavaProject::getProjectName).orElse("");
                String sourceSetName = sourceFile.getMarkers().findFirst(JavaSourceSet.class).map(JavaSourceSet::getName).orElse("main");
                HashMap<String, Set<GroupArtifactVersion>> configurationToDirectDependency = new HashMap<String, Set<GroupArtifactVersion>>();
                HashMap<GroupArtifactVersion, Set<GroupArtifactVersion>> directDependencyToTargetDependency = new HashMap<GroupArtifactVersion, Set<GroupArtifactVersion>>();
                for (GradleDependencyConfiguration c : gp.getConfigurations()) {
                    if (DependencyInsight.this.configuration != null && !DependencyInsight.this.configuration.isEmpty() && !c.getName().equals(DependencyInsight.this.configuration)) continue;
                    for (ResolvedDependency resolvedDependency : c.getResolved()) {
                        ResolvedDependency dep = resolvedDependency.findDependency(DependencyInsight.this.groupIdPattern, DependencyInsight.this.artifactIdPattern);
                        if (dep == null) continue;
                        if (DependencyInsight.this.version != null) {
                            VersionComparator versionComparator = (VersionComparator)Semver.validate((String)DependencyInsight.this.version, null).getValue();
                            if (versionComparator == null) {
                                sourceFile = (SourceFile)Markup.warn((Tree)sourceFile, (Throwable)new IllegalArgumentException("Could not construct a valid version comparator from " + DependencyInsight.this.version + "."));
                            } else if (!versionComparator.isValid(null, dep.getVersion())) continue;
                        }
                        GroupArtifactVersion requestedGav = new GroupArtifactVersion(resolvedDependency.getGroupId(), resolvedDependency.getArtifactId(), resolvedDependency.getVersion());
                        GroupArtifactVersion targetGav = new GroupArtifactVersion(dep.getGroupId(), dep.getArtifactId(), dep.getVersion());
                        configurationToDirectDependency.compute(c.getName(), (k, v) -> {
                            if (v == null) {
                                v = new LinkedHashSet<GroupArtifactVersion>();
                            }
                            v.add(requestedGav);
                            return v;
                        });
                        directDependencyToTargetDependency.compute(requestedGav, (k, v) -> {
                            if (v == null) {
                                v = new LinkedHashSet<GroupArtifactVersion>();
                            }
                            v.add(targetGav);
                            return v;
                        });
                        DependencyInsight.this.dependenciesInUse.insertRow(ctx, (Object)new DependenciesInUse.Row(projectName, sourceSetName, dep.getGroupId(), dep.getArtifactId(), dep.getVersion(), dep.getDatedSnapshotVersion(), dep.getRequested().getScope(), Integer.valueOf(dep.getDepth())));
                    }
                }
                if (directDependencyToTargetDependency.isEmpty()) {
                    return sourceFile;
                }
                for (GradleDependencyConfiguration c : gp.getConfigurations()) {
                    if (configurationToDirectDependency.containsKey(c.getName())) continue;
                    for (Dependency dependency : c.getRequested()) {
                        if (!directDependencyToTargetDependency.containsKey(new GroupArtifactVersion(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion()))) continue;
                        configurationToDirectDependency.compute(c.getName(), (k, v) -> {
                            if (v == null) {
                                v = new LinkedHashSet<GroupArtifactVersion>();
                            }
                            v.add(new GroupArtifactVersion(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion()));
                            return v;
                        });
                    }
                }
                return new MarkIndividualDependency(configurationToDirectDependency, directDependencyToTargetDependency).attachMarkers((Tree)sourceFile, ctx);
            }
        };
    }

    @Generated
    public DependencyInsight(String groupIdPattern, String artifactIdPattern, @Nullable String version, @Nullable String configuration) {
        this.groupIdPattern = groupIdPattern;
        this.artifactIdPattern = artifactIdPattern;
        this.version = version;
        this.configuration = configuration;
    }

    @Generated
    public DependenciesInUse getDependenciesInUse() {
        return this.dependenciesInUse;
    }

    @Generated
    public String getGroupIdPattern() {
        return this.groupIdPattern;
    }

    @Generated
    public String getArtifactIdPattern() {
        return this.artifactIdPattern;
    }

    @Nullable
    @Generated
    public String getVersion() {
        return this.version;
    }

    @Nullable
    @Generated
    public String getConfiguration() {
        return this.configuration;
    }

    @NonNull
    @Generated
    public String toString() {
        return "DependencyInsight(dependenciesInUse=" + this.getDependenciesInUse() + ", groupIdPattern=" + this.getGroupIdPattern() + ", artifactIdPattern=" + this.getArtifactIdPattern() + ", version=" + this.getVersion() + ", configuration=" + this.getConfiguration() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DependencyInsight)) {
            return false;
        }
        DependencyInsight other = (DependencyInsight)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$groupIdPattern = this.getGroupIdPattern();
        String other$groupIdPattern = other.getGroupIdPattern();
        if (this$groupIdPattern == null ? other$groupIdPattern != null : !this$groupIdPattern.equals(other$groupIdPattern)) {
            return false;
        }
        String this$artifactIdPattern = this.getArtifactIdPattern();
        String other$artifactIdPattern = other.getArtifactIdPattern();
        if (this$artifactIdPattern == null ? other$artifactIdPattern != null : !this$artifactIdPattern.equals(other$artifactIdPattern)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$configuration = this.getConfiguration();
        String other$configuration = other.getConfiguration();
        return !(this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof DependencyInsight;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $groupIdPattern = this.getGroupIdPattern();
        result = result * 59 + ($groupIdPattern == null ? 43 : $groupIdPattern.hashCode());
        String $artifactIdPattern = this.getArtifactIdPattern();
        result = result * 59 + ($artifactIdPattern == null ? 43 : $artifactIdPattern.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
        return result;
    }

    private static class MarkIndividualDependency
    extends JavaIsoVisitor<ExecutionContext> {
        private final Map<String, Set<GroupArtifactVersion>> configurationToDirectDependency;
        private final Map<GroupArtifactVersion, Set<GroupArtifactVersion>> directDependencyToTargetDependency;
        private boolean attachToDependencyClosure = false;
        private boolean hasMarker = false;

        public Tree attachMarkers(Tree before, ExecutionContext ctx) {
            Tree after = super.visitNonNull(before, (Object)ctx);
            if (!this.hasMarker) {
                if (after == before) {
                    this.attachToDependencyClosure = true;
                    after = super.visitNonNull(before, (Object)ctx);
                }
                if (after == before) {
                    String resultText = this.directDependencyToTargetDependency.values().stream().flatMap(Collection::stream).distinct().map(target -> target.getGroupId() + ":" + target.getArtifactId() + ":" + target.getVersion()).collect(Collectors.joining(","));
                    return SearchResult.found((Tree)after, (String)resultText);
                }
            }
            return after;
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
            if (DEPENDENCY_CLOSURE_MATCHER.matches((MethodCall)m)) {
                String resultText = this.directDependencyToTargetDependency.values().stream().flatMap(Collection::stream).distinct().map(target -> target.getGroupId() + ":" + target.getArtifactId() + ":" + target.getVersion()).collect(Collectors.joining(","));
                J.MethodInvocation after = (J.MethodInvocation)SearchResult.found((Tree)m, (String)resultText);
                if (after == m) {
                    this.hasMarker = true;
                }
                if (this.attachToDependencyClosure) {
                    return after;
                }
            }
            if (!DEPENDENCY_CONFIGURATION_MATCHER.matches((MethodCall)m) || !this.configurationToDirectDependency.containsKey(m.getSimpleName()) || m.getArguments().isEmpty()) {
                return m;
            }
            Expression arg = (Expression)m.getArguments().get(0);
            if (arg instanceof J.Literal && ((J.Literal)arg).getValue() instanceof String) {
                String[] gav = ((String)((J.Literal)arg).getValue()).split(":");
                if (gav.length < 2) {
                    return m;
                }
                String groupId = gav[0];
                String artifactId = gav[1];
                Optional<GroupArtifactVersion> maybeMatch = this.configurationToDirectDependency.get(m.getSimpleName()).stream().filter(dep -> Objects.equals(dep.getGroupId(), groupId) && Objects.equals(dep.getArtifactId(), artifactId)).findAny();
                if (!maybeMatch.isPresent()) {
                    return m;
                }
                GroupArtifactVersion direct = maybeMatch.get();
                if (groupId.equals(direct.getGroupId()) && artifactId.equals(direct.getArtifactId())) {
                    String resultText = this.directDependencyToTargetDependency.get(direct).stream().map(target -> target.getGroupId() + ":" + target.getArtifactId() + ":" + target.getVersion()).collect(Collectors.joining(","));
                    J.MethodInvocation result = (J.MethodInvocation)SearchResult.found((Tree)m, (String)resultText);
                    if (m == result) {
                        this.hasMarker = true;
                    }
                    return result;
                }
            } else if (arg instanceof G.MapEntry) {
                String groupId = null;
                String artifactId = null;
                for (Expression argExp : m.getArguments()) {
                    G.MapEntry gavPart;
                    if (!(argExp instanceof G.MapEntry) || !((gavPart = (G.MapEntry)argExp).getKey() instanceof J.Literal)) continue;
                    String key = (String)((J.Literal)gavPart.getKey()).getValue();
                    if ("group".equals(key)) {
                        groupId = (String)((J.Literal)gavPart.getValue()).getValue();
                    } else if ("name".equals(key)) {
                        artifactId = (String)((J.Literal)gavPart.getValue()).getValue();
                    }
                    if (groupId == null || artifactId == null) continue;
                    break;
                }
                String finalGroupId = groupId;
                String finalArtifactId = artifactId;
                Optional<GroupArtifactVersion> maybeMatch = this.configurationToDirectDependency.get(m.getSimpleName()).stream().filter(dep -> Objects.equals(dep.getGroupId(), finalGroupId) && Objects.equals(dep.getArtifactId(), finalArtifactId)).findAny();
                if (!maybeMatch.isPresent()) {
                    return m;
                }
                GroupArtifactVersion direct = maybeMatch.get();
                if (groupId.equals(direct.getGroupId()) && artifactId.equals(direct.getArtifactId())) {
                    String resultText = this.directDependencyToTargetDependency.get(direct).stream().map(target -> target.getGroupId() + ":" + target.getArtifactId() + ":" + target.getVersion()).collect(Collectors.joining(","));
                    J.MethodInvocation result = (J.MethodInvocation)SearchResult.found((Tree)m, (String)resultText);
                    if (m == result) {
                        this.hasMarker = true;
                    }
                    return result;
                }
            }
            return m;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MarkIndividualDependency)) {
                return false;
            }
            MarkIndividualDependency other = (MarkIndividualDependency)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (this.isAttachToDependencyClosure() != other.isAttachToDependencyClosure()) {
                return false;
            }
            if (this.isHasMarker() != other.isHasMarker()) {
                return false;
            }
            Map<String, Set<GroupArtifactVersion>> this$configurationToDirectDependency = this.getConfigurationToDirectDependency();
            Map<String, Set<GroupArtifactVersion>> other$configurationToDirectDependency = other.getConfigurationToDirectDependency();
            if (this$configurationToDirectDependency == null ? other$configurationToDirectDependency != null : !((Object)this$configurationToDirectDependency).equals(other$configurationToDirectDependency)) {
                return false;
            }
            Map<GroupArtifactVersion, Set<GroupArtifactVersion>> this$directDependencyToTargetDependency = this.getDirectDependencyToTargetDependency();
            Map<GroupArtifactVersion, Set<GroupArtifactVersion>> other$directDependencyToTargetDependency = other.getDirectDependencyToTargetDependency();
            return !(this$directDependencyToTargetDependency == null ? other$directDependencyToTargetDependency != null : !((Object)this$directDependencyToTargetDependency).equals(other$directDependencyToTargetDependency));
        }

        @Generated
        protected boolean canEqual(@Nullable Object other) {
            return other instanceof MarkIndividualDependency;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isAttachToDependencyClosure() ? 79 : 97);
            result = result * 59 + (this.isHasMarker() ? 79 : 97);
            Map<String, Set<GroupArtifactVersion>> $configurationToDirectDependency = this.getConfigurationToDirectDependency();
            result = result * 59 + ($configurationToDirectDependency == null ? 43 : ((Object)$configurationToDirectDependency).hashCode());
            Map<GroupArtifactVersion, Set<GroupArtifactVersion>> $directDependencyToTargetDependency = this.getDirectDependencyToTargetDependency();
            result = result * 59 + ($directDependencyToTargetDependency == null ? 43 : ((Object)$directDependencyToTargetDependency).hashCode());
            return result;
        }

        @Generated
        public MarkIndividualDependency(Map<String, Set<GroupArtifactVersion>> configurationToDirectDependency, Map<GroupArtifactVersion, Set<GroupArtifactVersion>> directDependencyToTargetDependency) {
            this.configurationToDirectDependency = configurationToDirectDependency;
            this.directDependencyToTargetDependency = directDependencyToTargetDependency;
        }

        @Generated
        public Map<String, Set<GroupArtifactVersion>> getConfigurationToDirectDependency() {
            return this.configurationToDirectDependency;
        }

        @Generated
        public Map<GroupArtifactVersion, Set<GroupArtifactVersion>> getDirectDependencyToTargetDependency() {
            return this.directDependencyToTargetDependency;
        }

        @Generated
        public boolean isAttachToDependencyClosure() {
            return this.attachToDependencyClosure;
        }

        @Generated
        public boolean isHasMarker() {
            return this.hasMarker;
        }

        @Generated
        public void setAttachToDependencyClosure(boolean attachToDependencyClosure) {
            this.attachToDependencyClosure = attachToDependencyClosure;
        }

        @Generated
        public void setHasMarker(boolean hasMarker) {
            this.hasMarker = hasMarker;
        }

        @NonNull
        @Generated
        public String toString() {
            return "DependencyInsight.MarkIndividualDependency(configurationToDirectDependency=" + this.getConfigurationToDirectDependency() + ", directDependencyToTargetDependency=" + this.getDirectDependencyToTargetDependency() + ", attachToDependencyClosure=" + this.isAttachToDependencyClosure() + ", hasMarker=" + this.isHasMarker() + ")";
        }
    }
}

