/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.gradle.GradleParser;
import org.openrewrite.gradle.IsBuildGradle;
import org.openrewrite.gradle.internal.ChangeStringLiteral;
import org.openrewrite.groovy.GroovyIsoVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;
import org.openrewrite.kotlin.KotlinIsoVisitor;
import org.openrewrite.kotlin.KotlinParser;
import org.openrewrite.kotlin.tree.K;
import org.openrewrite.marker.Markers;
import org.openrewrite.marker.SearchResult;

public final class UpdateJavaCompatibility
extends Recipe {
    private static final MethodMatcher SOURCE_COMPATIBILITY_DSL = new MethodMatcher("RewriteGradleProject setSourceCompatibility(..)");
    private static final MethodMatcher TARGET_COMPATIBILITY_DSL = new MethodMatcher("RewriteGradleProject setTargetCompatibility(..)");
    @Option(displayName="Java version", description="The Java version to upgrade to.", example="11")
    private final Integer version;
    @Option(displayName="Compatibility type", description="The compatibility type to change", valid={"source", "target"}, required=false)
    private final @Nullable CompatibilityType compatibilityType;
    @Option(displayName="Declaration style", description="The desired style to write the new version as when being written to the `sourceCompatibility` or `targetCompatibility` variables. Default, match current source style. (ex. Enum: `JavaVersion.VERSION_11`, Number: 11, or String: \"11\")", valid={"Enum", "Number", "String"}, required=false)
    private final @Nullable DeclarationStyle declarationStyle;
    @Option(displayName="Allow downgrade", description="Allow downgrading the Java version.", required=false)
    private final @Nullable Boolean allowDowngrade;
    @Option(displayName="Add compatibility type if missing", description="Adds the specified compatibility type if one is not found.", required=false)
    private final @Nullable Boolean addIfMissing;
    private static final String SOURCE_COMPATIBILITY_FOUND = "SOURCE_COMPATIBILITY_FOUND";
    private static final String TARGET_COMPATIBILITY_FOUND = "TARGET_COMPATIBILITY_FOUND";

    public String getDisplayName() {
        return "Update Gradle project Java compatibility";
    }

    public String getDescription() {
        return "Find and updates the Java compatibility for the Gradle project.";
    }

    public Validated<Object> validate() {
        return super.validate().and(Validated.test((String)"version", (String)"Version must be > 0.", (Object)this.version, v -> v > 0));
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new IsBuildGradle(), (TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new GroovyScriptVisitor(), new KotlinScriptVisitor()}));
    }

    public J.Assignment handleAssignment(J.Assignment a, Cursor c, Class<?> enclosing) {
        if (a.getVariable() instanceof J.Identifier) {
            J.Identifier variable = (J.Identifier)a.getVariable();
            if ("sourceCompatibility".equals(variable.getSimpleName())) {
                c.putMessageOnFirstEnclosing(enclosing, SOURCE_COMPATIBILITY_FOUND, (Object)true);
            }
            if ("targetCompatibility".equals(variable.getSimpleName())) {
                c.putMessageOnFirstEnclosing(enclosing, TARGET_COMPATIBILITY_FOUND, (Object)true);
            }
            if (this.compatibilityType == null ? !"sourceCompatibility".equals(variable.getSimpleName()) && !"targetCompatibility".equals(variable.getSimpleName()) : !(this.compatibilityType.toString().toLowerCase() + "Compatibility").equals(variable.getSimpleName())) {
                return a;
            }
        } else if (a.getVariable() instanceof J.FieldAccess) {
            J.FieldAccess fieldAccess = (J.FieldAccess)a.getVariable();
            if (this.compatibilityType == null ? !("sourceCompatibility".equals(fieldAccess.getSimpleName()) || "targetCompatibility".equals(fieldAccess.getSimpleName()) || "release".equals(fieldAccess.getSimpleName()) && (fieldAccess.getTarget() instanceof J.Identifier && "options".equals(((J.Identifier)fieldAccess.getTarget()).getSimpleName()) || fieldAccess.getTarget() instanceof J.FieldAccess && "options".equals(((J.FieldAccess)fieldAccess.getTarget()).getSimpleName()))) : !(this.compatibilityType.toString().toLowerCase() + "Compatibility").equals(fieldAccess.getSimpleName())) {
                return a;
            }
        } else {
            return a;
        }
        DeclarationStyle currentStyle = this.getCurrentStyle(a.getAssignment());
        int currentMajor = this.getMajorVersion(a.getAssignment());
        if (this.shouldUpdateVersion(currentMajor) || this.shouldUpdateStyle(currentStyle)) {
            DeclarationStyle actualStyle = this.declarationStyle == null ? currentStyle : this.declarationStyle;
            return a.withAssignment(this.changeJavaVersion(a.getAssignment(), actualStyle));
        }
        return a;
    }

    private boolean shouldUpdateVersion(int currentMajor) {
        return currentMajor < this.version || currentMajor > this.version && Boolean.TRUE.equals(this.allowDowngrade);
    }

    private boolean shouldUpdateStyle(@Nullable DeclarationStyle currentStyle) {
        return this.declarationStyle != null && this.declarationStyle != currentStyle;
    }

    public J.MethodInvocation handleMethodInvocation(J.MethodInvocation m, Cursor c, Class<?> enclosing) {
        if ("sourceCompatibility".equals(m.getSimpleName())) {
            c.putMessageOnFirstEnclosing(enclosing, SOURCE_COMPATIBILITY_FOUND, (Object)true);
        }
        if ("targetCompatibility".equals(m.getSimpleName())) {
            c.putMessageOnFirstEnclosing(enclosing, TARGET_COMPATIBILITY_FOUND, (Object)true);
        }
        if (UpdateJavaCompatibility.isMethodInvocation((J)m, "JavaLanguageVersion", "of")) {
            J.Literal versionArg;
            List args = m.getArguments();
            if (args.size() == 1 && args.get(0) instanceof J.Literal && (versionArg = (J.Literal)args.get(0)).getValue() instanceof Integer) {
                Integer versionNumber = (Integer)versionArg.getValue();
                if (this.shouldUpdateVersion(versionNumber)) {
                    return m.withArguments(Collections.singletonList(versionArg.withValue((Object)this.version).withValueSource(this.version.toString())));
                }
                return m;
            }
            return (J.MethodInvocation)SearchResult.found((Tree)m, (String)("Attempted to update to Java version to " + this.version + "  but was unsuccessful, please update manually"));
        }
        if (SOURCE_COMPATIBILITY_DSL.matches((MethodCall)m) || TARGET_COMPATIBILITY_DSL.matches((MethodCall)m)) {
            if (this.compatibilityType != null && (this.compatibilityType == CompatibilityType.source && !SOURCE_COMPATIBILITY_DSL.matches((MethodCall)m) || this.compatibilityType == CompatibilityType.target && !TARGET_COMPATIBILITY_DSL.matches((MethodCall)m))) {
                return m;
            }
            if (m.getArguments().size() == 1 && (m.getArguments().get(0) instanceof J.Literal || m.getArguments().get(0) instanceof J.FieldAccess)) {
                DeclarationStyle currentStyle = this.getCurrentStyle((Expression)m.getArguments().get(0));
                int currentMajor = this.getMajorVersion((Expression)m.getArguments().get(0));
                if (this.shouldUpdateVersion(currentMajor) || this.shouldUpdateStyle(this.declarationStyle)) {
                    DeclarationStyle actualStyle = this.declarationStyle == null ? currentStyle : this.declarationStyle;
                    return m.withArguments(ListUtils.mapFirst((List)m.getArguments(), arg -> this.changeJavaVersion((Expression)arg, actualStyle)));
                }
                return m;
            }
            return (J.MethodInvocation)SearchResult.found((Tree)m, (String)("Attempted to update to Java version to " + this.version + "  but was unsuccessful, please update manually"));
        }
        return m;
    }

    private int getMajorVersion(@Nullable String version) {
        if (version == null) {
            return -1;
        }
        try {
            return Integer.parseInt(this.normalize(version));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private int getMajorVersion(Expression expression) {
        if (expression instanceof J.Literal) {
            J.Literal argument = (J.Literal)expression;
            JavaType.Primitive type = argument.getType();
            if (type == JavaType.Primitive.String) {
                return this.getMajorVersion((String)argument.getValue());
            }
            if (type == JavaType.Primitive.Int) {
                return (Integer)Objects.requireNonNull(argument.getValue());
            }
            if (type == JavaType.Primitive.Double) {
                return this.getMajorVersion(Objects.requireNonNull(argument.getValue()).toString());
            }
        } else {
            J.MethodInvocation method;
            if (expression instanceof J.FieldAccess) {
                J.FieldAccess field = (J.FieldAccess)expression;
                J.Identifier identifier = field.getName();
                return this.getMajorVersion(identifier.getSimpleName());
            }
            if (UpdateJavaCompatibility.isMethodInvocation((J)expression, "JavaVersion", "toVersion") && (method = (J.MethodInvocation)expression).getArguments().get(0) instanceof J.Literal) {
                return this.getMajorVersion((Expression)method.getArguments().get(0));
            }
        }
        return -1;
    }

    private @Nullable DeclarationStyle getCurrentStyle(Expression expression) {
        if (expression instanceof J.Literal) {
            J.Literal argument = (J.Literal)expression;
            JavaType.Primitive type = argument.getType();
            if (type == JavaType.Primitive.String) {
                return DeclarationStyle.String;
            }
            if (type == JavaType.Primitive.Int) {
                return DeclarationStyle.Number;
            }
            if (type == JavaType.Primitive.Double) {
                return DeclarationStyle.Number;
            }
        } else if (expression instanceof J.FieldAccess) {
            return DeclarationStyle.Enum;
        }
        return null;
    }

    private String normalize(String version) {
        if (version.contains("\"") || version.contains("'")) {
            version = version.replace("\"", "").replace("'", "");
        }
        if (!version.contains(".") && !version.contains("_")) {
            return version;
        }
        if (version.contains("_")) {
            String removePrefix = version.substring(version.indexOf("_") + 1);
            if (removePrefix.startsWith("1_")) {
                return removePrefix.substring(removePrefix.indexOf("_") + 1);
            }
            return removePrefix;
        }
        return version.substring(version.indexOf(".") + 1);
    }

    private Expression changeJavaVersion(Expression expression, @Nullable DeclarationStyle style) {
        String newJavaVersion = this.version <= 8 ? "1." + this.version : String.valueOf(this.version);
        String newJavaVersionEnum = this.version <= 8 ? "VERSION_1_" + this.version : "VERSION_" + this.version;
        double newJavaVersionDouble = Double.parseDouble("1." + this.version);
        if (expression instanceof J.Literal) {
            J.Literal literal = (J.Literal)expression;
            if (style == DeclarationStyle.String) {
                expression = literal.getType() == JavaType.Primitive.String ? ChangeStringLiteral.withStringValue(literal, newJavaVersion) : literal.withType((JavaType)JavaType.Primitive.String).withValue((Object)newJavaVersion).withValueSource("'" + newJavaVersion + "'");
            } else if (style == DeclarationStyle.Enum) {
                expression = this.changeJavaVersion(newJavaVersionEnum, literal.getPrefix(), literal.getMarkers());
            } else if (style == DeclarationStyle.Number) {
                expression = this.version <= 8 ? literal.withType((JavaType)JavaType.Primitive.Double).withValue((Object)newJavaVersionDouble).withValueSource("1." + this.version) : literal.withType((JavaType)JavaType.Primitive.Int).withValue((Object)this.version).withValueSource(String.valueOf(this.version));
            }
        } else if (expression instanceof J.FieldAccess) {
            J.FieldAccess fieldAccess = (J.FieldAccess)expression;
            if (style == DeclarationStyle.String) {
                expression = new J.Literal(Tree.randomId(), fieldAccess.getPrefix(), fieldAccess.getMarkers(), (Object)newJavaVersion, "'" + newJavaVersion + "'", Collections.emptyList(), JavaType.Primitive.String);
            } else if (style == DeclarationStyle.Enum) {
                expression = fieldAccess.withName(fieldAccess.getName().withSimpleName(newJavaVersionEnum));
            } else if (style == DeclarationStyle.Number) {
                expression = this.changeJavaVersion(newJavaVersionDouble, fieldAccess.getPrefix(), fieldAccess.getMarkers());
            }
        } else if (UpdateJavaCompatibility.isMethodInvocation((J)expression, "JavaVersion", "toVersion")) {
            J.MethodInvocation m = (J.MethodInvocation)expression;
            if (style == null) {
                expression = m.withArguments(ListUtils.mapFirst((List)m.getArguments(), arg -> {
                    if (arg instanceof J.Literal) {
                        if (arg.getType() == JavaType.Primitive.String) {
                            return this.changeJavaVersion((Expression)arg, DeclarationStyle.String);
                        }
                        if (arg.getType() == JavaType.Primitive.Int || arg.getType() == JavaType.Primitive.Double) {
                            return this.changeJavaVersion((Expression)arg, DeclarationStyle.Number);
                        }
                    }
                    return arg;
                }));
            } else if (style == DeclarationStyle.String) {
                expression = new J.Literal(Tree.randomId(), m.getPrefix(), m.getMarkers(), (Object)newJavaVersion, "'" + newJavaVersion + "'", Collections.emptyList(), JavaType.Primitive.String);
            } else if (style == DeclarationStyle.Enum) {
                expression = this.changeJavaVersion(newJavaVersionEnum, m.getPrefix(), m.getMarkers());
            } else if (style == DeclarationStyle.Number) {
                expression = this.changeJavaVersion(newJavaVersionDouble, m.getPrefix(), m.getMarkers());
            }
        }
        return expression;
    }

    private Expression changeJavaVersion(String newJavaVersionEnum, Space prefix, Markers markers) {
        return new J.FieldAccess(Tree.randomId(), prefix, markers, (Expression)new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), "JavaVersion", (JavaType)JavaType.ShallowClass.build((String)"org.gradle.api.JavaVersion"), null), new JLeftPadded(Space.EMPTY, (Object)new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), newJavaVersionEnum, null, null), Markers.EMPTY), (JavaType)JavaType.ShallowClass.build((String)"org.gradle.api.JavaVersion"));
    }

    private Expression changeJavaVersion(double newJavaVersionDouble, Space prefix, Markers markers) {
        if (this.version <= 8) {
            return new J.Literal(Tree.randomId(), prefix, markers, (Object)newJavaVersionDouble, String.valueOf(newJavaVersionDouble), Collections.emptyList(), JavaType.Primitive.Double);
        }
        return new J.Literal(Tree.randomId(), prefix, markers, (Object)this.version, String.valueOf(this.version), Collections.emptyList(), JavaType.Primitive.Int);
    }

    private static boolean isMethodInvocation(J expression, String clazz, String method) {
        return expression instanceof J.MethodInvocation && ((J.MethodInvocation)expression).getSimpleName().equals(method) && ((J.MethodInvocation)expression).getSelect() instanceof J.Identifier && ((J.Identifier)((J.MethodInvocation)expression).getSelect()).getSimpleName().equals(clazz);
    }

    private String styleMissingCompatibilityVersion(@Nullable DeclarationStyle declarationStyle) {
        if (declarationStyle == DeclarationStyle.String) {
            return this.version <= 8 ? "'1." + this.version + "'" : "'" + this.version + "'";
        }
        if (declarationStyle == DeclarationStyle.Enum) {
            return this.version <= 8 ? "JavaVersion.VERSION_1_" + this.version : "JavaVersion.VERSION_" + this.version;
        }
        if (this.version <= 8) {
            return "1." + this.version;
        }
        return String.valueOf(this.version);
    }

    @Generated
    public UpdateJavaCompatibility(Integer version, @Nullable CompatibilityType compatibilityType, @Nullable DeclarationStyle declarationStyle, @Nullable Boolean allowDowngrade, @Nullable Boolean addIfMissing) {
        this.version = version;
        this.compatibilityType = compatibilityType;
        this.declarationStyle = declarationStyle;
        this.allowDowngrade = allowDowngrade;
        this.addIfMissing = addIfMissing;
    }

    @Generated
    public Integer getVersion() {
        return this.version;
    }

    @Generated
    public @Nullable CompatibilityType getCompatibilityType() {
        return this.compatibilityType;
    }

    @Generated
    public @Nullable DeclarationStyle getDeclarationStyle() {
        return this.declarationStyle;
    }

    @Generated
    public @Nullable Boolean getAllowDowngrade() {
        return this.allowDowngrade;
    }

    @Generated
    public @Nullable Boolean getAddIfMissing() {
        return this.addIfMissing;
    }

    @NonNull
    @Generated
    public String toString() {
        return "UpdateJavaCompatibility(version=" + this.getVersion() + ", compatibilityType=" + (Object)((Object)this.getCompatibilityType()) + ", declarationStyle=" + (Object)((Object)this.getDeclarationStyle()) + ", allowDowngrade=" + this.getAllowDowngrade() + ", addIfMissing=" + this.getAddIfMissing() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateJavaCompatibility)) {
            return false;
        }
        UpdateJavaCompatibility other = (UpdateJavaCompatibility)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$version = this.getVersion();
        Integer other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        Boolean this$allowDowngrade = this.getAllowDowngrade();
        Boolean other$allowDowngrade = other.getAllowDowngrade();
        if (this$allowDowngrade == null ? other$allowDowngrade != null : !((Object)this$allowDowngrade).equals(other$allowDowngrade)) {
            return false;
        }
        Boolean this$addIfMissing = this.getAddIfMissing();
        Boolean other$addIfMissing = other.getAddIfMissing();
        if (this$addIfMissing == null ? other$addIfMissing != null : !((Object)this$addIfMissing).equals(other$addIfMissing)) {
            return false;
        }
        CompatibilityType this$compatibilityType = this.getCompatibilityType();
        CompatibilityType other$compatibilityType = other.getCompatibilityType();
        if (this$compatibilityType == null ? other$compatibilityType != null : !((Object)((Object)this$compatibilityType)).equals((Object)other$compatibilityType)) {
            return false;
        }
        DeclarationStyle this$declarationStyle = this.getDeclarationStyle();
        DeclarationStyle other$declarationStyle = other.getDeclarationStyle();
        return !(this$declarationStyle == null ? other$declarationStyle != null : !((Object)((Object)this$declarationStyle)).equals((Object)other$declarationStyle));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof UpdateJavaCompatibility;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        Boolean $allowDowngrade = this.getAllowDowngrade();
        result = result * 59 + ($allowDowngrade == null ? 43 : ((Object)$allowDowngrade).hashCode());
        Boolean $addIfMissing = this.getAddIfMissing();
        result = result * 59 + ($addIfMissing == null ? 43 : ((Object)$addIfMissing).hashCode());
        CompatibilityType $compatibilityType = this.getCompatibilityType();
        result = result * 59 + ($compatibilityType == null ? 43 : ((Object)((Object)$compatibilityType)).hashCode());
        DeclarationStyle $declarationStyle = this.getDeclarationStyle();
        result = result * 59 + ($declarationStyle == null ? 43 : ((Object)((Object)$declarationStyle)).hashCode());
        return result;
    }

    public static enum DeclarationStyle {
        Enum,
        Number,
        String;

    }

    public static enum CompatibilityType {
        source,
        target;

    }

    private class GroovyScriptVisitor
    extends GroovyIsoVisitor<ExecutionContext> {
        private GroovyScriptVisitor() {
        }

        public G.CompilationUnit visitCompilationUnit(G.CompilationUnit cu, ExecutionContext ctx) {
            G.CompilationUnit c = super.visitCompilationUnit(cu, (Object)ctx);
            if (this.getCursor().pollMessage(UpdateJavaCompatibility.SOURCE_COMPATIBILITY_FOUND) == null) {
                c = this.addCompatibilityTypeToSourceFile(c, "source", ctx);
            }
            if (this.getCursor().pollMessage(UpdateJavaCompatibility.TARGET_COMPATIBILITY_FOUND) == null) {
                c = this.addCompatibilityTypeToSourceFile(c, "target", ctx);
            }
            return c;
        }

        public J.Assignment visitAssignment(J.Assignment assignment, ExecutionContext ctx) {
            return UpdateJavaCompatibility.this.handleAssignment(super.visitAssignment(assignment, (Object)ctx), this.getCursor(), G.CompilationUnit.class);
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            return UpdateJavaCompatibility.this.handleMethodInvocation(super.visitMethodInvocation(method, (Object)ctx), this.getCursor(), G.CompilationUnit.class);
        }

        private G.CompilationUnit addCompatibilityTypeToSourceFile(G.CompilationUnit c, String targetCompatibilityType, ExecutionContext ctx) {
            if ((UpdateJavaCompatibility.this.compatibilityType == null || targetCompatibilityType.equals(UpdateJavaCompatibility.this.compatibilityType.toString())) && Boolean.TRUE.equals(UpdateJavaCompatibility.this.addIfMissing)) {
                G.CompilationUnit sourceFile = (G.CompilationUnit)GradleParser.builder().build().parse(ctx, new String[]{"\n" + targetCompatibilityType + "Compatibility = " + UpdateJavaCompatibility.this.styleMissingCompatibilityVersion(UpdateJavaCompatibility.this.declarationStyle)}).findFirst().orElseThrow(() -> new IllegalStateException("Unable to parse compatibility type as a Gradle file"));
                c = c.withStatements(ListUtils.concatAll((List)c.getStatements(), (List)sourceFile.getStatements()));
            }
            return c;
        }
    }

    private class KotlinScriptVisitor
    extends KotlinIsoVisitor<ExecutionContext> {
        private KotlinScriptVisitor() {
        }

        public K.CompilationUnit visitCompilationUnit(K.CompilationUnit cu, ExecutionContext ctx) {
            K.CompilationUnit c = super.visitCompilationUnit(cu, (Object)ctx);
            if (this.getCursor().pollMessage(UpdateJavaCompatibility.SOURCE_COMPATIBILITY_FOUND) == null) {
                c = this.addCompatibilityTypeToSourceFile(c, "source", ctx);
            }
            if (this.getCursor().pollMessage(UpdateJavaCompatibility.TARGET_COMPATIBILITY_FOUND) == null) {
                c = this.addCompatibilityTypeToSourceFile(c, "target", ctx);
            }
            return super.visitCompilationUnit(c, (Object)ctx);
        }

        public J.Assignment visitAssignment(J.Assignment assignment, ExecutionContext ctx) {
            return UpdateJavaCompatibility.this.handleAssignment(super.visitAssignment(assignment, (Object)ctx), this.getCursor(), K.CompilationUnit.class);
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            return UpdateJavaCompatibility.this.handleMethodInvocation(super.visitMethodInvocation(method, (Object)ctx), this.getCursor(), K.CompilationUnit.class);
        }

        private K.CompilationUnit addCompatibilityTypeToSourceFile(K.CompilationUnit c, String targetCompatibilityType, ExecutionContext ctx) {
            if ((UpdateJavaCompatibility.this.compatibilityType == null || targetCompatibilityType.equals(UpdateJavaCompatibility.this.compatibilityType.toString())) && Boolean.TRUE.equals(UpdateJavaCompatibility.this.addIfMissing)) {
                J withExistingJavaMethod = this.maybeAddToExistingJavaMethod(c, targetCompatibilityType, ctx);
                if (withExistingJavaMethod != c) {
                    return (K.CompilationUnit)withExistingJavaMethod;
                }
                K.CompilationUnit sourceFile = (K.CompilationUnit)KotlinParser.builder().isKotlinScript(true).build().parse(ctx, new String[]{"\n\njava {\n    " + targetCompatibilityType + "Compatibility = " + UpdateJavaCompatibility.this.styleMissingCompatibilityVersion(DeclarationStyle.Enum) + "\n}"}).findFirst().orElseThrow(() -> new IllegalStateException("Unable to parse compatibility type as a Gradle file"));
                c = c.withStatements(ListUtils.concatAll((List)c.getStatements(), (List)sourceFile.getStatements()));
            }
            return c;
        }

        private J maybeAddToExistingJavaMethod(K.CompilationUnit c, final String compatibilityType, ExecutionContext ctx) {
            return (J)new JavaIsoVisitor<ExecutionContext>(){

                public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                    if (method.getSimpleName().equals("java")) {
                        return new JavaIsoVisitor<ExecutionContext>(){

                            public J.Lambda visitLambda(J.Lambda lambda, ExecutionContext ctx) {
                                J.Block body = (J.Block)lambda.getBody();
                                List statements = body.getStatements();
                                K.CompilationUnit sourceFile = (K.CompilationUnit)KotlinParser.builder().isKotlinScript(true).build().parse(ctx, new String[]{"\n    " + compatibilityType + "Compatibility = " + UpdateJavaCompatibility.this.styleMissingCompatibilityVersion(DeclarationStyle.Enum)}).findFirst().orElseThrow(() -> new IllegalStateException("Unable to parse compatibility type as a Gradle file"));
                                return lambda.withBody((J)body.withStatements(ListUtils.concatAll((List)statements, (List)sourceFile.getStatements())));
                            }
                        }.visitMethodInvocation(method, (Object)ctx);
                    }
                    return super.visitMethodInvocation(method, (Object)ctx);
                }
            }.visitNonNull((Tree)c, (Object)ctx);
        }
    }
}

