/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.internal;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.maven.tree.Dependency;
import org.openrewrite.maven.tree.DependencyNotation;

public class InsertDependencyComparator
implements Comparator<Statement> {
    private final Map<Statement, Float> positions = new LinkedHashMap<Statement, Float>();
    private @Nullable Statement afterDependency;
    private @Nullable Statement beforeDependency;
    private static final Comparator<Statement> dependenciesComparator = (s1, s2) -> {
        String artifactId2;
        String groupId2;
        String configuration2;
        J.MethodInvocation d1 = s1 instanceof J.Return ? (J.MethodInvocation)((J.Return)s1).getExpression() : (J.MethodInvocation)s1;
        J.MethodInvocation d2 = s2 instanceof J.Return ? (J.MethodInvocation)((J.Return)s2).getExpression() : (J.MethodInvocation)s2;
        assert (d1 != null && d2 != null);
        String configuration1 = d1.getSimpleName();
        if (!configuration1.equals(configuration2 = d2.getSimpleName())) {
            return configuration1.compareTo(configuration2);
        }
        String groupId1 = InsertDependencyComparator.getEntry("group", d1).orElse("");
        if (!groupId1.equals(groupId2 = InsertDependencyComparator.getEntry("group", d2).orElse(""))) {
            return InsertDependencyComparator.comparePartByPart(groupId1, groupId2);
        }
        String artifactId1 = InsertDependencyComparator.getEntry("name", d1).orElse("");
        if (!artifactId1.equals(artifactId2 = InsertDependencyComparator.getEntry("name", d2).orElse(""))) {
            return InsertDependencyComparator.comparePartByPart(artifactId1, artifactId2);
        }
        String classifier1 = InsertDependencyComparator.getEntry("classifier", d1).orElse(null);
        String classifier2 = InsertDependencyComparator.getEntry("classifier", d2).orElse(null);
        if (classifier1 == null && classifier2 != null) {
            return -1;
        }
        if (classifier1 != null) {
            if (classifier2 == null) {
                return 1;
            }
            if (!classifier1.equals(classifier2)) {
                return classifier1.compareTo(classifier2);
            }
        }
        return InsertDependencyComparator.getEntry("version", d1).orElse("").compareTo(InsertDependencyComparator.getEntry("version", d2).orElse(""));
    };

    public InsertDependencyComparator(List<Statement> statements, J.MethodInvocation dependencyToAdd) {
        float f;
        int len = statements.size();
        for (int i = 0; i < len; ++i) {
            this.positions.put(statements.get(i), Float.valueOf(i));
        }
        ArrayList<Object> dependencies = new ArrayList<Object>(statements.size() + 1);
        for (Statement s : statements) {
            if (!(s instanceof J.MethodInvocation) && (!(s instanceof J.Return) || !(((J.Return)s).getExpression() instanceof J.MethodInvocation))) continue;
            dependencies.add(s);
        }
        if (dependencies.isEmpty()) {
            this.positions.put((Statement)dependencyToAdd, Float.valueOf((float)statements.size() + 0.5f));
            return;
        }
        dependencies.add(dependencyToAdd);
        dependencies.sort(dependenciesComparator);
        int len2 = dependencies.size();
        for (int i = 0; i < len2; ++i) {
            if (dependencyToAdd != dependencies.get(i)) continue;
            if (i > 0) {
                this.afterDependency = (Statement)dependencies.get(i - 1);
            }
            if (i + 1 >= dependencies.size()) break;
            this.beforeDependency = (Statement)dependencies.get(i + 1);
            break;
        }
        boolean isFirst = this.afterDependency == null;
        float f2 = f = isFirst ? 0.0f : this.positions.get(this.afterDependency).floatValue();
        while (f < (float)statements.size()) {
            Statement s = statements.get((int)f);
            if (s instanceof J.MethodInvocation || s instanceof J.Return && ((J.Return)s).getExpression() instanceof J.MethodInvocation) {
                this.positions.put((Statement)dependencyToAdd, Float.valueOf(this.positions.get(s).floatValue() + (isFirst ? -0.5f : 0.5f)));
                break;
            }
            f += 1.0f;
        }
    }

    @Override
    public int compare(Statement o1, Statement o2) {
        return this.positions.get(o1).compareTo(this.positions.get(o2));
    }

    private static Optional<String> getEntry(String entry, J.MethodInvocation invocation) {
        if (invocation.getArguments().get(0) instanceof J.Literal) {
            Object value = ((J.Literal)invocation.getArguments().get(0)).getValue();
            if (value == null) {
                return Optional.empty();
            }
            Dependency dependency = DependencyNotation.parse((String)((String)value));
            if (dependency == null) {
                return Optional.empty();
            }
            switch (entry) {
                case "group": {
                    return Optional.ofNullable(dependency.getGroupId());
                }
                case "name": {
                    return Optional.ofNullable(dependency.getArtifactId());
                }
                case "version": {
                    return Optional.ofNullable(dependency.getVersion());
                }
                case "classifier": {
                    return Optional.ofNullable(dependency.getClassifier());
                }
            }
        } else if (invocation.getArguments().get(0) instanceof G.MapEntry) {
            for (Expression e : invocation.getArguments()) {
                G.MapEntry mapEntry;
                if (!(e instanceof G.MapEntry) || !((mapEntry = (G.MapEntry)e).getKey() instanceof J.Literal) || !(mapEntry.getValue() instanceof J.Literal) || !entry.equals(((J.Literal)mapEntry.getKey()).getValue())) continue;
                return Optional.ofNullable((String)((J.Literal)mapEntry.getValue()).getValue());
            }
        }
        return Optional.empty();
    }

    private static int comparePartByPart(String d1, String d2) {
        String[] d1Parts = d1.split("[.-]");
        String[] d2Parts = d2.split("[.-]");
        for (int i = 0; i < Math.min(d1Parts.length, d2Parts.length); ++i) {
            if (d1Parts[i].equals(d2Parts[i])) continue;
            return d1Parts[i].compareTo(d2Parts[i]);
        }
        return d1Parts.length - d2Parts.length;
    }

    @Generated
    public @Nullable Statement getAfterDependency() {
        return this.afterDependency;
    }

    @Generated
    public @Nullable Statement getBeforeDependency() {
        return this.beforeDependency;
    }
}

